/*
                       Endeavour Mark II - Pixmap

	A "convience" pixmap containing a GdkPixmap pixmap and
	GdkBitmap mask pair with additional information including
	size, local reference counts, data source pointer, and an
	identification name or path.

	This is used as a convient way to load, store, and keep
	track of GdkPixmap-based icons throughout Endeavour's code.

	Note that EDVPixmap list utilities are in edv_utils_gtk.c.

 */

#ifndef EDV_PIXMAP_H
#define EDV_PIXMAP_H

#include <gtk/gtk.h>
#include "edv_types.h"

typedef struct _EDVPixmap			EDVPixmap;
#define EDV_PIXMAP(p)				((EDVPixmap *)(p))


/*
 *	Source Types:
 */
typedef enum {
	EDV_PIXMAP_SOURCE_DATA,			/* From a C declaration ID */
	EDV_PIXMAP_SOURCE_FILE			/* From a file */
} EDVPixmapSourceType;


/*
 *	Pixmap:
 */
struct _EDVPixmap {

	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	gint		width,
			height;

	gint		ref_count;

	EDVPixmapSourceType	source_type;

	/* The following members are used if source_type is
	 * EDV_PIXMAP_SOURCE_DATA */
	edv_pixmap_data	*data;			/* XPM data used to create
						 * this EDVPixmap (shared) */
	gchar		*name;			/* C Declaration ID name
						 * for member data */

	/* The following members are used if source_type is
	 * EDV_PIXMAP_SOURCE_FILE */
	gchar		*path;			/* Full path to the XPM file
						 * used to create this
						 * EDVPixmap */
};


/* EDVPixmaps List */
extern GList *edv_pixmaps_list_append_from_data(
        GList *pixmaps_list,
        edv_pixmap_data *data,
	const gchar *name,
        EDVPixmap **p_rtn   
);
extern GList *edv_pixmaps_list_append_from_file(
        GList *pixmaps_list,
        const gchar *path,
        EDVPixmap **p_rtn
);

extern GList *edv_pixmaps_list_clean(GList *pixmaps_list);

extern EDVPixmap *edv_pixmaps_list_match_name(
	GList *pixmaps_list,
	const gchar *name
);
extern EDVPixmap *edv_pixmaps_list_match_path(
        GList *pixmaps_list,
        const gchar *path
);

/* EDVPixmap */
extern EDVPixmap *edv_pixmap_new(void);
extern EDVPixmap *edv_pixmap_new_ref(void);
extern EDVPixmap *edv_pixmap_new_from_data(
	edv_pixmap_data *data,
	const gchar *name
);
extern EDVPixmap *edv_pixmap_new_from_file(const gchar *path);
extern gboolean edv_pixmap_resize(
	EDVPixmap *p,
	const gint new_width, const gint new_height
);
extern gboolean edv_pixmap_is_loaded(EDVPixmap *p);
extern gint edv_pixmap_ref_count(EDVPixmap *p);
extern EDVPixmap *edv_pixmap_ref(EDVPixmap *p);
extern EDVPixmap *edv_pixmap_unref(EDVPixmap *p);

/* EDVPixmap GDK/GTK */
GtkWidget *edv_pixmap_new_gtk_pixmap(EDVPixmap *p);
void edv_pixmap_set_gtk_pixmap(EDVPixmap *p, GtkWidget *w);


#endif	/* EDV_PIXMAP_H */
