/*
                   Endeavour Mark II - Open Callback Data

	The Open Callback Data is used by the GtkMenuItems of the Open
	To GtkMenus to open the selected objects on the VFS Browser
	and Image Browser.
 */

#ifndef EDV_OPEN_CB_H
#define EDV_OPEN_CB_H

#include <glib.h>
#include "edv_types.h"


typedef struct _EDVOpenCBData		EDVOpenCBData;
#define EDV_OPEN_CB_DATA(p)		((EDVOpenCBData *)(p))


/*
 *	Open Callback Data:
 */
struct _EDVOpenCBData {

	EDVCore		*core;
	gchar		*command_name;		/* EDVMIMETypeCommand
						 * name */

	/* Get paths list callback, to request the window's list of
	 * selected object paths
	 */
	GList		*(*paths_list_get_cb)(
		gpointer			/* paths_list_get_data */
	);
	gpointer	paths_list_get_data;

	/* Go to directory callback, to tell the window to go to the
	 * specified directory
	 */
	void		(*goto_directory_cb)(
		gpointer,			/* Data */
		const gchar *			/* goto_directory_data */
	);
	gpointer	goto_directory_data;

        GtkWidget	*toplevel;
	gboolean	verbose;

};


/* EDVOpenCBData */
extern EDVOpenCBData *edv_open_cb_data_new(void);
extern void edv_open_cb_data_delete(EDVOpenCBData *d);

/* Open To Callback */
extern void edv_open_cb(GtkWidget *widget, gpointer data);


#endif	/* EDV_OPEN_CB_H */
