#include <gtk/gtk.h>

#include "cdialog.h"

#include "libendeavour2-base/edv_path.h"
#include "edv_confirm.h"
#include "endeavour2.h"
#include "edv_open_cb.h"
#include "edv_open.h"


EDVOpenCBData *edv_open_cb_data_new(void);
void edv_open_cb_data_delete(EDVOpenCBData *d);

void edv_open_cb(GtkWidget *widget, gpointer data);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new Open Callback Data.
 */
EDVOpenCBData *edv_open_cb_data_new(void)
{
	return(EDV_OPEN_CB_DATA(g_malloc0(sizeof(EDVOpenCBData))));
}

/*
 *	Deletes the Open Callback Data.
 */
void edv_open_cb_data_delete(EDVOpenCBData *d)
{
	if(d == NULL)
		return;

	g_free(d->command_name);
	g_free(d);
}


/*
 *	Open Callback.
 *
 *	Used by the Open To menu items.
 */
void edv_open_cb(GtkWidget *widget, gpointer data)
{
	GList *paths_list;
	GtkWidget *toplevel;
	EDVCore *core;
	EDVOpenCBData *d = EDV_OPEN_CB_DATA(data);
	if(d == NULL)
		return;

	toplevel = d->toplevel;
	core = d->core;

	/* Get the list of selected paths by calling the paths list
	 * get callback
	 */
	if(d->paths_list_get_cb != NULL)
		paths_list = d->paths_list_get_cb(
			d->paths_list_get_data
		);
	else
		paths_list = NULL;

	/* Got a list of selected paths? */
	if(paths_list != NULL)
	{
		/* Count the number of paths in the list and get the path
		 * to the last path in the list
		 */
		gint npaths = 0;
		const gchar *path = NULL;
		GList *glist = paths_list;
		while(glist != NULL)
		{
			npaths++;
			path = (const gchar *)glist->data;
			glist = g_list_next(glist);
		}

		/* Confirm open */
		if(edv_confirm_open(
			core,
			toplevel,
			path,
			npaths
		) != CDIALOG_RESPONSE_YES)
		{
			g_list_foreach(paths_list, (GFunc)g_free, NULL);
			g_list_free(paths_list);
			return;
		}

		/* If the path refers to a directory then go to that
		 * directory
		 */
		if(edv_path_is_directory(path))
		{
			/* Call the goto directory callback */
			if(d->goto_directory_cb != NULL)
				d->goto_directory_cb(
					d->goto_directory_data,
					path
				);
		}
		else
		{
			/* Open the paths */
			edv_open(
				d->core,
				paths_list,
				d->command_name,
				d->toplevel,
				d->verbose
			);
		}
	}

	/* Delete the list of selected paths */
	if(paths_list != NULL)
	{
		g_list_foreach(
			paths_list,
			(GFunc)g_free,
			NULL
		);
		g_list_free(paths_list);
	}
}
