/*
			    Endeavour Operations
 */

#ifndef EDV_OP_H
#define EDV_OP_H

#include <gtk/gtk.h>

#include "url.h"
#include "edv_types.h"
#include "libendeavour2-base/edv_vfs_obj.h"
#include "libendeavour2-base/edv_recycled_obj.h"
#include "libendeavour2-base/edv_archive_obj.h"
#include "obj_op_dlg.h"
#include "vfs_browser.h"
#include "image_browser.h"
#include "archiver.h"
#include "recycle_bin.h"
#include "prop_dlg.h"


/* New/Map Window Nexus */
extern gint edv_new_window(
	EDVCore *core,
	const EDVWindowType win_type,
	const gchar *path,
	const gchar *extra,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);
extern gint edv_new_window_name(
	EDVCore *core,
	const gchar *win_name,
	const gchar *path,
	const gchar *extra,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);


/* New/Delete/Map/Unmap Windows
 *
 * About Dialog
 */
extern void edv_map_about_dialog_page(
	EDVCore *core,
	const gchar *page_name,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);
extern void edv_map_about_dialog(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);

/* File Browser */
extern gint edv_new_vfs_browser(
	EDVCore *core,
	const gchar *path,
	const gchar *extra,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern void edv_delete_vfs_browser(
	EDVCore *core,
	const gint i
);

/* Image Browser */
extern gint edv_new_image_browser(
	EDVCore *core,
	const gchar *path,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern void edv_delete_image_browser(
	EDVCore *core,
	const gint i
);

/* Archiver */
extern gint edv_new_archiver(
	EDVCore *core,
	const gchar *path,
	const gchar *password,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern void edv_delete_archiver(
	EDVCore *core,
	const gint i
);

/* Recycle Bin & Recycle Bin Desktop Icon */
extern void edv_map_recycle_bin_desktop_icon(EDVCore *core);
extern void edv_map_recycle_bin(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);

/* MIME Types List Window */
extern void edv_map_mime_types(
	EDVCore *core,
	const gchar *type,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);

/* Devices List Window */
extern void edv_map_devices(
	EDVCore *core,
	const gchar *path,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);

/* History List Window */
extern void edv_map_history(
	EDVCore *core,
	const gint event_index,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);

/* Options Window */
extern void edv_map_options_page(
	EDVCore *core,
	const gchar *page_name,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);
extern void edv_map_options(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);

/* Customize Window */
extern void edv_map_customize_page(
	EDVCore *core,
	const gchar *page_name,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);
extern void edv_map_customize(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);

/* Properties Dialog */
extern gint edv_new_properties_dialog_vfs(
	EDVCore *core,
	const gchar *path,
	const gchar *page_name,
	GList *extended_properties_list,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);
extern gint edv_new_properties_dialog_recycle_bin(
	EDVCore *core,
	const gulong index,
	const gchar *page_name,
	GList *extended_properties_list,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);
extern gint edv_new_properties_dialog_archive(
	EDVCore *core,
	const gchar *path,
	const gchar *arch_path,
	const gchar *page_name,
	GList *extended_properties_list,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry,
	GtkWidget *toplevel
);


/* Running */
extern void edv_run_device_check(
	EDVCore *core,
	EDVDevice *d,
	GtkWidget *toplevel
);
extern void edv_run_device_tools(
	EDVCore *core,
	EDVDevice *d,
	GtkWidget *toplevel
);
extern void edv_run_device_format(
	EDVCore *core,
	EDVDevice *d,
	GtkWidget *toplevel
);

extern void edv_run_terminal(
	EDVCore *core,
	const gchar *cmd,
	const gchar *wd,
	GtkWidget *toplevel
);


/* Object Operations Dialog */
extern edv_obj_op_dlg_struct *edv_get_object_operations_dialog(EDVCore *core);


/* Window Mapping */
extern void edv_map_run_dialog_command(
	EDVCore *core,
	const gchar *command,
	const gchar *working_dir,
	GtkWidget *toplevel
);
extern void edv_map_run_dialog(
	EDVCore *core,
	GtkWidget *toplevel
);

extern void edv_map_find(
	EDVCore *core,
	const EDVLocationType location_type,
	const gchar *location,
	const gchar *value
);
extern void edv_map_find_vfs(
	EDVCore *core,
	EDVVFSBrowser *browser
);
extern void edv_map_find_image_browser(
	EDVCore *core,
	EDVImageBrowser *imbr
);
extern void edv_map_find_archive(
	EDVCore *core,
	EDVArchiver *archiver
);
extern void edv_map_find_recycle_bin(
	EDVCore *core,
	edv_recbin_struct *recbin
);


/* Update Resources & Widgets */
extern void edv_update_rc_styles(EDVCore *core);
extern void edv_update_id_popup_lists(EDVCore *core);
extern void edv_update_devices_popup_list(EDVCore *core);
extern void edv_update_mime_type_hint_indicies(EDVCore *core);
extern void edv_update_open_with_popup_list(EDVCore *core);


/* Refresh & Reset */
extern void edv_refresh(EDVCore *core);
extern void edv_reset(EDVCore *core);


/* Sync */
extern void edv_sync_edv(EDVCore *core);


/* Clearing */
extern void edv_clear_error_messages(EDVCore *core);
extern void edv_clear_all_history(
	EDVCore *core,
	const gboolean confirm,
	GtkWidget *toplevel
);
extern void edv_clear_events_history(
	EDVCore *core,
	const gboolean confirm,
	GtkWidget *toplevel
);
extern void edv_clear_location_bars_history(
	EDVCore *core,
	const gboolean confirm,
	GtkWidget *toplevel
);
extern void edv_clear_run_history(
	EDVCore *core,
	const gboolean confirm,
	GtkWidget *toplevel
);

/* Recycle Bin Size Check */
extern void edv_recycle_bin_size_check(
	EDVCore *core,
	GtkWidget *toplevel
);

/* Purge Recycle Bin */
extern void edv_purge_all_recycled_objects(
	EDVCore *core,
	const gboolean map_recbin,
	const gboolean show_progress,
	const gboolean interactive,
	GtkWidget *toplevel
);

/* Query Unmount Before Exit */
extern void edv_query_unmount_before_exit(EDVCore *core);

/* Network */
extern gint edv_internet_download_object(
	EDVCore *core,
	const URLStruct *url,
	const gchar *target_path,
	GtkWidget *toplevel
);


#endif	/* EDV_OP_H */
