/*
	    Endeavour Mark II - Object Information Matching

	For obtaining the appropriate information (icons and type
	strings) to display the objects with.
 */

#ifndef EDV_OBJ_INFO_MATCH_H
#define EDV_OBJ_INFO_MATCH_H

#include <gtk/gtk.h>

#include "edv_types.h"
#include "edv_pixmap.h"
#include "edv_device.h"
#include "edv_mime_type.h"


typedef enum {
	EDV_MATCH_OBJECT_INFO_NONE	= 0,
	EDV_MATCH_OBJECT_INFO_GENERAL	= (1 << 0),
						/* EDV_MIME_TYPE_CLASS_SYSTEM */
	EDV_MATCH_OBJECT_INFO_SPECIFIC	= (1 << 1),
						/* EDV_MIME_TYPE_CLASS_FORMAT */
	EDV_MATCH_OBJECT_INFO_EXACT	= (1 << 2),
						/* EDV_MIME_TYPE_CLASS_PROGRAM,
						 * EDV_MIME_TYPE_CLASS_UNIQUE,
						 * or device */
	EDV_MATCH_OBJECT_INFO_USER_SET	= (1 << 3)
} EDVMatchObjectRelevency;


/* Match Object Icon */
extern EDVMatchObjectRelevency edv_match_object_icon(
	GList *devices_list,
	GList *mime_types_list,
	const EDVObjectType type,
	const gchar *path,
	const gboolean link_valid,
	const EDVPermissionFlags permissions,
	const EDVIconSize icon_size,
	EDVPixmap **icon_closed,
	EDVPixmap **icon_opened,
	EDVPixmap **icon_extended,
	EDVPixmap **icon_hidden
);

/* Match Object Type String */
extern EDVMatchObjectRelevency edv_match_object_type_string(
	GList *mime_types_list,
	const EDVObjectType type,
	const gchar *path,
	const EDVPermissionFlags permissions,
	gchar **type_string_rtn
);


#endif	/* EDV_OBJ_MATCH_H */
