/*
		    Endeavour Mark II - Mount Bar

	A mount bar displaying a list of mountable devices, their
	statistics and buttons to mount, unmount, eject, etc.

 */

#ifndef EDV_MOUNT_BAR_H
#define EDV_MOUNT_BAR_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_device.h"


extern GtkWidget *edv_mount_bar_new(
	EDVCore *core,
	void (*mount_cb)(
		GtkWidget *,			/* Mount Bar */
		const gint,			/* Device index */
		EDVDevice *,		/* Device */
		gpointer			/* mount_data */
	),
	gpointer mount_data,
	void (*eject_cb)(
		GtkWidget *,			/* Mount Bar */
		const gint,			/* Device index */
		EDVDevice *,		/* Device */
		gpointer			/* eject_data */
	),
	gpointer eject_data,
	void (*goto_cb)(
		GtkWidget *,			/* Mount Bar */
		const gint,			/* Device index */
		EDVDevice *,		/* Device */
		gpointer			/* goto_data */
	),
	gpointer goto_data,
	void (*status_message_cb)(
		GtkWidget *,			/* Mount Bar */
		const gchar *,			/* Message */
		gpointer			/* status_message_data */
	),
	gpointer status_message_data
);
extern void edv_mount_bar_update_display(GtkWidget *w);
extern gint edv_mount_bar_current_device(GtkWidget *w);
extern void edv_mount_bar_select(
	GtkWidget *w,
	const gint dev_num
);


#endif	/* EDV_MOUNT_BAR_H */
