/*
				 MIME Types List
 */

#ifndef EDV_MIME_TYPES_LIST_H
#define EDV_MIME_TYPES_LIST_H

#include <glib.h>
#include "edv_mime_type.h"


/* Matching */
extern EDVMIMEType *edv_mime_types_list_match_type(
	GList *mime_types_list,
	gint *n,
	const gchar *type,
	const gboolean case_sensitive
);
extern EDVMIMEType *edv_mime_types_list_match_path(
	GList *mime_types_list,
	const gchar *path
);

/* DDE Buffer */
extern GList *edv_mime_types_list_decode_buffer(
	GList *mime_types_list,
	const guint8 *buf, const gint buf_len
);
extern guint8 *edv_mime_types_list_encode_buffer(
	GList *mime_types_list,
	GList *selection_list,
	gint *buf_len_rtn
);
extern GList *edv_mime_type_commands_list_decode_buffer(
	const guint8 *buf, const gint buf_len
);
extern guint8 *edv_mime_type_commands_list_encode_buffer(
	GList *commands_list,
	gint *buf_len_rtn
);

/* Mailcap format import/export */
extern GList *edv_mime_types_list_import_mailcap(
	GList *mime_types_list,
	const gchar *path,
	const gint insert_index,
	const gboolean update, const gboolean only_newer,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, EDVMIMEType *, gpointer),
	gpointer added_data,
	void (*modified_cb)(const gint, EDVMIMEType *, gpointer),
	gpointer modified_data
);
extern void edv_mime_types_list_export_mailcap(
	GList *mime_types_list,
	const gchar *path,
	const gboolean include_read_only,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);

/* Media Types format import/export */
extern GList *edv_mime_types_list_import_media_types(
	GList *mime_types_list,
	const gchar *path,
	const gint insert_index,
	const gboolean update, const gboolean only_newer,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, EDVMIMEType *, gpointer),
	gpointer added_data,
	void (*modified_cb)(const gint, EDVMIMEType *, gpointer),
	gpointer modified_data
);
extern void edv_mime_types_list_export_media_types(
	GList *mime_types_list,
	const gchar *path,
	const gboolean include_read_only,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);

/* Endeavour MIME Types format reading and writing */
extern GList *edv_mime_types_list_file_open_system(
	GList *mime_types_list,
	const gchar *edv_data_path,
	const gint insert_index,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, EDVMIMEType *, gpointer),
	gpointer added_data,
	const gboolean mark_all_loaded_read_only
);
extern GList *edv_mime_types_list_file_open(
	GList *mime_types_list,
	const gchar *path,
	const gint insert_index,
	const gboolean update, const gboolean only_newer,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data,
	void (*added_cb)(const gint, EDVMIMEType *, gpointer),
	gpointer added_data,
	void (*modified_cb)(const gint, EDVMIMEType *, gpointer),
	gpointer modified_data,
	const gboolean mark_all_loaded_read_only
);
extern void edv_mime_types_list_file_save(
	GList *mime_types_list,
	const gchar *path,
	const gboolean include_read_only,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);


#endif	/* EDV_MIME_TYPE_FIO_H */
