/*
                      Endeavour Mark II - MIME Type
 */

#ifndef EDV_MIME_TYPE_H
#define EDV_MIME_TYPE_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_pixmap.h"


typedef struct _EDVMIMETypeCommand	EDVMIMETypeCommand;
#define EDV_MIME_TYPE_COMMAND(p)	((EDVMIMETypeCommand *)(p))

typedef struct _EDVMIMEType		EDVMIMEType;
#define EDV_MIME_TYPE(p)		((EDVMIMEType *)(p))


/*
 *	MIME Type Icon States:
 */
typedef enum{
	EDV_MIME_TYPE_ICON_STATE_STANDARD,	/* Directories = Closed
						 * Other = Standard */
	EDV_MIME_TYPE_ICON_STATE_OPENED,	/* Directories = Opened
						 * Other = Opened */
	EDV_MIME_TYPE_ICON_STATE_INACCESSIBLE,	/* Links = Broken
						 * Directories = No Access
						 * Other = Inaccessible */
	EDV_MIME_TYPE_ICON_STATE_HIDDEN		/* All = Hidden */
} EDVMIMETypeIconState;
#define EDV_MIME_TYPE_TOTAL_ICON_STATES		4

#define EDV_MIME_TYPE_ICON_STATE_NAMES	{	\
	"Standard",				\
	"Opened",				\
	"Inaccessible",				\
	"Hidden"				\
}



/*
 *	Inode MIME Types:
 *
 *	Used for EDV_MIME_TYPE_CLASS_SYSTEM MIME Types.
 */
#define EDV_MIME_TYPE_TYPE_INODE_UNKNOWN	"inode/unknown"
#define EDV_MIME_TYPE_TYPE_INODE_ERROR		"inode/error"
#define EDV_MIME_TYPE_TYPE_INODE_FILE		"inode/file"
#define EDV_MIME_TYPE_TYPE_INODE_EXECUTABLE	"inode/executable"
#define EDV_MIME_TYPE_TYPE_INODE_DIRECTORY	"inode/directory"
#define EDV_MIME_TYPE_TYPE_INODE_LINK		"inode/link"
#define EDV_MIME_TYPE_TYPE_INODE_DEV_BLOCK	"inode/dev-block"
#define EDV_MIME_TYPE_TYPE_INODE_DEV_CHARACTER	"inode/dev-character"
#define EDV_MIME_TYPE_TYPE_INODE_FIFO		"inode/fifo"
#define EDV_MIME_TYPE_TYPE_INODE_SOCKET		"inode/socket"


/*
 *	MIME Type Command Flags:
 */
typedef enum {
	EDV_MIME_TYPE_COMMAND_RUN_IN_TERMINAL	= (1 << 0)
} EDVMIMETypeCommandFlags;


/*
 *	MIME Type Command:
 */
struct _EDVMIMETypeCommand {
	gchar		*name,
			*command,
			*shell_command;
	EDVMIMETypeCommandFlags flags;
};


/*
 *	MIME Type:
 */
struct _EDVMIMEType {

	EDVMIMETypeClass	mt_class;

	/* The MIME Type's value, it is determined by the class:
	 *
	 * mt_class			value is a
	 * --------                     ----------
	 * EDV_MIME_TYPE_CLASS_SYSTEM	*Ignored*
	 * EDV_MIME_TYPE_CLASS_FORMAT	Space separated list of extensions
	 * EDV_MIME_TYPE_CLASS_PROGRAM	Path to the program object
	 * EDV_MIME_TYPE_CLASS_UNIQUE	Path to the unique object
	 */
	gchar		*value;

	/* The name of the MIME Type */
	gchar		*type;

	/* A one line verbose description of the MIME Type */
	gchar		*description;


	/* Indicates if this MIME Type has been realized, meaning that
	 * its icons and related resources have been initialized/loaded
	 */
	gboolean	realized;

	/* Indicates that this MIME Type is either created internally
	 * or loaded from a global configuration
	 *
	 * Either of which cannot be modified or removed if this is
	 * set TRUE
	 */
	gboolean	read_only;

	/* Small 20x20 icons */
	EDVPixmap	*small_icon[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	gchar		*small_icon_path[EDV_MIME_TYPE_TOTAL_ICON_STATES];

	/* Medium 32x32 icons */
	EDVPixmap	*medium_icon[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	gchar		*medium_icon_path[EDV_MIME_TYPE_TOTAL_ICON_STATES];

	/* Large 48x48 icons */
	EDVPixmap	*large_icon[EDV_MIME_TYPE_TOTAL_ICON_STATES];
	gchar		*large_icon_path[EDV_MIME_TYPE_TOTAL_ICON_STATES];


	/* Handler, one of EDV_MIME_TYPE_HANDLER_*
	 *
	 * This is basically to determine if a command should be used
	 * to open the object associated with this MIME Type (in the
	 * case of EDV_MIME_TYPE_HANDLER_COMMAND) or to use one of
	 * Endeavour's windows to open the object
	 */
	EDVMIMETypeHandler	handler;

	/* Commands List
	 *
	 * Each item in the list points to a
	 * EDVMIMETypeCommand
	 *
	 * Command are only used if the handler is set to
	 * EDV_MIME_TYPE_HANDLER_COMMAND
	 *
	 * The first command is considered the default
	 *
	 * The intention of each command is related by the mt_class as
	 * follows:
	 *
	 * mt_class			value is a
	 * --------			----------
	 * EDV_MIME_TYPE_CLASS_SYSTEM	*Ignored*
	 * EDV_MIME_TYPE_CLASS_FORMAT	Program commands or program aliases
	 * EDV_MIME_TYPE_CLASS_PROGRAM	Program commands (no aliases)
	 * EDV_MIME_TYPE_CLASS_UNIQUE	Program commands or program aliases
	 */
	GList		*commands_list;

	/* Time stamps */
	gulong		access_time,		/* In seconds since EPOCH */
			modify_time,
			change_time;

};


extern const gchar *edv_mime_type_match_command_value_by_name(
	EDVMIMEType *m,
	const gchar *name
);
extern EDVMIMETypeCommand *edv_mime_type_match_command_by_name(
	EDVMIMEType *m,
	const gchar *name
);

extern EDVMIMETypeCommand *edv_mime_type_command_new(void);
extern EDVMIMETypeCommand *edv_mime_type_command_copy(
	EDVMIMETypeCommand *cmd
);
extern void edv_mime_type_command_delete(EDVMIMETypeCommand *cmd);

extern EDVMIMEType *edv_mime_type_new_values(void);
extern EDVMIMEType *edv_mime_type_copy(EDVMIMEType *m);
extern void edv_mime_type_realize(
	EDVMIMEType *m,
	const gboolean force_rerealize
);
extern void edv_mime_type_unrealize(EDVMIMEType *m);

extern void edv_mime_type_delete(EDVMIMEType *m);


#endif	/* EDV_MIME_TYPE_H */
