#ifndef EDV_IMAGE_IO_H
#define EDV_IMAGE_IO_H

#include <glib.h>


extern gboolean edv_image_is_supported_extension(const gchar *ext);

extern GList *edv_image_open_rgba(
	const gchar *path,
	gint *width_rtn, gint *height_rtn,
	gint *bpl_rtn,
	gint *nframes_rtn,
	GList **delay_list_rtn,
	guint8 *bg_color,
	gint (*progress_cb)(
		const gint, const gint,		/* Width, height */
		const gint, const gint,		/* BPP, BPL */
		const guint8 *,			/* RGBA image data */
		const gulong, const gulong,	/* Progress min, max */
		gpointer
	),
	gpointer progress_data
);

extern GList *edv_image_open_rgba_details(
	const gchar *path,
	gint *width_rtn, gint *height_rtn,
	gint *bpl_rtn,
	gint *nframes_rtn,
	GList **delay_list_rtn,
	guint8 *bg_color,
	gulong *play_time_ms_rtn,
	gchar **creator_rtn,
	gchar **title_rtn,
	gchar **author_rtn,
	gchar **comments_rtn,
	gulong *modified_time_sec_rtn,		/* In seconds since EPOCH */
	gint (*progress_cb)(
		const gint, const gint,		/* Width, height */
		const gint, const gint,		/* BPP, BPL */
		const guint8 *,			/* RGBA image data */
		const gulong, const gulong,	/* Progress min, max */
		gpointer
	),
	gpointer progress_data
);

extern guint8 *edv_image_open_rgba_thumb(
	const gchar *path,
	const gint req_width, const gint req_height,
	gint *width_rtn, gint *height_rtn,
	gint *bpl_rtn,
	guint8 *bg_color,
	gint *orig_width_rtn, gint *orig_height_rtn,
	gint *orig_nframes_rtn,
	gulong *play_time_ms_rtn,
	gchar **creator_rtn,
	gchar **title_rtn,
	gchar **author_rtn,
	gchar **comments_rtn,
	gulong *modified_time_sec_rtn,		/* In seconds since EPOCH */
	gint (*progress_cb)(
		const gint, const gint,		/* Width, height */
		const gint, const gint,		/* BPP, BPL */
		const guint8 *,			/* RGBA image data */
		const gulong, const gulong,	/* Progress min, max */
		gpointer
	),
	gpointer progress_data
);


#endif	/* EDV_IMAGE_IO_H */
