/*
		  Endeavour Mark II - User & Group IDs Lists


	This is different from lib/edv_ids_list in that the functions
	take inputs as GLists of UID and GID.
 */

#ifndef EDV_IDS_LIST_H
#define EDV_IDS_LIST_H

#include <glib.h>
#include "libendeavour2-base/edv_id.h"


/* UIDs List */
extern EDVUID *edv_uids_list_match_uid(
	GList *uids_list,
	const gint user_id,
	gint *index_rtn
);
extern EDVUID *edv_uids_list_match_gid(
	GList *uids_list,
	const gint group_id,
	gint *index_rtn
);
extern gint edv_uid_name_to_uid(
	GList *uids_list,
	const gchar *user_name
);
extern gchar *edv_uid_uid_to_name(
	GList *uids_list,
	const gint user_id,
	gint *index_rtn
);
extern gchar *edv_uid_gid_to_name(
	GList *uids_list,
	const gint group_id,
	gint *index_rtn
);


/* GIDs List */
extern EDVGID *edv_gids_list_match_gid(
	GList *gids_list,
	const gint group_id,
	gint *index_rtn
);
extern gint edv_gid_name_to_gid(
	GList *gids_list,
	const gchar *group_name
);
extern gchar *edv_gid_gid_to_name(
	GList *gids_list,
	const gint group_id,
	gint *index_rtn
);


#endif	/* EDV_IDS_LIST_H */
