#ifndef EDV_HISTORY_LIST_H
#define EDV_HISTORY_LIST_H

#include <stdio.h>
#include <glib.h>
#include "edv_types.h"
#include "edv_history.h"


/* Open History List File */
extern GList *edv_history_list_file_open(
	GList *history_list,
	const gchar *path,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);

/* Save History List File */
extern void edv_history_list_stream_append(
	FILE *fp,
	const EDVHistory *h
);
extern void edv_history_list_file_append(
	const gchar *path,
	const EDVHistory *h
);
extern void edv_history_list_file_save(
	GList *history_list,
	const gchar *path,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);


#endif	/* EDV_HISTORY_LIST_H */
