/*
                     Endeavour Mark II - History
 */

#ifndef EDV_HISTORY_H
#define EDV_HISTORY_H

#include <glib.h>
#include "edv_types.h"


typedef struct _EDVHistory		EDVHistory;
#define EDV_HISTORY(p)			((EDVHistory *)(p))


/*
 *	History Item:
 */
struct _EDVHistory {

	EDVHistoryType	type;

	/* Starting and ending time of operation in seconds since EPOCH */
	gulong		start_time,
			end_time;

	/* Result of operation, valid codes are:
	 *
	 *	0	Success.
	 *	-1	General error.
	 *	-2	Invalid value.
	 *	-3	Systems error or memory allocation error.
	 *	-4	User aborted.
	 *	-5	User responded with `No'.
	 *	-6	An operation is already in progress.
	 *	-7	Operation not supported.
	 */
	gint		status;

	/* Source and target path, name, or value
	 *
	 * If the object is a recycled object then one of these may be
	 * a string specifying an index number of the recycled object
	 *
	 * If the object is an archive object then one of these may be
	 * a relative (but complete) path to the archive object within
	 * the archive
 	 */
	gchar		*source,
			*target;

	gchar		*comments;

};


extern EDVHistory *edv_history_new(void);
extern EDVHistory *edv_history_copy(const EDVHistory *h);
extern void edv_history_delete(EDVHistory *h);

extern void edv_history_set_values(
	EDVHistory *h,
	const EDVHistoryType type,
	const gulong start_time,		/* In seconds since EPOCH */
	const gulong end_time,			/* In seconds since EPOCH */
	const gint status,
	const gchar *source,			/* Source path, name, or value */
	const gchar *target,			/* Target path, name, or value */
	const gchar *comments
);


#endif	/* EDV_HISTORY_H */
