#include <glib.h>

#include "edv_history.h"


EDVHistory *edv_history_new(void);
EDVHistory *edv_history_copy(const EDVHistory *h);
void edv_history_delete(EDVHistory *h);

void edv_history_set_values(
	EDVHistory *h,
	const EDVHistoryType type,
	const gulong start_time,			/* In seconds since EPOCH */
	const gulong end_time,			/* In seconds since EPOCH */
	const gint status,
	const gchar *source,			/* Source path, name or value */
	const gchar *target,			/* Target path, name or value */
	const gchar *comments
);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new EDVHistory.
 */
EDVHistory *edv_history_new(void)
{
	return(EDV_HISTORY(
		g_malloc0(sizeof(EDVHistory))
	));
}

/*
 *	Coppies the EDVHistory.
 */
EDVHistory *edv_history_copy(const EDVHistory *h)
{
	const EDVHistory *src = h;
	EDVHistory *tar;

	if(src == NULL)
		return(NULL);

	tar = edv_history_new();
	if(tar == NULL)
		return(NULL);

	tar->type = src->type;

	tar->start_time = src->start_time;
	tar->end_time = src->end_time;

	tar->status = src->status;

	tar->source = STRDUP(src->source);
	tar->target = STRDUP(src->target);

	tar->comments = STRDUP(src->comments);

	return(tar);
}

/*
 *	Deletes the EDVHistory.
 */
void edv_history_delete(EDVHistory *h)
{
	if(h == NULL)
		return;

	g_free(h->source);
	g_free(h->target);
	g_free(h->comments);
	g_free(h);
}


/*
 *	Sets the EDVHistory values.
 */
void edv_history_set_values(
	EDVHistory *h,
	const EDVHistoryType type,
	const gulong start_time,			/* In seconds since EPOCH */
	const gulong end_time,			/* In seconds since EPOCH */
	const gint status,
	const gchar *source,			/* Source path, name or value */
	const gchar *target,			/* Target path, name or value */
	const gchar *comments
)
{
	if(h == NULL)
		return;

	h->type = type;

	h->start_time = start_time;
	h->end_time = end_time;

	h->status = status;

	g_free(h->source);
	h->source = STRDUP(source);

	g_free(h->target);
	h->target = STRDUP(target);

	g_free(h->comments);
	h->comments = STRDUP(comments);
}
