/*
              Endeavour Mark II - Folder Customization/Setting

	Folders are directories that have customizations set,
	customizations include directories that have the
	directory properties file (EDV_NAME_DIRECTORY_PROPERTIES_FILE)
	or .icon*.xpm files.

 */

#ifndef EDV_FOLDER_H
#define EDV_FOLDER_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern gint edv_folder_set_icons_from_image(
	EDVCore *core,
	const gchar *directory_path,
	const gchar *image_path,
	const gboolean show_progress,
	const gboolean interactive,
	GtkWidget *toplevel
);

extern gint edv_folder_remove_all_customizations(
        EDVCore *core,
        const gchar *directory_path,
        const gboolean show_progress,
        const gboolean interactive,
        GtkWidget *toplevel
);


#endif	/* EDV_FOLDER_H */
