/*
                        Endeavour Mark II - Find Bar

	All all-purpose find bar for finding objects of all
	EDVLocationTypes that can be used on virtually any window.
 */

#ifndef EDV_FIND_BAR_H
#define EDV_FIND_BAR_H

#include <gtk/gtk.h>
#include "edv_types.h"


/*
 *	Find Bar Operations:
 */
typedef enum {
	EDV_FIND_BAR_FIND_BY_NAME,
	EDV_FIND_BAR_FIND_BY_CONTENT,
	EDV_FIND_BAR_FIND_BY_SIZE_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_SIZE_NOT_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_SIZE_LESS_THAN,
	EDV_FIND_BAR_FIND_BY_SIZE_GREATER_THAN,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_NOT_EQUAL_TO,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_LESS_THAN,
	EDV_FIND_BAR_FIND_BY_MODIFY_TIME_GREATER_THAN
} EDVFindBarFindBy;


/* Search */
extern void edv_find_bar_set_search(
	GtkWidget *w,
	const gchar *s,
	const gboolean record_history
);

/* Find By */
extern EDVFindBarFindBy edv_find_bar_current_find_by(GtkWidget *w);

/* Find Bar */
extern GtkWidget *edv_find_bar_new(
	EDVCore *core,
	const EDVLocationType location_type,
	const gchar *(*get_location_cb)(
		GtkWidget *,			/* Find Bar */
		gpointer			/* get_location_data */
	),
	gpointer get_location_data,
	void (*start_cb)(
		GtkWidget *,			/* Find Bar */
		gpointer			/* start_data */
	),
	gpointer start_data,
	void (*end_cb)(
		GtkWidget *,			/* Find Bar */
		const gint,			/* Number of matches */
		gpointer			/* end_data */
	),
	gpointer end_data,
	void (*match_cb)(
		GtkWidget *,			/* Find Bar */
                const gchar *,                  /* Name/path of object */
                GList *,                        /* Properties list, a GList of
                                                 * EDVProperty * properties */
                const gint,                     /* Line index */
                const gchar *,                  /* Excerpt */
                gpointer                        /* match_data */
	),
	gpointer match_data,
	void (*status_message_cb)(
		GtkWidget *,			/* Find Bar */
		const gchar *,			/* Message */
		gpointer			/* status_message_data */
	),
	gpointer status_message_data,
	void (*status_progress_cb)(
		GtkWidget *,			/* Find Bar */
		const gfloat,			/* Progress */
		gpointer			/* status_progress_data */
	),
	gpointer status_progress_data
);
extern void edv_find_bar_update_display(GtkWidget *w);


#endif	/* EDV_FIND_BAR_H */
