/*
		    Endeavour Mark II - Object Finding
 */

#ifndef EDV_FIND_H
#define EDV_FIND_H

#include <glib.h>


/*
 *	String Match Method:
 */
typedef enum {
	EDV_FIND_STRING_MATCH_LITERAL,
	EDV_FIND_STRING_MATCH_REGEX
} EDVFindStringMatch;


/*
 *	Relativity:
 */
typedef enum {
	EDV_FIND_EQUAL_TO,
	EDV_FIND_NOT_EQUAL_TO,
	EDV_FIND_LESS_THAN,
	EDV_FIND_GREATER_THAN
} EDVFindRelativity;


/* Archive Object */
extern gint edv_find_archive_object_by_name(
	EDVCore *core,
	const gchar *arch_path,
	const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(
		const gchar *,			/* Path of object in archive */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Path of object in archive */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_archive_object_by_size(
	EDVCore *core,
	const gchar *arch_path,
	const gulong size,
	const EDVFindRelativity relativity,
	gint (*progress_cb)(
		const gchar *,			/* Path of object in archive */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Path of object in archive */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_archive_object_by_modify_time(
	EDVCore *core,
	const gchar *arch_path,
	const gulong t,
	const EDVFindRelativity relativity,
	gint (*progress_cb)(
		const gchar *,			/* Path of object in archive */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Path of object in archive */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);

/* Recycled Object */
extern gint edv_find_recycled_object_by_name(
	const gchar *index_path,
	const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(
		const gchar *,			/* Name of recycled object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Name of recycled object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_recycled_object_by_content(
	const gchar *index_path,
	const gchar *expression,
	const EDVFindStringMatch using,
	const gboolean case_sensitive,
	gint (*progress_cb)(
		const gchar *,			/* Name of recycled object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Name of recycled object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		const gint,			/* Line index */
		const gchar *,			/* Excerpt */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_recycled_object_by_size(
	const gchar *index_path,
	const gulong size,
	const EDVFindRelativity relativity,
	gint (*progress_cb)(
		const gchar *,			/* Name of recycled object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Name of recycled object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_recycled_object_by_modify_time(
	const gchar *index_path,
	const gulong t,
	const EDVFindRelativity relativity,
	gint (*progress_cb)(
		const gchar *,			/* Name of recycled object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Name of recycled object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);

/* VFS Object */
extern gint edv_find_vfs_object_by_name(
	const gchar *start_path,
	const gchar *expression,
	const gboolean recursive,
	const gboolean follow_links,
	const gboolean case_sensitive,
	gint (*progress_cb)(
		const gchar *,			/* Path to VFS object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Path to VFS object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_vfs_object_by_content(
	const gchar *start_path,
	const gchar *expression,
	const EDVFindStringMatch using,
	const gboolean recursive,
	const gboolean follow_links,
	const gboolean case_sensitive,
	gint (*progress_cb)(
		const gchar *,			/* Path to VFS object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Path to VFS object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		const gint,			/* Line index */
		const gchar *,			/* Excerpt */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_vfs_object_by_size(
	const gchar *start_path,
	const gulong size,
	const gboolean recursive,
	const gboolean follow_links,
	const EDVFindRelativity relativity,
	gint (*progress_cb)(
		const gchar *,			/* Path to VFS object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Path to VFS object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);
extern gint edv_find_vfs_object_by_modify_time(
	const gchar *start_path,
	const gulong t,
	const gboolean recursive,
	const gboolean follow_links,
	const EDVFindRelativity relativity,
	gint (*progress_cb)(
		const gchar *,			/* Path to VFS object */
		const gfloat,			/* Progress from 0.0 to 1.0 */
		gpointer			/* progress_data */
	),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *,			/* Path to VFS object */
		GList *,			/* Properties list, a GList of
						 * EDVProperty * properties */
		gpointer			/* match_data */
	),
	gpointer match_data
);


#endif	/* EDV_FIND_H */
