/*
                                  Devices List
 */

#ifndef EDV_DEVICES_LIST_H
#define EDV_DEVICES_LIST_H

#include <glib.h>
#include "edv_types.h"
#include "edv_device.h"


/* Devices List Matching */
extern EDVDevice *edv_devices_list_match_mount_path(
	GList *devices_list,
        gint *n,
        const gchar *mount_path
);
extern EDVDevice *edv_devices_list_match_device_path(
        GList *devices_list,
        gint *n,
        const gchar *device_path
);
extern EDVDevice *edv_devices_list_match_object(
	GList *devices_list,
        gint *n,
        const gchar *path
);

/* Get Devices List From System */
extern GList *edv_devices_list_open_from_system(
	GList *devices_list,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);

/* Mount States */
extern void edv_devices_list_update_mount_states(GList *devices_list);

/* Stats */
extern void edv_devices_list_update_statistics(GList *devices_list);

/* Devices List Open & Save */
extern GList *edv_devices_list_open(
	GList *devices_list,
	const gchar *path,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);
extern void edv_devices_list_file_save(
	GList *devices_list,
	const gchar *path,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer progress_data
);


#endif	/* EDV_DEVICES_LIST_H */
