/*
		Device Mounting, Unmounting, and Ejecting
 */

#ifndef EDV_DEVICE_MOUNT_H
#define EDV_DEVICE_MOUNT_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_device.h"


extern const gchar *edv_device_mount_get_error(EDVCore *core);

extern gint edv_device_mount(
	EDVCore *core,
	EDVDevice *d,
	const gboolean show_progress,
	const gboolean verbose,
	GtkWidget *toplevel
);
extern gint edv_device_unmount(
	EDVCore *core,
	EDVDevice *d,
	const gboolean show_progress,
	const gboolean verbose,
	GtkWidget *toplevel
);
extern gint edv_device_eject(
	EDVCore *core,
	EDVDevice *d,
	const gboolean show_progress,
	const gboolean verbose,
	GtkWidget *toplevel
);


#endif	/* EDV_DEVICE_MOUNT_H */
