/*
                        Endeavour Mark II - Device
 */

#ifndef EDV_DEVICE_H
#define EDV_DEVICE_H

#include <gtk/gtk.h>
#include "edv_pixmap.h"


typedef struct _EDVDevice		EDVDevice;
#define EDV_DEVICE(p)			((EDVDevice *)(p))


/*
 *	Device Flags:
 */
typedef enum {
	EDV_DEVICE_MOUNTED		= (1 << 0),	/* Device is mounted */
	EDV_DEVICE_READ_ONLY		= (1 << 1),	/* Mount as read-only,
							 * making all objects
							 * on the device
							 * read-only */
	EDV_DEVICE_NO_UNMOUNT		= (1 << 2),	/* May not be unmounted */
	EDV_DEVICE_INTERNAL		= (1 << 3),	/* Internal, do not
							 * save to the
							 * devices file */
	EDV_DEVICE_UNLISTED		= (1 << 4),	/* Do not show on
							 * "brief" listings */
	EDV_DEVICE_NO_SCAN		= (1 << 5),	/* Do not scan this
							 * device's contents
							 * unless absolutely
							 * nessisary (useful
							 * for NFS mounted
							 * devices) */
 	EDV_DEVICE_REALIZED		= (1 << 8)
} EDVDeviceFlags;

/*
 *	Device Icon States:
 */
typedef enum {
	EDV_DEVICE_ICON_STATE_STANDARD,
	EDV_DEVICE_ICON_STATE_SELECTED,		/* Selected or expanded */
	EDV_DEVICE_ICON_STATE_UNMOUNTED		/* Not mounted */
} EDVDeviceIconState;
#define EDV_DEVICE_TOTAL_ICON_STATES		3

#define EDV_DEVICE_ICON_STATE_NAMES	{	\
	"Standard",				\
	"Selected",				\
	"Unmounted"				\
}


/*
 *	Device:
 */
struct _EDVDevice {

	EDVDeviceFlags	flags;

	gchar		*name;			/* Descriptive name */

	gchar		*device_path,		/* Path to device object */
			*mount_path;		/* Path to mount point directory */

	gchar		*fs_type_name;		/* Conical name for the Filesystem type */
	guint32		fs_type_code;		/* Filesystem type code, one of EDV_FS_TYPE_* */

	/* Small 20x20 icons */
	EDVPixmap	*small_icon[EDV_DEVICE_TOTAL_ICON_STATES];
	gchar		*small_icon_path[EDV_DEVICE_TOTAL_ICON_STATES];

	/* Medium 32x32 icons */
	EDVPixmap	*medium_icon[EDV_DEVICE_TOTAL_ICON_STATES];
	gchar		*medium_icon_path[EDV_DEVICE_TOTAL_ICON_STATES];

	/* Large 48x48 icons */
	EDVPixmap	*large_icon[EDV_DEVICE_TOTAL_ICON_STATES];
	gchar		*large_icon_path[EDV_DEVICE_TOTAL_ICON_STATES];

	/* Mount and unmount commands, if either of these are not NULL
	 * then its respective command will be issued instead of a mount
	 * performed internally with system calls by this program
	 */
	gchar		*command_mount,
			*command_unmount,
			*command_eject;

	/* Commands to run external programs for device maintainance */
	gchar		*command_check,
			*command_tools,
			*command_format;

	/* Statistics */
	gulong		blocks_total,
			blocks_available,	/* Available to effective
						 * user id */
			blocks_free;

	gulong		block_size;		/* Bytes per block */

	gulong		indicies_total,
			indicies_available,	/* Available to effective
						 * user id */
			indicies_free;

	gulong		name_length_max;

	/* Time Stamps (in seconds since EPOCH) */
	gulong		last_mount_time,
			last_check_time;	/* Last time command_check was
						 * runned */

};

#define EDV_DEVICE_IS_MOUNTED(p)	(((p) != NULL) ? \
 (((p)->flags & EDV_DEVICE_MOUNTED) ? TRUE : FALSE) : FALSE)

#define EDV_DEVICE_IS_READ_ONLY(p)	(((p) != NULL) ? \
 (((p)->flags & EDV_DEVICE_READ_ONLY) ? TRUE : FALSE) : FALSE)

#define EDV_DEVICE_IS_NO_UNMOUNT(p)	(((p) != NULL) ? \
 (((p)->flags & EDV_DEVICE_NO_UNMOUNT) ? TRUE : FALSE) : FALSE)

#define EDV_DEVICE_IS_INTERNAL(p)	(((p) != NULL) ? \
 (((p)->flags & EDV_DEVICE_INTERNAL) ? TRUE : FALSE) : FALSE)

#define EDV_DEVICE_IS_UNLISTED(p)	(((p) != NULL) ? \
 (((p)->flags & EDV_DEVICE_UNLISTED) ? TRUE : FALSE) : FALSE)

#define EDV_DEVICE_IS_NO_SCAN(p)	(((p) != NULL) ? \
 (((p)->flags & EDV_DEVICE_NO_SCAN) ? TRUE : FALSE) : FALSE)

#define EDV_DEVICE_IS_REALIZED(p)	(((p) != NULL) ? \
 (((p)->flags & EDV_DEVICE_REALIZED) ? TRUE : FALSE) : FALSE)


/* Mount State */
extern void edv_device_update_mount_state(EDVDevice *d);

/* Statistics */
extern void edv_device_update_statistics(EDVDevice *d);

/* Devices */
extern EDVDevice *edv_device_new(void);
extern EDVDevice *edv_device_copy(EDVDevice *d);
extern void edv_device_realize(
	EDVDevice *d,
	const gboolean force_rerealize
);
extern void edv_device_unrealize(EDVDevice *d);
extern void edv_device_delete(EDVDevice *d);


#endif	/* EDV_DEVICE_H */
