/*
                   Endeavour Mark II - Pointer Cursors
 */

#ifndef EDV_CURSOR_H
#define EDV_CURSOR_H

#include <gdk/gdk.h>


typedef struct _EDVCursor		EDVCursor;
#define EDV_CURSOR(p)			((EDVCursor *)(p))


/*
 *      Cursor Codes:
 *
 *	Each EDVCursorCode refers to an index in the cursors list
 *	on the EDVCore (see endeavour2.h).
 */
typedef enum {
	EDV_CURSOR_CODE_BUSY,
	EDV_CURSOR_CODE_PASSIVE_BUSY,
	EDV_CURSOR_CODE_TEXT,
	EDV_CURSOR_CODE_HAND,
	EDV_CURSOR_CODE_TRANSLATE,
	EDV_CURSOR_CODE_RESIZE,
	EDV_CURSOR_CODE_CROSSHAIR,
	EDV_CURSOR_CODE_INVISIBLE
} EDVCursorCode;


/*
 *	Cursor:
 */
struct _EDVCursor {

	EDVCursorCode	code;
	GdkCursor	*cursor;

};


extern EDVCursor *edv_cursor_new(void);
extern EDVCursor *edv_cursor_new_from_gdk_cursor(
	const EDVCursorCode code,
	GdkCursor *gdk_cursor
);
extern EDVCursor *edv_cursor_new_from_gdk_cursor_type(
	const EDVCursorCode code,
	const GdkCursorType gdk_cursor_type
);
extern void edv_cursor_set_gdk_cursor(
	EDVCursor *cursor,
	GdkCursor *gdk_cursor
);
extern void edv_cursor_delete(EDVCursor *cursor);


#endif	/* EDV_CURSOR_H */
