/*
                         Endeavour Mark II - Core

	See endeavour2.h for the EDVCore declaration.

	The Endeavour Mark II Core (the Endeavour 2 Core or just core)
	is a structure holds all of the main Endeavour Mark II
	application's resources.

	This module creates and shuts down the Endeavour Mark II core.

	When the core is created with edv_core_new_init(), the
	appropriate startup procedure takes place and all of Endeavour
	Mark II's global resources are initialized.

	Proper shutdown and deletion of global resources is done in
	edv_core_delete().

	See also: edv_main.h endeavour2.h
 */

#ifndef EDV_CORE_H
#define EDV_CORE_H

#include <gtk/gtk.h>
#include "edv_types.h"


/*
 *	Global Core Context Pointer:
 */
extern EDVCore	*edv_core_ptr;


extern EDVCore *edv_core_new(void);
extern EDVCore *edv_core_new_init(
	const gint argc, const gchar **argv,
	gint *error_rtn
);
extern void edv_core_remove_timeouts(EDVCore *core);
extern void edv_core_delete(EDVCore *core);


#endif	/* EDV_CORE_H */
