#include <string.h>
#include <errno.h>
#if defined(HAVE_IMLIB)
# include <Imlib.h>
#endif
#include <gtk/gtk.h>
#include <gdk/gdkrgb.h>

#include "imgio.h"

#include "cfg.h"
#include "cfg_fio.h"

#include "guiutils.h"
#include "con_msg.h"
#include "pulist.h"
#include "fprompt.h"
#include "splash.h"
#include "cdialog.h"
#include "csd.h"
#include "fsd.h"
#include "fb.h"
#include "progressdialog.h"
#include "pdialog.h"
#include "cfg_win.h"

#include "edv_types.h"
#include "libendeavour2-base/edv_utils.h"
#include "libendeavour2-base/edv_path.h"
#include "libendeavour2-base/edv_process.h"
#include "libendeavour2-base/edv_interps.h"
#include "libendeavour2-base/edv_recycle_bin_index.h"
#include "libendeavour2-base/edv_id.h"
#include "libendeavour2-base/edv_id_fio.h"
#include "edv_ids_list.h"
#include "edv_date_format.h"
#include "edv_pixmap.h"
#include "edv_cursor.h"
#include "edv_device.h"
#include "edv_devices_list.h"
#include "edv_mime_type.h"
#include "edv_mime_types_list.h"
#include "edv_utils_gtk.h"
#include "obj_op_dlg.h"
#include "vfs_browser.h"
#include "image_browser.h"
#include "presentation_mode.h"
#include "archiver.h"
#include "recycle_bin.h"
#include "recycle_bin_desktop_icon.h"
#include "find_win.h"
#include "prop_dlg.h"
#include "history_win.h"
#include "run_dlg.h"
#include "edv_core.h"
#include "edv_cb.h"
#include "edv_op.h"
#include "endeavour2.h"

/* Instruct edv_cfg_list.h to #define EDV_CONFIGURATION_LIST */
#define NEED_EDV_CFG_LIST_SOURCE
#include "edv_cfg_list.h"

#include "config.h"


static gint edv_core_open_progress_cb(gpointer data, gulong i, gulong n);

static GList *edv_core_new_glist_length(
	const guint length,
	gpointer data
);
static void edv_core_glist_set_nth_data(
	GList *glist,
	const guint n,
	gpointer data
);

static CfgList *edv_core_new_default_cfg_list(
	const gchar *startup_path,
	const gchar *home_path
);
static void edv_core_new_create_standard_cursors(EDVCore *core);

/* Endeavour Core */
EDVCore *edv_core_new(void);
EDVCore *edv_core_new_init(
	const gint argc, const gchar **argv,
	gint *status_rtn
);
void edv_core_remove_timeouts(EDVCore *core);
void edv_core_delete(EDVCore *core);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Any open function progress callback.
 */
static gint edv_core_open_progress_cb(gpointer data, gulong i, gulong n)
{
	GtkWidget *splash = (GtkWidget *)data;
	if(splash != NULL)
	{
		splash_update(splash, FALSE);
	}

	return(0);
}


/*
 *	Creates a new GList of the specified length.
 *
 *	The length specifies the number of items in the list.
 *
 *	The data specifies the initial data value to set for all the
 *	new items.
 *
 *	Returns the new GList.
 */
static GList *edv_core_new_glist_length(
	const guint length,
	gpointer data
)
{
	gint i;
	GList *glist = NULL;

	for(i = 0; i < length; i++)
		glist = g_list_append(
			glist,
			data
		);

	return(glist);
}

/*
 *	Sets the data of the nth item in the GList.
 */
static void edv_core_glist_set_nth_data(
	GList *glist,
	const guint n,
	gpointer data
)
{
	GList *glist_nth = g_list_nth(
		glist,
		n
	);
	if(glist_nth != NULL)
		glist_nth->data = data;
}


/*
 *	Creates a new configuration list with default values.
 */
static CfgList *edv_core_new_default_cfg_list(
	const gchar *startup_path,
	const gchar *home_path
)
{
	gchar		*s,
			*tmp_dir,
			*global_data_dir,
			*local_data_dir,
			*global_config_dir;
	GList *glist;
	CfgIntList *intlist;
	CfgColor *color;
	CfgAccelkeyList *ak_list;
	CfgList src_cfg_list[] = EDV_CONFIGURATION_LIST;

	/* Create a new configuration list with all the parameters but
	 * no associated values
	 */
	CfgList *cfg_list = CFGItemListCopyList(src_cfg_list);
	if(cfg_list == NULL)
		return(NULL);

	if(startup_path == NULL)
#if defined(_WIN32)
		startup_path = "\\";
#else
		startup_path = "/";
#endif

	if(home_path == NULL)
#if defined(_WIN32)
		home_path = "\\";
#else
		home_path = "/";
#endif


	/* Get the default values */
	global_data_dir = STRDUP(EDV_PATH_DEF_GLOBAL_DATA_DIR);

	/* Local Data Directory */
	local_data_dir = edv_paths_join(
		home_path,
		EDV_NAME_DEF_USER_DATA_DIR
	);

	/* Global Configuration Directory */
	global_config_dir = g_strdup(EDV_PATH_DEF_GLOBAL_ETC_DIR);

	/* Tempory Directory */
	tmp_dir = STRDUP(g_getenv(ENV_VAR_NAME_TMPDIR));
	if(tmp_dir == NULL)
#if defined(P_tmpdir)
		tmp_dir = STRDUP(P_tmpdir);
#elif defined(_WIN32)
		tmp_dir = STRDUP("C:\\TEMP");
#else
		tmp_dir = STRDUP("/tmp");
#endif


	/* Begin setting default configuration values */

	/* Version */
	EDV_SET_I(EDV_CFG_PARM_VERSION_MAJOR, PROG_VERSION_MAJOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_MINOR, PROG_VERSION_MINOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_RELEASE, PROG_VERSION_RELEASE);

	/* Directories */
	EDV_SET_S(EDV_CFG_PARM_DIR_START_UP, startup_path);
	EDV_SET_S(EDV_CFG_PARM_DIR_GLOBAL, global_data_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_LOCAL, local_data_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_GLOBAL_CONFIG, global_config_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_TMP, tmp_dir);


	/* Files */

	/* Recycled Objects Index */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_RECYCLE_BIN_INDEX_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_RECYCLE_BIN_INDEX, s);
	g_free(s);

	/* MIME Types (Local) */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_MIME_TYPES_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_MIME_TYPES, s);
	g_free(s);

	/* MIME Types (Global) */
#if defined(DEBIAN)
	s = edv_paths_join(
		global_config_dir,
		EDV_NAME_DEF_MIME_TYPES_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL, s);
	g_free(s);
#else
	s = edv_paths_join(
		global_data_dir,
		EDV_NAME_DEF_MIME_TYPES_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL, s);
	g_free(s);
#endif
	/* Devices */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_DEVICES_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_DEVICES, s);
	g_free(s);

	/* History file */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_HISTORY_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_HISTORY, s);
	g_free(s);

	/* Browser Location History */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_FILE_BROWSER_LOCATION_HISTORY_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_BROWSER_LOCATION_HISTORY, s);
	g_free(s);

	/* Image Browser Location History */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_IMAGE_BROWSER_LOCATION_HISTORY_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_IMBR_LOCATION_HISTORY, s);
	g_free(s);

	/* Archiver Location History */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_ARCHIVER_LOCATION_HISTORY_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_ARCHIVER_LOCATION_HISTORY, s);
	g_free(s);

	/* Run Dialog History */
	s = edv_paths_join(
		local_data_dir,
		EDV_NAME_DEF_RUN_HISTORY_FILE
	);
	EDV_SET_S(EDV_CFG_PARM_FILE_RUNDLG_HISTORY, s);
	g_free(s);


	/* Programs */
	/* Shell (leave empty for default) */
	EDV_SET_S(EDV_CFG_PARM_PROG_SHELL, "");
	/* Default Viewer */
	EDV_SET_S(EDV_CFG_PARM_PROG_DEF_VIEWER, EDV_CMD_DEF_VIEWER);
	/* Terminal */
	EDV_SET_S(EDV_CFG_PARM_PROG_TERMINAL, EDV_PATH_PROG_DEF_TERMINAL);
	/* Run In Terminal Command */
	EDV_SET_S(EDV_CFG_PARM_PROG_TERMINAL_RUN, EDV_CMD_DEF_TERMINAL_RUN);
	/* ARJ Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_ARJ, "/usr/bin/arj");
	/* LHA Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_LHA, "/usr/bin/lha");
	/* RAR Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_RAR, "/usr/bin/rar_static");
	/* RedHat Program Manager Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_RPM, "/bin/rpm");
	/* Tape Archive Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_TAR, "/bin/tar");
	/* PKZip Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_ZIP, "/usr/bin/zip");
	EDV_SET_S(EDV_CFG_PARM_PROG_UNZIP, "/usr/bin/unzip");
	/* Compress */
	EDV_SET_S(EDV_CFG_PARM_PROG_COMPRESS, "/usr/bin/compress");
	EDV_SET_S(EDV_CFG_PARM_PROG_UNCOMPRESS, "/usr/bin/uncompress");
	/* GZip */
	EDV_SET_S(EDV_CFG_PARM_PROG_GZIP, "/bin/gzip");
	EDV_SET_S(EDV_CFG_PARM_PROG_GUNZIP, "/bin/gunzip");
	/* BZip2 */
	EDV_SET_S(EDV_CFG_PARM_PROG_BZIP2, "/bin/bzip2");
	EDV_SET_S(EDV_CFG_PARM_PROG_BUNZIP2, "/bin/bunzip2");
	/* Download Front End */
	EDV_SET_S(EDV_CFG_PARM_PROG_NET_DOWNLOAD, EDV_PATH_PROG_DEF_DOWNLOAD_FRONT);
	/* E-Mail Client */
	EDV_SET_S(EDV_CFG_PARM_PROG_MAIL_CLIENT, EDV_PROG_DEF_MAIL_CLIENT);

	/* GTK Style Override */
	EDV_SET_B(EDV_CFG_PARM_GTK_STYLE_OVERRIDE, FALSE);

	/* Master Write Protect */
	EDV_SET_B(EDV_CFG_PARM_WRITE_PROTECT, TRUE);

	/* Record Start Up Directory */
	EDV_SET_B(EDV_CFG_PARM_RECORD_START_UP_DIR, TRUE);

	/* Lists Keyboard Scroll To Key Name */
	EDV_SET_B(EDV_CFG_PARM_LISTS_KEYBOARD_SCROLL_TO_KEY_NAME, TRUE);

	/* Lists Pointer Operation */
	EDV_SET_I(
		EDV_CFG_PARM_LISTS_POINTER_OP_BUTTON2,
		EDV_LISTS_POINTER_OP_BUTTON2_RENAME
	);

	/* Right Click Menus Selects */
	EDV_SET_B(EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS, TRUE);

	/* Size Format */
	EDV_SET_I(EDV_CFG_PARM_SIZE_FORMAT, (gint)EDV_SIZE_FORMAT_DELIMINATED);

	/* Block Size */
	EDV_SET_UL(EDV_CFG_PARM_BLOCK_SIZE, 1000l);

	/* Date Relativity */
	EDV_SET_I(EDV_CFG_PARM_DATE_RELATIVITY, (gint)EDV_DATE_RELATIVITY_ABSOLUTE);
	/* Date Format (see strftime()) */
	EDV_SET_S(EDV_CFG_PARM_DATE_FORMAT, "%b %d %H:%M");

	/* Conserve Memory */
	EDV_SET_B(EDV_CFG_PARM_CONSERVE_MEMORY, FALSE);

	/* Image Quality (0=poor/fastest 1=standard/optimul 2=best/slowest) */
	EDV_SET_I(EDV_CFG_PARM_IMAGE_QUALITY, 1);

	/* Lists Double Buffer */
	EDV_SET_B(EDV_CFG_PARM_LISTS_DOUBLE_BUFFER, TRUE);

	/* Lists Show Progress */
	EDV_SET_B(EDV_CFG_PARM_LISTS_SHOW_PROGRESS, TRUE);

	/* Lists Load Images Priority */
	EDV_SET_I(EDV_CFG_PARM_LISTS_LOAD_IMAGES_PRIORITY, EDV_LISTS_LOAD_IMAGES_PRIORITY_NORMAL);

	/* Tree Lines Style */
	EDV_SET_I(
		EDV_CFG_PARM_TREE_LINES_STYLE,
		GTK_CTREE_LINES_DOTTED
	);

	/* Tree Expander Style */
	EDV_SET_I(
		EDV_CFG_PARM_TREE_EXPANDER_STYLE,
		GTK_CTREE_EXPANDER_SQUARE
	);

	/* Tree Expand Optimize Position */
	EDV_SET_B(EDV_CFG_PARM_TREE_EXPAND_OPTIMIZE_POS, TRUE);

	/* Show Tooltips */
	EDV_SET_B(EDV_CFG_PARM_SHOW_TOOLTIPS, TRUE);

	/* Show Texttips */
	EDV_SET_B(EDV_CFG_PARM_SHOW_TEXTTIPS, TRUE);

	/* Window Cascade Offset */
	EDV_SET_I(
		EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X,
		EDV_WINDOW_CASCADE_DEF_OFFSET_X
	);
	EDV_SET_I(
		EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y,
		EDV_WINDOW_CASCADE_DEF_OFFSET_Y
	);


	/* Confirm Open */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_OPEN, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_OPEN_NOBJECTS, 6);
	/* Confirm Move */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_MOVE, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_MOVE_NOBJECTS, 1);
	/* Confirm Copy */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_COPY, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_COPY_NOBJECTS, 1);
	/* Confirm Link */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_LINK, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_LINK_NOBJECTS, 1);
	/* Confirm Delete */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_DELETE, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_DELETE_NOBJECTS, 1);
	/* Confirm Add To Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD_NOBJECTS, 1);
	/* Confirm Extract From Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT_NOBJECTS, 1);
	/* Confirm Delete From Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE_NOBJECTS, 1);
	/* Confirm Recover */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_RECOVER, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_RECOVER_NOBJECTS, 1);
	/* Confirm Purge */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_PURGE, TRUE);
	EDV_SET_I(EDV_CFG_PARM_CONFIRM_PURGE_NOBJECTS, 1);
	/* Confirm Downloads */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_DOWNLOAD, TRUE);

	/* Maximum History Events */
	EDV_SET_I(EDV_CFG_PARM_HISTORY_EVENTS_MAX, 500);

	/* Recycle Bin Size Warn (in bytes) */
	EDV_SET_UL(EDV_CFG_PARM_RECBIN_SIZE_WARN, 10000000l);

	/* Delete Method (Recycle or Purge on delete) */
	EDV_SET_I(EDV_CFG_PARM_DELETE_METHOD, (gint)EDV_DELETE_METHOD_RECYCLE);

	/* Mount */
	EDV_SET_UL(EDV_CFG_PARM_CHECK_MOUNT_STATES_INT, 5l);
	EDV_SET_B(EDV_CFG_PARM_QUERY_UNMOUNT_BEFORE_EXIT, FALSE);

	/* Add To Archive */
	/* Compression Level (0 to 100) */
	EDV_SET_I(EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION, 100);
	/* Recursive */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE, TRUE);
	/* Dereference Links */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS, FALSE);

	/* Extract From Archive */
	/* Preserve Directories */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR, TRUE);
	/* Preserve Time Stamps */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_TIMESTAMPS, TRUE);

	/* Mailcap Import Options */
	EDV_SET_B(EDV_CFG_PARM_MAILCAP_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MAILCAP_IMPORT_ONLY_NEWER, TRUE);
	/* Media Types Import Options */
	EDV_SET_B(EDV_CFG_PARM_MEDIA_TYPES_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MEDIA_TYPES_IMPORT_ONLY_NEWER, TRUE);
	/* MIME Types Import Options */
	EDV_SET_B(EDV_CFG_PARM_MIME_TYPES_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MIME_TYPES_IMPORT_ONLY_NEWER, TRUE);

	/* Sounds */
	EDV_SET_I(
		EDV_CFG_PARM_SOUND_OUTPUT,
		(gint)EDV_SOUND_OUTPUT_NONE
	);
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_BEEP, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_INFO, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_QUESTION, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_WARNING, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_ERROR, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_COMPLETED, "");

	/* New Objects Menu */
	/* Skip */

	/* Startup Window */
	EDV_SET_B(EDV_CFG_PARM_STARTUP_BROWSER, TRUE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_IMBR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_ARCHIVER, FALSE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_RECBIN, FALSE);

	/* Maximum Windows */
	EDV_SET_I(EDV_CFG_PARM_MAX_BROWSERS, EDV_DEF_MAX_FILE_BROWSERS);
	EDV_SET_I(EDV_CFG_PARM_MAX_IMBRS, EDV_DEF_MAX_IMAGE_BROWSER);
	EDV_SET_I(EDV_CFG_PARM_MAX_ARCHIVERS, EDV_DEF_MAX_ARCHIVERS);

	/* File Browser
	 *
	 * Geometry */
	EDV_SET_I(EDV_CFG_PARM_BROWSER_X, 0);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_WIDTH, EDV_FILE_BROWSER_DEF_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_HEIGHT, EDV_FILE_BROWSER_DEF_HEIGHT);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_PANED_POSITION, EDV_FILE_BROWSER_DEF_PANED_POSITION);

	EDV_SET_B(EDV_CFG_PARM_BROWSER_TITLE_WITH_PROGRAM, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_TITLE_WITH_USER, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_TITLE_REVERSE, FALSE);

	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_GOTO_PARENT);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_GOTO_HOME);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_MOUNT);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_DIRECTORY_TREE_ORIGIN);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_COPY_PATH);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_PASTE);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_NEW_DIRECTORY);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_MOVE);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_COPY);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_LINK);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_RENAME);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_CHMOD);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_CHTIME);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_PROPERTIES);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_DOWNLOAD);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_NEW_BROWSER);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_NEW_IMBR);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_NEW_ARCHIVER);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_RECYCLE_BIN);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_OP_RUN_TERMINAL);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_BROWSER_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
		EDV_CFG_PARM_BROWSER_TOOL_BAR_BUTTON_DECALS,
		(gint)TOOL_BAR_BUTTON_DECALS_PICTURES
	);
	EDV_SET_I(
		EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF,
		(gint)GTK_RELIEF_NONE
	);

	EDV_SET_S(EDV_CFG_PARM_BROWSER_DIR_TREE_ORIGIN, "/");

	EDV_SET_S(EDV_CFG_PARM_BROWSER_CONTENTS_LIST_FILTER, "*");
	EDV_SET_B(EDV_CFG_PARM_BROWSER_CONTENTS_LIST_AUTO_RESIZE_COLUMNS, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Browser Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_DATE_MODIFIED);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_HARD_LINKS);
	glist = g_list_append(glist, (gpointer)EDV_VFS_BROWSER_COLUMN_TYPE_LINKED_TO);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Browser Contents Column Widths */
	glist = edv_core_new_glist_length(
		EDV_VFS_BROWSER_NCOLUMN_TYPES,
		(gpointer)0
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_NAME,
		(gpointer)150
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_SIZE,
		(gpointer)70
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_TYPE,
		(gpointer)100
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_PERMISSIONS,
		(gpointer)80
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_OWNER,
		(gpointer)80
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_GROUP,
		(gpointer)80
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_DATE_ACCESS,
		(gpointer)120
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_DATE_MODIFIED,
		(gpointer)120
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_DATE_CHANGED,
		(gpointer)120
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_HARD_LINKS,
		(gpointer)70
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_LINKED_TO,
		(gpointer)150
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_DEVICE_INDEX,
		(gpointer)60
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_INDEX,
		(gpointer)70
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_DEVICE_TYPE,
		(gpointer)90
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_BLOCK_SIZE,
		(gpointer)80
	);
	edv_core_glist_set_nth_data(
		glist,
		EDV_VFS_BROWSER_COLUMN_TYPE_BLOCKS,
		(gpointer)60
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	/* Show Hidden Objects */
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN, TRUE);
	/* Show No Access Objects */
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS, TRUE);

	/* Accelerator Keys */
	ak_list = edv_vfs_browser_accelkeys_new();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_BROWSER_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Image Browser
	 *
	 * Geometry
	 */
	EDV_SET_I(EDV_CFG_PARM_IMBR_X, 0);
	EDV_SET_I(EDV_CFG_PARM_IMBR_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_IMBR_WIDTH, EDV_IMAGE_BROWSER_DEF_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_IMBR_HEIGHT, EDV_IMAGE_BROWSER_DEF_HEIGHT);
	EDV_SET_I(
		EDV_CFG_PARM_IMBR_PANED_POSITION,
		EDV_IMAGE_BROWSER_DEF_PANED_POSITION
	);

	EDV_SET_B(EDV_CFG_PARM_IMBR_TITLE_WITH_PROGRAM, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_TITLE_WITH_USER, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_TITLE_WITH_LOCATION, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_TITLE_REVERSE, FALSE);

	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_GOTO_PARENT);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_GOTO_HOME);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_MOUNT);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_CONTINUE);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_STOP);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_PRESENTATION_MODE);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_COPY_PATH);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_PASTE);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_NEW_DIRECTORY);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_MOVE);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_COPY);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_LINK);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_RENAME);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_CHMOD);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_CHTIME);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_PROPERTIES);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_DOWNLOAD);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_NEW_BROWSER);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_NEW_IMBR);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_NEW_ARCHIVER);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_RECYCLE_BIN);
	glist = g_list_append(glist, (gpointer)EDV_IMAGE_BROWSER_OP_RUN_TERMINAL);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_IMBR_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
		EDV_CFG_PARM_IMBR_TOOL_BAR_BUTTON_DECALS,
		(gint)TOOL_BAR_BUTTON_DECALS_PICTURES
	);
	EDV_SET_I(
		EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF,
		(gint)GTK_RELIEF_NONE
	);

	color = CFGColorNew(1.0f, 1.0f, 1.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_IMBR_BG_COLOR, color);
	CFGColorDelete(color);
	EDV_SET_B(EDV_CFG_PARM_IMBR_OVERRIDE_IMAGE_BG_COLOR, FALSE);

	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS, TRUE);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_WIDTH, EDV_IMAGE_BROWSER_DEF_THUMB_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_HEIGHT, EDV_IMAGE_BROWSER_DEF_THUMB_HEIGHT);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_BORDER, EDV_IMAGE_BROWSER_DEF_THUMB_BORDER);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_ICON_SIZE, EDV_ICON_SIZE_32);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE, TRUE);

	EDV_SET_S(EDV_CFG_PARM_IMBR_THUMBS_LIST_FILTER, "*");

	/* Show Hidden Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN, TRUE);
	/* Show No Access Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS, TRUE);
	/* Show Non-Image Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE, TRUE);

	/* Accelerator Keys */
	ak_list = edv_image_browser_accelkeys_new();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_IMBR_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Image Browser Presentation Mode */
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_SHOW_NAVIGATOR, TRUE);
#ifdef EDV_GDK_FONT_NAME_12
	EDV_SET_S(
		EDV_CFG_PARM_PRESENTATION_FONT,
		EDV_GDK_FONT_NAME_12
	);
#else
#warning "EDV_GDK_FONT_NAME_12 was not defined, fonts may not display correctly"
#endif
	color = CFGColorNew(1.0f, 1.0f, 1.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_PRESENTATION_COLOR_FG, color);
	CFGColorDelete(color);
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_COLOR_FG_INVERT, TRUE);
	color = CFGColorNew(0.0f, 0.0f, 0.5f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_PRESENTATION_COLOR_BG, color);
	CFGColorDelete(color);
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_OVERRIDE_IMAGE_BG_COLOR, FALSE);
	EDV_SET_I(
		EDV_CFG_PARM_PRESENTATION_TRANSISION,
		EDV_PRESENTATION_MODE_TRANSISION_NONE
	);
	EDV_SET_L(EDV_CFG_PARM_PRESENTATION_TRANSISION_INT, 1500l);
	EDV_SET_L(EDV_CFG_PARM_PRESENTATION_HIDE_POINTER_DELAY, 2l);
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_SLIDESHOW, FALSE);
	EDV_SET_L(EDV_CFG_PARM_PRESENTATION_SLIDESHOW_DELAY, 3l);

	/* Archiver
	 *
	 * Geometry
	 */
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_X, 0);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_WIDTH, EDV_ARCHIVER_DEF_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_HEIGHT, EDV_ARCHIVER_DEF_HEIGHT);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_TITLE_WITH_PROGRAM, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_TITLE_WITH_USER, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_TITLE_WITH_LOCATION, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_TITLE_REVERSE, FALSE);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_ARCHIVE_COMMENTS_ON_OPEN, TRUE);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_EXTRACT_ALL);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_OPEN);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_NEW);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_ADD);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_EXTRACT);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_COMMENTS);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_STATISTICS);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_CHECK);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_STOP);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_ARCHIVER_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
		EDV_CFG_PARM_ARCHIVER_TOOL_BAR_BUTTON_DECALS,
		(gint)TOOL_BAR_BUTTON_DECALS_PICTURES_AND_TEXT
	);
	EDV_SET_I(
		EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF,
		(gint)GTK_RELIEF_NONE
	);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Archiver Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Archiver Contents Column Widths */
	glist = edv_core_new_glist_length(
		EDV_ARCHIVER_NCOLUMN_TYPES,
		(gpointer)0
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_INDEX, (gpointer)60
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_NAME, (gpointer)150
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_SIZE, (gpointer)70
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_STORAGE_SIZE, (gpointer)70
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_TYPE, (gpointer)100
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_OWNER, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_GROUP, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_LOCATION, (gpointer)150
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE, (gpointer)90
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_ENCRYPTION, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_COMPRESSION, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_METHOD, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_ARCHIVER_COLUMN_TYPE_CRC, (gpointer)80
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_S(EDV_CFG_PARM_ARCHIVER_CONTENTS_LIST_FILTER, "*");
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_CONTENTS_LIST_AUTO_RESIZE_COLUMNS, TRUE);

	/* Accelerator Keys */
	ak_list = edv_archiver_accelkeys_new();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_ARCHIVER_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Recycle Bin
	 *
	 * Geometry
	 */
	EDV_SET_I(EDV_CFG_PARM_RECBIN_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_WIDTH, EDV_RECYCLE_BIN_DEF_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_HEIGHT, EDV_RECYCLE_BIN_DEF_HEIGHT);

	/* Recycle Bin Desktop Icon */
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON, FALSE);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y, 0);

	EDV_SET_B(EDV_CFG_PARM_RECBIN_TITLE_WITH_PROGRAM, TRUE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_TITLE_WITH_USER, TRUE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_TITLE_WITH_LOCATION, TRUE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_TITLE_REVERSE, FALSE);

	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_PURGE_ALL);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_RECOVER);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_PURGE);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_RENAME);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_CHMOD);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_CHTIME);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_PROPERTIES);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_OP_SYNC_RECYCLE_BIN);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_RECBIN_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
		EDV_CFG_PARM_RECBIN_TOOL_BAR_BUTTON_DECALS,
		(gint)TOOL_BAR_BUTTON_DECALS_PICTURES
	);
	EDV_SET_I(
		EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF,
		(gint)GTK_RELIEF_NONE
	);

	EDV_SET_B(EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Recycle Bin Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_RECYCLE_BIN_COLUMN_TYPE_ORIGINAL_LOCATION);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Recycle Bin Contents Column Widths */
	glist = edv_core_new_glist_length(
		EDV_RECYCLE_BIN_CONTENTS_CLIST_COLUMNS_MAX,
		(gpointer)0
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_INDEX, (gpointer)60
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_NAME, (gpointer)150
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_SIZE, (gpointer)70
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_TYPE, (gpointer)100
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_OWNER, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_GROUP, (gpointer)80
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_DELETED, (gpointer)120
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_ORIGINAL_LOCATION, (gpointer)150
	);
	edv_core_glist_set_nth_data(glist,
		EDV_RECYCLE_BIN_COLUMN_TYPE_CAPACITY_USED, (gpointer)85
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INT_LIST(EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_S(EDV_CFG_PARM_RECBIN_CONTENTS_LIST_FILTER, "*");
	EDV_SET_B(EDV_CFG_PARM_RECBIN_CONTENTS_LIST_AUTO_RESIZE_COLUMNS, TRUE);

	/* Accelerator Keys */
	ak_list = edv_recycle_bin_accelkeys_new();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_RECBIN_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* History List Window
	 *
	 * Show Details */
	EDV_SET_B(EDV_CFG_PARM_HISTORY_LIST_SHOW_DETAILS, FALSE);
	EDV_SET_B(EDV_CFG_PARM_HISTORY_LIST_AUTO_SCROLL, TRUE);

	/* Find Window
	 *
	 * Geometry */
	EDV_SET_I(EDV_CFG_PARM_FIND_WIN_X, 0);
	EDV_SET_I(EDV_CFG_PARM_FIND_WIN_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_FIND_WIN_WIDTH, EDV_FIND_WIN_DEF_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_FIND_WIN_HEIGHT, EDV_FIND_WIN_DEF_HEIGHT);

	/* Search Criteria */
	EDV_SET_I(
		EDV_CFG_PARM_FIND_WIN_FIND_BY,
		(gint)EDV_FIND_WIN_FIND_BY_NAME
	);
	EDV_SET_S(EDV_CFG_PARM_FIND_WIN_SEARCH_STRING, "");
	EDV_SET_I(
		EDV_CFG_PARM_FIND_WIN_FIND_USING,
		(gint)EDV_FIND_WIN_FIND_USING_LITERAL
	);
	EDV_SET_B(EDV_CFG_PARM_FIND_WIN_CASE_SENSITIVE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_FIND_WIN_RECURSIVE, FALSE);


	/* Run Dialog Geometry */
	EDV_SET_I(EDV_CFG_PARM_RUN_DLG_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RUN_DLG_Y, 0);

	/* Rin Dialog Run In Terminal */
	EDV_SET_B(EDV_CFG_PARM_RUN_DLG_RUN_IN_TERMINAL, FALSE);
	/* Run Dialog Keep Dialog */
	EDV_SET_B(EDV_CFG_PARM_RUN_DLG_KEEP_DIALOG, FALSE);
	/* Run Dialog Working Directory */
	EDV_SET_S(EDV_CFG_PARM_RUN_DLG_WORKING_DIR, home_path);


	g_free(tmp_dir);
	g_free(global_data_dir);
	g_free(local_data_dir);
	g_free(global_config_dir);

	return(cfg_list);
}

/*
 *	Creates a standard list of cursors on the core.
 */
static void edv_core_new_create_standard_cursors(EDVCore *core)
{
	GdkWindow *root = gdk_window_get_root();
	GdkColor	c_fg = { 0, 0xffff, 0xffff, 0xffff },
					c_bg = { 0, 0x0000, 0x0000, 0x0000 };

#define APPEND_CURSOR(_cursor_)		{	\
 if((_cursor_) != NULL) {			\
  core->cursors_list = g_list_append(		\
   core->cursors_list,				\
   (_cursor_)					\
  );						\
 }						\
}
#define APPEND_CURSOR_PRESET(_code_,_gdk_type_)	{	\
 EDVCursor *cursor = edv_cursor_new_from_gdk_cursor_type( \
  (_code_),						\
  (_gdk_type_)						\
 );							\
 APPEND_CURSOR(cursor);					\
}
#define APPEND_CURSOR_PIXMAP(_code_,_cm_,_tm_,_hx_,_hy_) {	\
 APPEND_CURSOR(edv_cursor_new_from_gdk_cursor(		\
  (_code_),						\
  gdk_cursor_new_from_pixmap(				\
   (_cm_), (_tm_),					\
   &c_fg, &c_bg,					\
   (_hx_), (_hy_)					\
  )							\
 ));							\
}

	/* Begin creating cursors */

	if(FALSE)
	{
		const gint width = 20, height = 20;
		const gchar color_mask_data[] = {
0x00, 0x00, 0x00,
0xfe, 0x03, 0x00,
0x00, 0x00, 0x00,
0xfc, 0x01, 0x00,
0xfc, 0x01, 0x00,
0xac, 0x01, 0x00,
0xd8, 0x00, 0x00,
0x70, 0x00, 0x00,
0x20, 0x00, 0x00,
0x50, 0x00, 0x00,
0xf8, 0x00, 0x00,
0xdc, 0x01, 0x00,
0xac, 0x01, 0x00,
0x54, 0x01, 0x00,
0x00, 0x00, 0x00,
0xfe, 0x03, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00
		};
		const gchar trans_mask_data[] = {
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfc, 0x01, 0x00,
0xf8, 0x00, 0x00,
0x70, 0x00, 0x00,
0xf8, 0x00, 0x00,
0xfc, 0x01, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00
		};
		GdkBitmap *color_mask = gdk_bitmap_create_from_data(
			root, color_mask_data, width, height
		);
		GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
			root, trans_mask_data, width, height
		);
		APPEND_CURSOR_PIXMAP(
			EDV_CURSOR_CODE_BUSY,
			color_mask, trans_mask, 5, 8
		);
		GDK_BITMAP_UNREF(color_mask);
		GDK_BITMAP_UNREF(trans_mask);
	}
	else
	{
		APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_BUSY, GDK_WATCH);
	}

	if(TRUE)
	{
		const gint width = 24, height = 24;
		const gchar color_mask_data[] = {
0x03, 0x00, 0x00,
0x05, 0x00, 0x00,
0x09, 0x00, 0x00,
0x11, 0x00, 0x00,
0x21, 0x00, 0x00,
0x41, 0x00, 0x00,
0x81, 0x00, 0x00,
0x01, 0x01, 0x00,
0x01, 0xc2, 0x7f,
0xc1, 0x03, 0x00,
0x49, 0x80, 0x3f,
0x95, 0x80, 0x3f,
0x93, 0x80, 0x35,
0x20, 0x01, 0x1b,
0x20, 0x01, 0x0e,
0xc0, 0x00, 0x04,
0x00, 0x00, 0x0a,
0x00, 0x00, 0x1f,
0x00, 0x80, 0x3b,
0x00, 0x80, 0x35,
0x00, 0x80, 0x2a,
0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f,
0x00, 0x00, 0x00
		};
		const gchar trans_mask_data[] = {
0x03, 0x00, 0x00,
0x07, 0x00, 0x00,
0x0f, 0x00, 0x00,
0x1f, 0x00, 0x00,
0x3f, 0x00, 0x00,
0x7f, 0x00, 0x00,
0xff, 0x00, 0x00,
0xff, 0xe1, 0xff,
0xff, 0xe3, 0xff,
0xff, 0xe3, 0xff,
0x7f, 0xc0, 0x7f,
0xf7, 0xc0, 0x7f,
0xf3, 0xc0, 0x7f,
0xe0, 0x81, 0x3f,
0xe0, 0x01, 0x1f,
0xc0, 0x00, 0x0e,
0x00, 0x00, 0x1f,
0x00, 0x80, 0x3f,
0x00, 0xc0, 0x7f,
0x00, 0xc0, 0x7f,
0x00, 0xc0, 0x7f,
0x00, 0xe0, 0xff,
0x00, 0xe0, 0xff,
0x00, 0xe0, 0xff
		};
		GdkBitmap *color_mask = gdk_bitmap_create_from_data(
			root,
			color_mask_data,
			width, height
		);
		GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
			root,
			trans_mask_data,
			width, height
		);
		APPEND_CURSOR_PIXMAP(
			EDV_CURSOR_CODE_PASSIVE_BUSY,
			color_mask,
			trans_mask,
			0, 0
		);
		GDK_BITMAP_UNREF(color_mask);
		GDK_BITMAP_UNREF(trans_mask);
	}
	else
	{
		APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_BUSY, GDK_WATCH);
	}

	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_TEXT, GDK_XTERM);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_HAND, GDK_HAND2);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_TRANSLATE, GDK_FLEUR);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_RESIZE, GDK_SIZING);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_CROSSHAIR, GDK_TCROSS);

	if(TRUE)
	{
		const gint width = 16, height = 16;
		const gchar color_mask_data[] = {
			0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00
		};
		const gchar trans_mask_data[] = {
			0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00
		};
		GdkBitmap *color_mask = gdk_bitmap_create_from_data(
			root,
			color_mask_data,
			width, height
		);
		GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
			root,
			trans_mask_data,
			width, height
		);
		APPEND_CURSOR_PIXMAP(
			EDV_CURSOR_CODE_INVISIBLE,
			color_mask,
			trans_mask,
			0, 0
		);
		GDK_BITMAP_UNREF(color_mask);
		GDK_BITMAP_UNREF(trans_mask);
	}


#undef APPEND_CURSOR_PRESET
#undef APPEND_CURSOR_PIXMAP
#undef APPEND_CURSOR
}


/*
 *	Creates a new Endeavour Mark II Core.
 */
EDVCore *edv_core_new(void)
{
	return(EDV_CORE(g_malloc0(sizeof(EDVCore))));
}

/*
 *	Creates a new Endeavour Mark II Core, performs the appropriate
 *	startup procedure, and initializes all of Endeavour's global
 *	resources.
 *
 *	The argc and argv specifies the command line arguments.
 *
 *	If status_rtn is not NULL then *status_rtn will be set to one
 *	of the following error codes:
 *
 *	0	Success (or InterPS command was sent and returned NULL).
 *	-1	General error.
 *	-2	Invalid value.
 *	-3	Systems error or memory allocation error.
 *	-4	User aborted.
 *
 *	The startup procedure is as follows:
 *
 *	1. Allocates a new core with the runlevel set to
 *	   EDV_RUNLEVEL_CONSTRUCT and configuration values set to their
 *	   default values.
 *
 *	2. Parses and handles the command line arguments.
 *
 *	3. Opens the Users and Groups ID list files.
 *
 *	4. Opens the configuration file if it exists, if it does not
 *	   exist then saves the configuration from file (thus
 *	   generating a new configuration file with the default
 *	   values).
 *
 *	5. Checks if an InterPS lock link exists and if it does then
 *	   sends a InterPS command to the current running process,
 *	   deletes the new core, and returns NULL with *status_rtn set
 *	   to 0 (subsequent steps are skipped in this case).
 *
 *	6. Creates the InterPS lock link with this PID as its value and
 *	   maps the splash if specified.
 *
 *	7. Opens the global and local Devices list and MIME Types list
 *	   files.
 *
 *	8. Deletes the splash.
 *
 *	9. Compares this version with the version from the configuration
 *	   file, if there is a change then notify the user that this
 *	   is a new version.
 *
 *	10. Creates the initial window as specified by either from the
 *	    command line or (if not from the command line) from the
 *	    configuration.
 *
 *	11. Sets the runlevel to EDV_RUNLEVEL_IDLE.
 *
 *	Returns the new Endeavour core or NULL on error or if an
 *	InterPS lock link existed and the InterPS command was sent.
 */
EDVCore *edv_core_new_init(
	const gint argc, const gchar **argv,
	gint *status_rtn
)
{
	gint		i,
			pid,
			cfg_file_load_status;
	gulong t;
	const gchar *arg;
	gint		old_version_major,
			old_version_minor,
			old_version_release;
	gboolean	cfg_version_different,
			no_splash = FALSE,
			show_stdout_dialog = TRUE,
			show_stderr_dialog = TRUE,
			safe_mode = FALSE,
			startup_browser,
			startup_imbr,
			startup_archiver,
			startup_recbin;
	const gchar 	*arg_extra = NULL,
			*recbin_index_file,
			*alternate_config_file = NULL,
			*startup_path = NULL;
	gchar		*sd,
			*cwd,
			*startup_full_path = NULL,
			*hostname;
	CfgList		*cfg_list;
	GtkWidget *splash = NULL;
	EDVWindowType	win_type = EDV_WINDOW_NONE;
	EDVCore *core;

	if(status_rtn != NULL)
		*status_rtn = 0;

#define CLEANUP_RETURN(_v_,_status_rtn_val_,_errno_val_) {	\
 g_free(cwd);					\
 g_free(startup_full_path);			\
						\
 /* Unmap and delete the splash as needed */	\
 if(splash != NULL) {				\
  splash_unmap(					\
   splash,					\
   SPLASH_EFFECTS_FADE_BACKGROUND,		\
   SPLASH_DEF_UNMAP_DURATION_MS			\
  );						\
  splash = splash_unref(splash);		\
 }						\
						\
 /* Set the error return value */		\
 if(status_rtn != NULL)				\
  *status_rtn = (_status_rtn_val_);		\
						\
 /* Set the errno value */			\
 errno = (int)(_errno_val_);			\
						\
 return(_v_);					\
}

	/* Get the current working directory */
	cwd = edv_getcwd();
	if(cwd == NULL)
#if defined(_WIN32)
		cwd = STRDUP("\\");
#else
		cwd = STRDUP("/");
#endif

	/* Create the Endeavour Mark II Core */
	core = edv_core_new();
	if(core == NULL)
	{
		const gint error_code = (gint)errno;
		g_printerr(
"edv_core_new_init(): Unable to allocate memory for the core: %s.\n",
			g_strerror(error_code)
		);
		CLEANUP_RETURN(NULL, -3, ENOMEM);
	}

	/* Set the initial runlevel at construct */
	core->runlevel = EDV_RUNLEVEL_CONSTRUCT;

#if 0
	core->run_flags = 0;

	core->cfg_path = NULL;
	core->cfg_list = NULL;

	core->data_type_recycled_object_atom = 0;
	core->data_type_archive_object_atom = 0;

	core->pixmaps_list = NULL;

	core->about_dlg = NULL;

	core->browser = NULL;
	core->total_browsers = 0;

	core->imbr = NULL;
	core->total_imbrs = 0;

	core->archiver = NULL;
	core->total_archivers = 0;

	core->recbin = NULL;
	core->recbin_deskicon = NULL;
	core->last_nrecycle_bin_items = 0;

	core->mime_types_list_win = NULL;
	core->devices_list_win = NULL;

	core->history_list_win = NULL;

	core->options_cfg_win = NULL;
	core->customize_cfg_win = NULL;

	core->prop_dlg = NULL;
	core->total_prop_dlgs = 0;

	core->find_win = NULL;
	core->obj_op_dlg = NULL;
	core->run_dlg = NULL;
#endif

#if 0
	core->manage_toid = 0;
	core->check_mount_states_toid = 0;
	core->emit_reconfigured_idle_id = 0;
	core->emit_master_write_protect_changed_idle_id = 0;
	core->emit_delete_method_changed_idle_id = 0;
#endif

#if 0
	core->pending_flags = 0;
	core->interps_signal_count = 0;
	core->op_level = 0;
#endif

#if 0
	core->last_error_buf = NULL;
	core->last_error_ptr = NULL;
#endif

	core->pid = edv_pid_get_current();
#if 0
	core->prog_path = NULL;
#endif
	core->home_path = STRDUP(g_getenv(ENV_VAR_NAME_HOME));

	core->user_id = getuid();
	core->effective_user_id = geteuid();
	core->group_id = getgid();
	core->effective_group_id = getegid();

#if 0
	core->uids_list = NULL;
	core->users_pulist = NULL;
	core->gids_list = NULL;
	core->groups_pulist = NULL;
#endif

#if 0
	core->effective_user_id_str = NULL;
	core->effective_user_id_host_str = NULL;
#endif

#if 0
	core->cursors_list = NULL;
#endif

#if 0
	core->devices_list = NULL;
	core->devices_pulist = NULL;
#endif

#if 0
	core->mime_types_list = NULL;
	core->open_with_pulist = NULL;
#endif

	core->mimetype_system_index_first = -1;
	core->mimetype_system_index_last = -1;
	core->mimetype_format_index_first = -1;
	core->mimetype_format_index_last = -1;
	core->mimetype_program_index_first = -1;
	core->mimetype_program_index_last = -1;
	core->mimetype_unique_index_first = -1;
	core->mimetype_unique_index_last = -1;

#if 0
	core->geometry_flags = 0;
	memset(&core->geometry, 0x00, sizeof(GdkRectangle));
	core->font_name = NULL;
	core->font = NULL;
	core->fg_color_name = NULL;
	core->bg_color_name = NULL;
	core->sfg_color_name = NULL;
	core->sbg_color_name = NULL;
	core->cfg_color_name = NULL;
	core->cbg_color_name = NULL;
	core->bg_pixmap_path = NULL;
	core->sbg_pixmap_path = NULL;
	core->wm_name = NULL;
	core->wm_class = NULL;
	core->title = NULL;
#endif

#if 0
	core->standard_rcstyle = NULL;
	core->lists_rcstyle = NULL;
#endif

	/* Parse arguments */
	for(i = 1; i < argc; i++)
	{
		arg = argv[i];
		if(arg == NULL)
			continue;

		/* Arguments --help and --version should be handled
		 * separately before this call
		 */

		/* Alternate configuration file */
		if(!g_strcasecmp(arg, "--config") ||
		   !g_strcasecmp(arg, "-config") ||
		   !g_strcasecmp(arg, "--rcfile") ||
		   !g_strcasecmp(arg, "-rcfile") ||
		   !g_strcasecmp(arg, "--f") ||
		   !g_strcasecmp(arg, "-f")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				alternate_config_file = arg;
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* No Splash */
		else if(!g_strcasecmp(arg, "--no-splash") ||
			!g_strcasecmp(arg, "-no-splash") ||
			!g_strcasecmp(arg, "--no_splash") ||
			!g_strcasecmp(arg, "-no_splash")
		)
		{
			no_splash = TRUE;
		}
		/* Startup with the About Dialog */
		else if(!g_strcasecmp(arg, "--about_dialog") ||
			!g_strcasecmp(arg, "--about-dialog") ||
			!g_strcasecmp(arg, "-about_dialog") ||
			!g_strcasecmp(arg, "-about-dialog") ||
			!g_strcasecmp(arg, "--about_dlg") ||
			!g_strcasecmp(arg, "--about-dlg") ||
			!g_strcasecmp(arg, "-about_dlg") ||
			!g_strcasecmp(arg, "-about-dlg") ||
			!g_strcasecmp(arg, "--aboutdlg") ||
			!g_strcasecmp(arg, "-aboutdlg") ||
			!g_strcasecmp(arg, "--about") ||
			!g_strcasecmp(arg, "-about")
		)
		{
			win_type = EDV_WINDOW_ABOUT_DIALOG;
		}
		/* Startup with File Browser */
		else if(!g_strcasecmp(arg, "--file_browser") ||
			!g_strcasecmp(arg, "--file-browser") ||
			!g_strcasecmp(arg, "-file_browser") ||
			!g_strcasecmp(arg, "-file-browser") ||
			!g_strcasecmp(arg, "--vfs_browser") ||
			!g_strcasecmp(arg, "--vfs-browser") ||
			!g_strcasecmp(arg, "-vfs_browser") ||
			!g_strcasecmp(arg, "-vfs-browser") ||
			!g_strcasecmp(arg, "--browser") ||
			!g_strcasecmp(arg, "-browser")
		)
		{
			win_type = EDV_WINDOW_VFS_BROWSER;
		}
		/* Startup with the Image Browser */
		else if(!g_strcasecmp(arg, "--image_browser") ||
			!g_strcasecmp(arg, "--image-browser") ||
			!g_strcasecmp(arg, "-image_browser") ||
			!g_strcasecmp(arg, "-image-browser") ||
			!g_strcasecmp(arg, "--imbr") ||
			!g_strcasecmp(arg, "-imbr")
		)
		{
			win_type = EDV_WINDOW_IMAGE_BROWSER;
		}
		/* Startup with the Archiver */
		else if(!g_strcasecmp(arg, "--archiver") ||
			!g_strcasecmp(arg, "-archiver")
		)
		{
			win_type = EDV_WINDOW_ARCHIVER;
		}
		/* Startup with the Recycle Bin */
		else if(!g_strcasecmp(arg, "--recycle_bin") ||
			!g_strcasecmp(arg, "--recycle-bin") ||
			!g_strcasecmp(arg, "-recycle_bin") ||
			!g_strcasecmp(arg, "-recycle-bin") ||
			!g_strcasecmp(arg, "--recbin") ||
			!g_strcasecmp(arg, "-recbin")
		)
		{
			win_type = EDV_WINDOW_RECYCLE_BIN;
		}
		/* Startup with the MIME Types List Window */
		else if(!g_strcasecmp(arg, "--mime_types_list") ||
			!g_strcasecmp(arg, "--mime-types-list") ||
			!g_strcasecmp(arg, "--mime_types") ||
			!g_strcasecmp(arg, "--mime-types") ||
			!g_strcasecmp(arg, "-mime_types") ||
			!g_strcasecmp(arg, "-mime-types") ||
			!g_strcasecmp(arg, "--mimetypes") ||
			!g_strcasecmp(arg, "-mimetypes")
		)
		{
			win_type = EDV_WINDOW_MIME_TYPES_LIST;
		}
		/* Startup with the Devices List Window */
		else if(!g_strcasecmp(arg, "--devices_list") ||
			!g_strcasecmp(arg, "--devices-list") ||
			!g_strcasecmp(arg, "--devices") ||
			!g_strcasecmp(arg, "-devices")
		)
		{
			win_type = EDV_WINDOW_DEVICES_LIST;
		}
		/* Startup with the History List Window */
		else if(!g_strcasecmp(arg, "--history_list") ||
			!g_strcasecmp(arg, "--history-list") ||
			!g_strcasecmp(arg, "--history") ||
			!g_strcasecmp(arg, "-history")
		)
		{
			win_type = EDV_WINDOW_HISTORY_LIST;
		}
		/* Startup with the Options Window */
		else if(!g_strcasecmp(arg, "--options") ||
			!g_strcasecmp(arg, "-options")
		)
		{
			win_type = EDV_WINDOW_OPTIONS;
		}
		/* Startup with the Customize Window */
		else if(!g_strcasecmp(arg, "--customize") ||
			!g_strcasecmp(arg, "-customize")
		)
		{
			win_type = EDV_WINDOW_CUSTOMIZE;
		}
		/* Startup with the Properties Dialog */
		else if(!g_strcasecmp(arg, "--properties_dialog") ||
			!g_strcasecmp(arg, "-properties_dialog") ||
			!g_strcasecmp(arg, "--properties-dialog") ||
			!g_strcasecmp(arg, "-properties-dialog") ||
			!g_strcasecmp(arg, "--properties") ||
			!g_strcasecmp(arg, "-properties") ||
			!g_strcasecmp(arg, "--prop") ||
			!g_strcasecmp(arg, "-prop") ||
			!g_strcasecmp(arg, "--prop-dlg") ||
			!g_strcasecmp(arg, "-prop-dlg") ||
			!g_strcasecmp(arg, "--propdlg") ||
			!g_strcasecmp(arg, "-propdlg")
		)
		{
			win_type = EDV_WINDOW_PROPERTIES_DIALOG;
		}
		/* Startup with the Find Window */
		else if(!g_strcasecmp(arg, "--find_win") ||
			!g_strcasecmp(arg, "--find-win") ||
			!g_strcasecmp(arg, "-find_win") ||
			!g_strcasecmp(arg, "-find-win") ||
			!g_strcasecmp(arg, "--find_dlg") ||
			!g_strcasecmp(arg, "--find-dlg") ||
			!g_strcasecmp(arg, "-find_dlg") ||
			!g_strcasecmp(arg, "-find-dlg") ||
			!g_strcasecmp(arg, "--find") ||
			!g_strcasecmp(arg, "-find")
		)
		{
			win_type = EDV_WINDOW_FIND;
		}
		/* Startup with the Run Dialog */
		else if(!g_strcasecmp(arg, "--run_dialog") ||
			!g_strcasecmp(arg, "--run-dialog") ||
			!g_strcasecmp(arg, "-run_dialog") ||
			!g_strcasecmp(arg, "-run-dialog") ||
			!g_strcasecmp(arg, "--run_dlg") ||
			!g_strcasecmp(arg, "--run-dlg") ||
			!g_strcasecmp(arg, "-run_dlg") ||
			!g_strcasecmp(arg, "-run-dlg") ||
			!g_strcasecmp(arg, "--rundlg") ||
			!g_strcasecmp(arg, "-rundlg") ||
			!g_strcasecmp(arg, "--run") ||
			!g_strcasecmp(arg, "-run")
		)
		{
			win_type = EDV_WINDOW_RUN_DIALOG;
		}
		/* No Stdout Dialog */
		else if(!g_strcasecmp(arg, "--no-stdout-dialog") ||
			!g_strcasecmp(arg, "-no-stdout-dialog") ||
			!g_strcasecmp(arg, "--no_stdout_dialog") ||
			!g_strcasecmp(arg, "-no_stdout_dialog")
		)
		{
			show_stdout_dialog = FALSE;
		}
		/* No Stderr Dialog */
		else if(!g_strcasecmp(arg, "--no-stderr-dialog") ||
			!g_strcasecmp(arg, "-no-stderr-dialog") ||
			!g_strcasecmp(arg, "--no_stderr_dialog") ||
			!g_strcasecmp(arg, "-no_stderr_dialog")
		)
		{
			show_stderr_dialog = FALSE;
		}
		/* Safe mode */
		else if(!g_strcasecmp(arg, "--safe-mode") ||
			!g_strcasecmp(arg, "-safe-mode") ||
			!g_strcasecmp(arg, "--safe_mode") ||
			!g_strcasecmp(arg, "-safe_mode") ||
			!g_strcasecmp(arg, "--safe") ||
			!g_strcasecmp(arg, "-safe")
		)
		{
			safe_mode = TRUE;
			core->run_flags |= EDV_RUN_SAFE_MODE;
		}

		/* Geometry */
		else if(!g_strcasecmp(arg, "--geometry") ||
			!g_strcasecmp(arg, "-geometry")
		)
		{
			i++;
			if(i < argc)
			{
				gint x, y, width, height;
				GdkGeometryFlags geometry_flags;
				GdkRectangle *geometry = &core->geometry;

				arg = argv[i];

				core->geometry_flags = geometry_flags = gdk_parse_geometry(
					arg,
					&x, &y,
					&width, &height
				);
				geometry->x = (geometry_flags & GDK_GEOMETRY_X) ? x : 0;
				geometry->y = (geometry_flags & GDK_GEOMETRY_Y) ? y : 0;
				geometry->width = (geometry_flags & GDK_GEOMETRY_WIDTH) ? width : 0;
				geometry->height = (geometry_flags & GDK_GEOMETRY_HEIGHT) ? height : 0;
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}		
		}
		/* Font Name */
		else if(!g_strcasecmp(arg, "--font") ||
			!g_strcasecmp(arg, "-font") ||
			!g_strcasecmp(arg, "--fn") ||
			!g_strcasecmp(arg, "-fn")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->font_name);
				core->font_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Foreground Color Name */
		else if(!g_strcasecmp(arg, "--foreground") ||
			!g_strcasecmp(arg, "-foreground") ||
			!g_strcasecmp(arg, "--fg") ||
			!g_strcasecmp(arg, "-fg")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->fg_color_name);
				core->fg_color_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Background Color Name */
		else if(!g_strcasecmp(arg, "--background") ||
			!g_strcasecmp(arg, "-background") ||
			!g_strcasecmp(arg, "--bg") ||
			!g_strcasecmp(arg, "-bg")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->bg_color_name);
				core->bg_color_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Selected Foreground Color Name */
		else if(!g_strcasecmp(arg, "--sforeground") ||
			!g_strcasecmp(arg, "-sforeground") ||
			!g_strcasecmp(arg, "--sfg") ||
			!g_strcasecmp(arg, "-sfg")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->sfg_color_name);
				core->sfg_color_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Selected Background Color Name */
		else if(!g_strcasecmp(arg, "--sbackground") ||
			!g_strcasecmp(arg, "-sbackground") ||
			!g_strcasecmp(arg, "--sbg") ||
			!g_strcasecmp(arg, "-sbg")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->sbg_color_name);
				core->sbg_color_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Pointer Cursor Foreground Color Name */
		else if(!g_strcasecmp(arg, "--cforeground") ||
			!g_strcasecmp(arg, "-cforeground") ||
			!g_strcasecmp(arg, "--cfg") ||
			!g_strcasecmp(arg, "-cfg")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->cfg_color_name);
				core->cfg_color_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Pointer Cursor Background Color Name */
		else if(!g_strcasecmp(arg, "--cbackground") ||
			!g_strcasecmp(arg, "-cbackground") ||
			!g_strcasecmp(arg, "--cbg") ||
			!g_strcasecmp(arg, "-cbg")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->cbg_color_name);
				core->cbg_color_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Background Pixmap Path */
		else if(!g_strcasecmp(arg, "--background-pixmap") ||
			!g_strcasecmp(arg, "-background-pixmap") ||
			!g_strcasecmp(arg, "--bg-pixmap") ||
			!g_strcasecmp(arg, "-bg-pixmap")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->bg_pixmap_path);
				core->bg_pixmap_path = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Selected Background Pixmap Path */
		else if(!g_strcasecmp(arg, "--sbackground-pixmap") ||
			!g_strcasecmp(arg, "-sbackground-pixmap") ||
			!g_strcasecmp(arg, "--sbg-pixmap") ||
			!g_strcasecmp(arg, "-sbg-pixmap")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->sbg_pixmap_path);
				core->sbg_pixmap_path = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}

		/* Name */
		else if(!g_strcasecmp(arg, "--name") ||
			!g_strcasecmp(arg, "-name")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->wm_name);
				core->wm_name = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Class */
		else if(!g_strcasecmp(arg, "--class") ||
			!g_strcasecmp(arg, "-class")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->wm_class);
				core->wm_class = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Title */
		else if(!g_strcasecmp(arg, "--title") ||
			!g_strcasecmp(arg, "-title")
		)
		{
			i++;
			if(i < argc)
			{
				arg = argv[i];
				g_free(core->title);
				core->title = STRDUP(arg);
			}
			else
			{
				g_printerr(
					"%s: Requires argument.\n",
					arg
				);
				edv_core_delete(core);
				CLEANUP_RETURN(NULL, -2, EINVAL);
			}
		}
		/* Non-switch argument */
		else if((*arg != '-') && (*arg != '+'))
		{
			/* Get each non-switch argument in the order
			 * of startup_path and arg_extra
			 */
			if(startup_path == NULL)
			{
				startup_path = arg;

				/* The startup_path may be a relative
				 * path so complete it as needed as
				 * startup_full_path
				 */
				g_free(startup_full_path);
				startup_full_path = edv_path_evaluate(
					cwd,
					startup_path
				);
			}
			else if(arg_extra == NULL)
			{
				arg_extra = arg;
			}
		}
	}

	/* Disable certain options if running in safe mode */
	if(safe_mode)
	{
		no_splash = TRUE;
		show_stdout_dialog = FALSE;
		show_stderr_dialog = FALSE;
	}

	/* Record the path to the program file from the specified
	 * command line arguments
	 */
	if(argc > 0)
	{
		const gchar *arg = argv[0];
		if(arg != NULL)
		{
			g_free(core->prog_path);
			core->prog_path = g_strdup(arg);
		}
	}


	/* Create a new configuration list with default values */
	core->cfg_list = cfg_list = edv_core_new_default_cfg_list(
		startup_full_path,
		core->home_path
	);
	if(cfg_list == NULL)
	{
		if(safe_mode)
			g_printerr(
"edv_core_new_default_cfg_list(): Unable to generate the default configuration list.\n"
			);
	}

	/* Need to set an alternate configuration file path? */
	if(alternate_config_file != NULL)
	{
		g_free(core->cfg_path);
		core->cfg_path = g_strdup(alternate_config_file);
	}
	else
	{
		/* Set the configuration file from the environment? */
		const gchar *env_config_file = g_getenv(ENV_VAR_NAME_EDVCFGFILE);
		if(env_config_file != NULL)
		{
			g_free(core->cfg_path);
			core->cfg_path = g_strdup(env_config_file);
		}
		else
		{
			/* Set the configuration file as the one in the local
			 * data directory
			 */
			g_free(core->cfg_path);
			core->cfg_path = edv_paths_join(
				EDV_GET_S(EDV_CFG_PARM_DIR_LOCAL),
				EDV_NAME_DEF_CONFIG_FILE
			);
		}
	}

	/* Open the configuration list from file, overwriting any
	 * existing configuration values in the existing configuration
	 * list
	 */
	cfg_file_load_status = CFGFileOpen(
		core->cfg_path,
		cfg_list
	);

	/* Get the version of the configuration file */
	old_version_major = EDV_GET_I(EDV_CFG_PARM_VERSION_MAJOR);
	old_version_minor = EDV_GET_I(EDV_CFG_PARM_VERSION_MINOR);
	old_version_release = EDV_GET_I(EDV_CFG_PARM_VERSION_RELEASE);

	/* Is version from the configuration different than the
	 * compile time version?
	 */
	cfg_version_different = FALSE;
	if(old_version_major != PROG_VERSION_MAJOR)
		cfg_version_different = TRUE;
	else if(old_version_minor != PROG_VERSION_MINOR)
		cfg_version_different = TRUE;
	else if(old_version_release != PROG_VERSION_RELEASE)
		cfg_version_different = TRUE;

	if(cfg_version_different)
	{
		if(safe_mode)
			g_print(
"%s: Current configuration file version %i.%i.%i is different from the\
 program version %s.\n",
				core->cfg_path,
				old_version_major, old_version_minor, old_version_release,
				PROG_VERSION
			);
	}

	/* Now set the new version to the configuration since the
	 * version just fetched may be old
	 */
	EDV_SET_I(EDV_CFG_PARM_VERSION_MAJOR, PROG_VERSION_MAJOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_MINOR, PROG_VERSION_MINOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_RELEASE, PROG_VERSION_RELEASE);

#if 0
/* This is no longer used because startup_full_path will be passed
 * to either edv_new_window() or to the current running process via
 * InterPS
 */
	/* Override the startup directory from the command line? */
	if(startup_full_path != NULL)
		EDV_SET_S(EDV_CFG_PARM_DIR_START_UP, startup_full_path);
#endif

	/* Get the startup window options */
	startup_browser = EDV_GET_B(EDV_CFG_PARM_STARTUP_BROWSER);
	startup_imbr = EDV_GET_B(EDV_CFG_PARM_STARTUP_IMBR);
	startup_archiver = EDV_GET_B(EDV_CFG_PARM_STARTUP_ARCHIVER);
	startup_recbin = EDV_GET_B(EDV_CFG_PARM_STARTUP_RECBIN);

	/* Save the configuration to file if it did not exist, this is
	 * needed to create the configuration file for the very first
	 * time
	 */
	if(cfg_file_load_status != 0)
		CFGFileSave(
			core->cfg_path,
			cfg_list
		);


	/* Send InterPS command and return if another process is
	 * running
	 *
	 * Check if the InterPS lock link exists and if the process
	 * that it refers to is actually running
	 *
	 * Note that edv_interps_get_lock() will only return non-zero if
	 * the process indicated by the lock link is actually running
	 */
	pid = edv_interps_get_lock(cfg_list);
	if((pid != 0) && (pid != core->pid))
	{
		/* Another process is already running */
		gchar	*cmd,
			*cmd_list[2];

		/* Warn if issuing an InterPS command and this process
		 * was specified to run in safe mode
		 */
		if(safe_mode)
			g_print(
"%s is already running on process ID %i, sending InterPS command.\n\
\n\
This process ID %i running in safe mode will exit after sending the\n\
InterPS command.\n",
				PROG_NAME,
				pid,
				core->pid
			);

		/* If no window was specified at startup then use the
		 * one specified from the configuration
		 */
		if(win_type == EDV_WINDOW_NONE)
		{
			if(startup_browser)
				win_type = EDV_WINDOW_VFS_BROWSER;
			else if(startup_imbr)
				win_type = EDV_WINDOW_IMAGE_BROWSER;
			else if(startup_archiver)
				win_type = EDV_WINDOW_ARCHIVER;
			else if(startup_recbin)
				win_type = EDV_WINDOW_RECYCLE_BIN;
			else
				win_type = EDV_WINDOW_VFS_BROWSER;
		}

		/* Generate the InterPS command to create a new
		 * window and send it to the already running process
		 *
		 * Format:
		 *
		 * <EDVWindowType> [path] [extra] [geometry]
		 *
		 * Note that we need to include 4 arguments in order
		 * to pad the command for the geometry argument below
		 */
		cmd = g_strdup_printf(
			"new_window %i \"%s\" \"%s\"",
			win_type,
			(startup_full_path != NULL) ? startup_full_path : "",
			(arg_extra != NULL) ? arg_extra : ""
		);
		/* Append the geometry? */
		if(core->geometry_flags != 0)
		{
			gchar	*s,
				*geometry_str;
			const GdkGeometryFlags geometry_flags = core->geometry_flags;
			const GdkRectangle *rect = &core->geometry;
			if((geometry_flags & GDK_GEOMETRY_X) &&
			   (geometry_flags & GDK_GEOMETRY_Y) &&
			   (geometry_flags & GDK_GEOMETRY_WIDTH) &&
			   (geometry_flags & GDK_GEOMETRY_HEIGHT)
			)
				geometry_str = g_strdup_printf(
					"%ix%i%s%i%s%i",
					rect->width,
					rect->height,
					(rect->x < 0) ? "" : "+",
					rect->x,
					(rect->y < 0) ? "" : "+",
					rect->y
				);
			else if((geometry_flags & GDK_GEOMETRY_WIDTH) &&
					(geometry_flags & GDK_GEOMETRY_HEIGHT)
			)
				geometry_str = g_strdup_printf(
					"%ix%i",
					rect->width,
					rect->height
				);
			else
				geometry_str = g_strdup_printf(
					"%s%i%s%i",
					(rect->x < 0) ? "" : "+",
					rect->x,
					(rect->y < 0) ? "" : "+",
					rect->y
				);
			s = g_strconcat(
				cmd,
				" \"",
				geometry_str,
				"\"",
				NULL
			);
			g_free(geometry_str);
			g_free(cmd);
			cmd = s;
		}
		cmd_list[0] = cmd;
		cmd_list[1] = NULL;
		edv_interps_send_commands(
			cfg_list,
			pid,
			(const gchar **)cmd_list
		);
		g_free(cmd);

		edv_core_delete(core);
		CLEANUP_RETURN(NULL, 0, 0);
	}

	/* (Re)create the InterPS lock link */
	switch(edv_interps_make_lock(
		cfg_list,
		core->pid,
		TRUE
	))
	{
	    case 0:
		break;
	    default:
		if(cfg_list != NULL)
		{
			const gint error_code = (gint)errno;
			const gchar *local_data_path = EDV_GET_S(
				EDV_CFG_PARM_DIR_LOCAL
			);
			gchar *lock_link = edv_paths_join(
				(local_data_path != NULL) ? local_data_path : "/",
				EDV_NAME_INTERPS_LOCK_LINK
			);
			g_printerr(
"%s: Unable to create the process ID lock: %s.\n",
				lock_link,
				g_strerror(error_code)
			);
			g_free(lock_link);
		}
		else
		{
			g_printerr(
"Unable to create the process ID lock: The configuration list was not defined.\n"
			);
		}
		break;
	}

	/* Do not remove any queued InterPS command files because they
	 * may have been intentionally queued before or at the moment
	 * this program was started by the Endeavour API library
	 */
/*	edv_interps_remove_commands(cfg_list); */


	/* Get the host's name */
	hostname = edv_get_host_name();

	/* Open the User & Group IDs list files */
	core->uids_list = edv_uids_list_open_from_system(
		core->uids_list,
		-1				/* Append */
	);
	core->gids_list = edv_gids_list_open_from_system(
		core->gids_list,
		-1				/* Append */
	);

	/* Get the Effective User ID string */
	sd = edv_uid_uid_to_name(
		core->uids_list,
		core->effective_user_id, NULL
	);
	g_free(core->effective_user_id_str);
	if(STRISEMPTY(sd))
		core->effective_user_id_str = g_strdup("anonymous");
	else
		core->effective_user_id_str = g_strdup(sd);

	/* Get the Effective User ID & Hostname string */
	g_free(core->effective_user_id_host_str);
	core->effective_user_id_host_str = g_strconcat(
		STRISEMPTY(sd) ? "anonymous" : sd,
		"@",
		STRISEMPTY(hostname) ? "unknown" : hostname,
		NULL
	);

	g_free(sd);

	g_free(hostname);


	/* Initialize GTK and its resources */
	if(!(core->run_flags & EDV_RUN_GTK_INITIALIZED))
	{
		gboolean status;
		gint dargc;
		gchar **dargv;

		/* Check if the GTK library version is 1.2.10 or newer, if
		 * not then print a warning
		 */
		const gchar *s = gtk_check_version(1, 2, 10);
		if(!STRISEMPTY(s))
			g_printerr("%s\n", s);

		/* Copy the arguments so that allow gtk_init_check()
		 * can edit them
		 */
		dargc = argc;
		dargv = (gchar **)g_malloc((dargc + 1) * sizeof(gchar *));
		if(dargv != NULL)
		{
			gint i;
			for(i = 0; i < dargc; i++)
				dargv[i] = STRDUP(argv[i]);
			dargv[dargc] = NULL;
		}

		/* Initialize GTK */
		status = gtk_init_check(&dargc, &dargv);

		/* Delete the coppied arguments list */
		g_strfreev(dargv);

		/* Unable to initialize GTK? */
		if(!status)
		{
			const gint error_code = (gint)errno;
			g_printerr("Unable to initialize GTK.\n");
			edv_core_delete(core);
			CLEANUP_RETURN(NULL, -1, error_code);
		}

		/* Create GDK resources */
		core->data_type_recycled_object_atom = gdk_atom_intern(
			EDV_DND_TARGET_RECYCLED_OBJECT,
			FALSE
		);
		core->data_type_archive_object_atom = gdk_atom_intern(
			EDV_DND_TARGET_ARCHIVE_OBJECT,
			FALSE
		);

		/* Initialize the GDK RGB Buffers */
		gdk_rgb_init();

#if defined(HAVE_IMLIB)
		/* Initialize Imlib */
		core->imlib_handle = Imlib_init(gdk_display_get_current());
		if(core->imlib_handle != NULL)
		{
			/* Share the Imlib handle with the ImgIO modules */
			(void)ImgImlibSetHandle(core->imlib_handle);
		}
#endif	/* HAVE_IMLIB */

		/* Create the splash */
		if(!no_splash)
		{
			const gchar *data_dir = EDV_GET_S(EDV_CFG_PARM_DIR_GLOBAL);
			gchar *xpm_file = edv_paths_join(
				data_dir,
				EDV_NAME_SPLASH_IMAGE_FILE
			);

			splash = splash_new();
			SplashSetXPMFile(splash, xpm_file);
			splash_set_message_justification(splash, GTK_JUSTIFY_CENTER);
			splash_set_message_position(splash, GTK_POS_BOTTOM);
			splash_update_message(splash, -1.0f, NULL);
			splash_map(
				splash,
				SPLASH_EFFECTS_FADE_BACKGROUND,
				SPLASH_DEF_MAP_DURATION_MS,
				GTK_WIN_POS_CENTER
			);

			g_free(xpm_file);
		}

		/* Initialize the dialogs */
		ConMsgInit(
			PROG_NAME_FULL,
			NULL,				/* Default font name */
			0,				/* Default columns */
			0,				/* Default lines */
			show_stdout_dialog,
			show_stderr_dialog
		);
		FPromptInit();
		if(safe_mode)
			FPromptSetShadowStyle(FPROMPT_SHADOW_NONE);
		CDialogInit();
		ProgressDialogInit();
		FileBrowserInit();
		CSDInit();
		FSDInit();
		PDialogInit();

		/* Mark that GTK and its resources have been initialized */
		core->run_flags |= EDV_RUN_GTK_INITIALIZED;
	}
	splash_update(splash, TRUE);


	/* Get the full path to the Recycle Bin Index File */
	recbin_index_file = EDV_GET_S(EDV_CFG_PARM_FILE_RECYCLE_BIN_INDEX);

	/* Get the number of recycled objects in the recycle bin */
	core->last_nrecycle_bin_items = edv_recycle_bin_index_get_total(
		recbin_index_file
	);
	splash_update(splash, TRUE);


	/* Load the default font if specified */
	if(!STRISEMPTY(core->font_name))
	{
		core->font = gdk_font_load(core->font_name);
	}

	/* Create the RC styles */
	edv_update_rc_styles(core);
	splash_update(splash, TRUE);

	/* Update the global tooltips state */
	GUISetGlobalTipsState(EDV_GET_B(EDV_CFG_PARM_SHOW_TOOLTIPS));
	splash_update(splash, TRUE);

	/* Create the standard GDK cursors */
	edv_core_new_create_standard_cursors(core);
	splash_update(splash, TRUE);



	/* Open the devices from the system, then from the local
	 * devices file
	 */
	core->devices_list = edv_devices_list_open_from_system(
		core->devices_list,
		edv_core_open_progress_cb, splash
	);
	core->devices_list = edv_devices_list_open(
		core->devices_list,
		EDV_GET_S(EDV_CFG_PARM_FILE_DEVICES),
		edv_core_open_progress_cb, splash
	);
	/* Get the device mount states & stats */
	edv_devices_list_update_mount_states(core->devices_list);
	splash_update(splash, TRUE);
	edv_devices_list_update_statistics(core->devices_list);
	splash_update(splash, TRUE);


	/* Open the MIME Types from the following files in the 
	 * following order:
	 *
	 *	System
	 *	Local
	 *	Global
	 */
	core->mime_types_list = edv_mime_types_list_file_open_system(
		core->mime_types_list,
		EDV_GET_S(EDV_CFG_PARM_DIR_GLOBAL),
		-1,					/* Append */
		edv_core_open_progress_cb, splash,
		NULL, core,
		TRUE				/* Read only */
	);
	core->mime_types_list = edv_mime_types_list_file_open(
		core->mime_types_list,
		EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES),
		-1,					/* Append */
		FALSE,				/* Do not update */
		FALSE,				/* Not only newer */
		edv_core_open_progress_cb, splash,
		NULL, core,
		NULL, core,
		FALSE				/* Not read only */
	);
	core->mime_types_list = edv_mime_types_list_file_open(
		core->mime_types_list,
		EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL),
		-1,					/* Append */
		FALSE,				/* Do not update */
		FALSE,				/* Not only newer */
		edv_core_open_progress_cb, splash,
		NULL, core,
		NULL, core,
		TRUE				/* Read only */
	);
	splash_update(splash, TRUE);
	/* Update the MIME Types class list index hints */
	edv_update_mime_type_hint_indicies(core);
/* TODO: Warn if no local or global MIME Types were opened */
	splash_update(splash, TRUE);


	/* Create the Users & Groups popup lists */
	edv_update_id_popup_lists(core);
	splash_update(splash, TRUE);

	/* Create the Devices popup list */
	edv_update_devices_popup_list(core);
	splash_update(splash, TRUE);

	/* Create the Open With popup list */
	edv_update_open_with_popup_list(core);
	splash_update(splash, TRUE);


	/* Unmap the splash */
	if(splash != NULL)
	{
		splash_unmap(
			splash,
			SPLASH_EFFECTS_FADE_BACKGROUND,
			SPLASH_DEF_UNMAP_DURATION_MS
		);
		splash = splash_unref(splash);
	}


#if !defined(DEBIAN)
	/* If the configuration file version is different from the
	 * compile time version of this program, then, print warning at
	 * this point
	 */
	if(cfg_version_different && !safe_mode)
	{
		gchar *msg = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
"%s ha cambiado de la versin %i.%i.%i a la versin %s.\n\
\n\
Los valores de la configuracin pueden haber cambiado desde que\n\
la versin previa, usted debe tomar un momento de revisar sus\n\
opciones y las personalizaciones yendo a Escenarios->Opciones...\n\
y Escenarios->Personaliza...\n"
#elif defined(PROG_LANGUAGE_FRENCH)
"%s a chang de %i.%i.%i de version  %s de version.\n\
\n\
Les valeurs de configuration ont pu changer puisque la version\n\
prcdente, vous devez prendre un moment pour rexaminer vos\n\
options et vos personnalisations en allant aux\n\
Montages->Options... et les Montages->Personnalise...\n"
#elif defined(PROG_LANGUAGE_GERMAN)
"%s hat von Version %i.%i.%i zu Version %s gendert.\n\
\n\
Die konfiguration werte knnen gendert haben, da die vorherige\n\
version, sie einen moment nehmen sollen, ihre optionen und\n\
anpassungen durch gehen zu Settings->Optionen... und\n\
Settings->Anpassungen...\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
"%s ha cambiato da %i.%i.%i di versione a %s di versione.\n\
\n\
I valori di configurazione possono avere cambiato poich la\n\
versione precedente, lei dovrebbe portare un momento a riesaminare\n\
le sue opzioni e le sue personalizzazioni da andare ai\n\
Montaggi->Opzioni... ed i Montaggi->Personalizza...\n"
#elif defined(PROG_LANGUAGE_DUTCH)
"%s heeft van uitvoering %i.%i.%i aan uitvoering %s veranderd.\n\
\n\
De configuratie waarde hebben misschien veranderd aangezien de\n\
vorige uitvoering, u een moment zou moeten nemen om opnieuw je\n\
opties en aanpassingen door gaan aan Settings->Opties... en\n\
Settings->Aanpassingen...\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"%s mudou de %i.%i.%i de verso a %s de verso.\n\
\n\
Os valores de configurao podem ter mudado desde que a verso\n\
prvia, voc devem tomar um momento revisar seuas opes e\n\
customizations por ir a Settings->Opes... e\n\
Settings->Customizations...\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"%s forandrer seg fra versjon %i.%i.%i til versjon %s.\n\
\n\
Konfigurasjonsverdiene forandret seg da den forrige versjonen,\n\
de tar et yeblikk overprve Deres alternativer og customizations\n\
ved  dra til Innstillinger->Alternativer... og\n\
Innstillinger->Customizations...\n"
#else
"%s has changed from version %i.%i.%i to version %s.\n\
\n\
The configuration values may have changed since the previous version,\n\
you should take a moment to review your options and customizations\n\
by going to Settings->Options... and Settings->Customize...\n"
#endif
			, PROG_NAME_FULL,
			old_version_major,
			old_version_minor,
			old_version_release,
			PROG_VERSION
		);
		edv_play_sound_info(core);
		CDialogSetTransientFor(NULL);
		CDialogGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
"La Nota Del Cambio De La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Notification De Changement De Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Version nderung Notiz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Avviso Di Cambiamento Di Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering Verandering Bericht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Aviso De Mudana De Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"VersjonsForandring Legger Merke Til"
#else
"Version Change Notice"
#endif

			,
			msg,
			NULL,
			CDIALOG_ICON_INSTALL,
			CDIALOG_BTNFLAG_OK,
			CDIALOG_BTNFLAG_OK
		);
		g_free(msg);
		CDialogSetTransientFor(NULL);
	}
#endif	/* !DEBIAN */

	/* Check the recycle bin size and warn the user as needed */
	edv_recycle_bin_size_check(core, NULL);


	/* Map the Recycle Bin Desktop Icon? */
	if(EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON))
		edv_map_recycle_bin_desktop_icon(core);


	/* Create the initial window in accordance with the window
	 * type specified from the command line, if no window type was
	 * specified from the command line then refer to the window
	 * type specified by the configuration
	 */
	if(win_type != EDV_WINDOW_NONE)
	{
		/* Create a window specified by the command line */
		edv_new_window(
			core,
			win_type,
			startup_full_path,
			arg_extra,
			core->geometry_flags,
			(core->geometry_flags != 0) ? &core->geometry : NULL,
			NULL				/* No toplevel */
		);
	}
	else
	{
		/* No window name specified so startup with a window
		 * specified by the configuration
		 */
		gboolean created_window = FALSE;
		gint error_code = 0;

		if(startup_browser)
		{
			if(edv_new_vfs_browser(
				core,
				startup_full_path,
				arg_extra,
				core->geometry_flags,
				(core->geometry_flags != 0) ? &core->geometry : NULL
			) > -1)
				created_window = TRUE;
			else
				error_code = (gint)errno;
		}
		if(startup_imbr)
		{
			if(edv_new_image_browser(
				core,
				startup_full_path,
				core->geometry_flags,
				(core->geometry_flags != 0) ? &core->geometry : NULL
			) > -1)
				created_window = TRUE;
			else
				error_code = (gint)errno;
		}
		if(startup_archiver)
		{
			if(edv_new_archiver(
				core,
				startup_full_path,
				arg_extra,
				core->geometry_flags,
				(core->geometry_flags != 0) ? &core->geometry : NULL
			) > -1)
				created_window = TRUE;
			else
				error_code = (gint)errno;
		}
		if(startup_recbin)
		{
			edv_map_recycle_bin(
				core,
				core->geometry_flags,
				(core->geometry_flags != 0) ? &core->geometry : NULL
			);
			if(core->recbin != NULL)
				created_window = TRUE;
			else
				error_code = (gint)errno;
		}
		/* If no window was specified to be created or no windows
		 * were created then create a new File Browser
		 */
		if(!created_window)
		{
			/* Check if the configuration specifies a limit of no
			 * File Browsers
			 */
			if(EDV_GET_I(EDV_CFG_PARM_MAX_BROWSERS) == 0)
			{
				/* Must change the configuration's limit to at
				 * least 1 so we can create the initial File
				 * Browser
				 */
				EDV_SET_I(EDV_CFG_PARM_MAX_BROWSERS, 1);
			}

			/* Create a new File Browser */
			if(edv_new_vfs_browser(
				core,
				startup_full_path,
				arg_extra,
				core->geometry_flags,
				(core->geometry_flags != 0) ? &core->geometry : NULL
			) > -1)
				created_window = TRUE;
			else
				error_code = (gint)errno;
		}
		/* If still no windows were created then notify about the
		 * error
		 */
		if(!created_window)
		{
			gchar *msg = g_strdup_printf(
"Unable to create the initial window.\n\
\n\
%s.",
				g_strerror(error_code)
			);
			edv_play_sound_error(core);
			edv_message_error(
"Create Window Failed",
				msg,
				NULL,
				NULL
			);
			g_free(msg);

			/* Also print to stderr if in safe mode */
			if(safe_mode)
			{
				g_printerr(
"Unable to create the initial window, %s\n",
					g_strerror(error_code)
				);
			}
		}
	}

#if !defined(DEBIAN)
	/* Display License/Copyright?
	 *
	 * Use the About dialog to display the copyright if the version
	 * has changed or there was an error loading the configuration
	 * file (suggesting the configuration file does not exist)
	 */
	if(cfg_version_different || cfg_file_load_status)
	{
		if(!safe_mode)
			edv_map_about_dialog_page(
				core,
				"Copyright",
				core->geometry_flags,
				(core->geometry_flags != 0) ? &core->geometry : NULL,
				NULL			/* No toplevel */
			);
	}
#endif	/* !DEBIAN */


	/* Set the timeout callbacks */
	core->manage_toid = gtk_timeout_add(
		1000l, 				/* 1 second interval */
		edv_manage_timeout_cb, core
	);
	t = EDV_GET_UL(EDV_CFG_PARM_CHECK_MOUNT_STATES_INT);
	if(t > 0l)
		core->check_mount_states_toid = gtk_timeout_add(
			t * 1000l,
			edv_check_mount_states_cb, core
		);

	/* If there are queued InterPS commands then increment the
	 * InterPS signal count (send a fake signal to ourself) so
	 * that edv_manage_timeout_cb() detects and processes the
	 * commands
	 */
	if(edv_interps_command_pending(cfg_list))
		core->interps_signal_count++;

	/* Set the runlevel to idle */
	core->runlevel = EDV_RUNLEVEL_IDLE;

	/* Set the file selector callbacks */
	if(core->run_flags & EDV_RUN_GTK_INITIALIZED)
	{
		FileBrowserSetObjectCreatedCB(edv_file_selector_object_craeted_cb, core);
		FileBrowserSetObjectModifiedCB(edv_file_selector_object_modified_cb, core);
		FileBrowserSetObjectDeletedCB(edv_file_selector_object_deleted_cb, core);
	}

	CLEANUP_RETURN(core, 0, 0);
#undef CLEANUP_RETURN
}

/*
 *	Removes all the timeout and idle callbacks.
 *
 *	The core specifies the Endeavour core.
 */
void edv_core_remove_timeouts(EDVCore *core)
{
	if(core == NULL)
		return;

	/* Remove the timeouts callbacks */
	core->check_mount_states_toid = GTK_TIMEOUT_REMOVE(core->check_mount_states_toid);
	core->manage_toid = GTK_TIMEOUT_REMOVE(core->manage_toid);

	/* Remove the idle callbacks */
	core->emit_reconfigured_idle_id = GTK_IDLE_REMOVE(core->emit_reconfigured_idle_id);
	core->emit_master_write_protect_changed_idle_id = GTK_IDLE_REMOVE(core->emit_master_write_protect_changed_idle_id);
	core->emit_delete_method_changed_idle_id = GTK_IDLE_REMOVE(core->emit_delete_method_changed_idle_id);
}

/*
 *	Shuts down and deletes the Endeavour Mark II Core.
 *
 *	Any remaining timeout or idle callbacks will be removed.
 *
 *	If the InterPS lock link if it refers to this process then it
 *	will be removed.
 *
 *	All remaining windows and lists will be deleted.
 *
 *	If the core specifies that GTK was initialized then GTK will be
 *	shut down.
 *
 *	The core specifies the Endeavour Mark II Core.
 */
void edv_core_delete(EDVCore *core)
{
	if(core == NULL)
		return;

	if(core->op_level > 0)
	{
		g_printerr(
"edv_core_delete(): Warning: OP level %i > 0 (potential inappropriate call from a function performing an operation).\n",
			core->op_level
		);
	}

	/* Remove all the timeout and idle callbacks in case they were
	 * not removed prior to this call
	 */
	edv_core_remove_timeouts(core);

	/* If the current InterPS lock link refers to this process then
	 * remove it and any queued commands
	 *
	 * This may result in commands not being processed if commands
	 * were queued in the time between our last timeout callback
	 * and this point
	 */
	if(edv_interps_get_lock(core->cfg_list) == core->pid)
	{
		edv_interps_remove_commands(core->cfg_list);
		edv_interps_remove_lock(core->cfg_list);
	}

	/* Set the runlevel to deconstruct */
	core->runlevel = EDV_RUNLEVEL_CONSTRUCT;

	/* Delete the windows */

	/* About Dialog */
	about_dlg_delete(core->about_dlg);
	core->about_dlg = NULL;

	/* File Browsers */
	if(core->browser != NULL)
	{
		gint i;
		for(i = 0; i < core->total_browsers; i++)
			edv_vfs_browser_delete(core->browser[i]);
		g_free(core->browser);
		core->browser = NULL;
		core->total_browsers = 0;
	}

	/* Image Browsers */
	if(core->imbr != NULL)
	{
		gint i;
		for(i = 0; i < core->total_imbrs; i++)
			edv_image_browser_delete(core->imbr[i]);
		g_free(core->imbr);
		core->imbr = NULL;
		core->total_imbrs = 0;
	}

	/* Archivers */
	if(core->archiver != NULL)
	{
		gint i;
		for(i = 0; i < core->total_archivers; i++)
			edv_archiver_delete(core->archiver[i]);
		g_free(core->archiver);
		core->archiver = NULL;
		core->total_archivers = 0;
	}

	/* Recycle Bin */
	edv_recycle_bin_delete(core->recbin);
	core->recbin = NULL;

	/* Recycle Bin Desktop Icon */
	edv_recycle_bin_desktop_icon_delete(core->recbin_deskicon);
	core->recbin_deskicon = NULL;

	/* MIME Types List Window */
	EDVMimeTypesListWinDelete(core->mime_types_list_win);
	core->mime_types_list_win = NULL;

	/* Devices List Window */
	EDVDevicesListWinDelete(core->devices_list_win);
	core->devices_list_win = NULL;

	/* History List Window */
	EDVHistoryWinDelete(core->history_list_win);
	core->history_list_win = NULL;

	/* Options Window */
	CfgWinUnref(core->options_cfg_win);
	core->options_cfg_win = NULL;

	/* Customize Window */
	CfgWinUnref(core->customize_cfg_win);
	core->customize_cfg_win = NULL;

	/* Property Dialogs */
	if(core->prop_dlg != NULL)
	{
		gint i;
		for(i = 0; i < core->total_prop_dlgs; i++)
			edv_prop_dlg_delete(core->prop_dlg[i]);
		g_free(core->prop_dlg);
		core->prop_dlg = NULL;
		core->total_prop_dlgs = 0;
	}

	/* Find Window */
	edv_find_win_delete(core->find_win);
	core->find_win = NULL;

	/* Object Operations Dialog */
	EDVObjOpDlgDelete(core->obj_op_dlg);
	core->obj_op_dlg = NULL;

	/* Run Dialog */
	edv_run_dlg_delete(core->run_dlg);
	core->run_dlg = NULL;


	/* Unref the Open With Popup List */
	core->open_with_pulist = PUListUnref(core->open_with_pulist);

	/* Delete the MIME Types list */
	if(core->mime_types_list != NULL)
	{
		g_list_foreach(
			core->mime_types_list,
			(GFunc)edv_mime_type_delete,
			NULL
		);
		g_list_free(core->mime_types_list);
		core->mime_types_list = NULL;
	}


	/* Unref the Devices Popup List */
	core->devices_pulist = PUListUnref(core->devices_pulist);

	/* Delete the Devices list */
	if(core->devices_list != NULL)
	{
		g_list_foreach(
			core->devices_list,
			(GFunc)edv_device_delete,
			NULL
		);
		g_list_free(core->devices_list);
		core->devices_list = NULL;
	}

	/* Delete all the Cursors */
	if(core->cursors_list != NULL)
	{
		g_list_foreach(
			core->cursors_list,
			(GFunc)edv_cursor_delete,
			NULL
		);
		g_list_free(core->cursors_list);
		core->cursors_list = NULL;
	}


	/* Delete the configuration list */
	CFGItemListDeleteList(core->cfg_list);
	core->cfg_list = NULL;


	/* Unref the Users & Groups Popup Lists */
	core->users_pulist = PUListUnref(core->users_pulist);
	core->groups_pulist = PUListUnref(core->groups_pulist);

	/* Delete the User & Group IDs lists */
	if(core->uids_list != NULL)
	{
		g_list_foreach(
			core->uids_list,
			(GFunc)edv_uid_delete,
			NULL
		);
		g_list_free(core->uids_list);
		core->uids_list = NULL;
	}

	if(core->gids_list != NULL)
	{
		g_list_foreach(
			core->gids_list,
			(GFunc)edv_gid_delete,
			NULL
		);
		g_list_free(core->gids_list);
		core->gids_list = NULL;
	}


	/* Delete the user defined GtkRcStyles */
	GTK_RC_STYLE_UNREF(core->standard_rcstyle);
	core->standard_rcstyle = NULL;
	GTK_RC_STYLE_UNREF(core->lists_rcstyle);
	core->lists_rcstyle = NULL;


	/* Delete the Pixmaps List */
	if(core->pixmaps_list != NULL)
	{
		gint i;
		GList *glist;
		EDVPixmap *p;
		for(i = 0,
			glist = core->pixmaps_list;
			glist != NULL;
			i++,
			glist = g_list_next(glist)
		)
		{
			p = EDV_PIXMAP(glist->data);
			if(p == NULL)
				continue;

			if(edv_pixmap_ref_count(p) > 1)
			{
				switch(p->source_type)
				{
				  case EDV_PIXMAP_SOURCE_DATA:
					g_printerr(
"edv_core_delete(): Warning: EDVPixmap #%i from data \"%s\" has %i reference %s remaining.\n",
						i,
						p->name,
						p->ref_count,
						(p->ref_count == 1) ? "count" : "counts"
					);
					break;
				  case EDV_PIXMAP_SOURCE_FILE:
					g_printerr(
"edv_core_delete(): Warning: EDVPixmap #%i from file \"%s\" has %i reference %s remaining.\n",
						i,
						p->path,
						p->ref_count,
						(p->ref_count == 1) ? "count" : "counts"
					);
					break;
				}
			}
		}
		if(core->pixmaps_list != NULL)
		{
			g_list_foreach(
				core->pixmaps_list,
				(GFunc)edv_pixmap_unref,
				NULL
			);
			g_list_free(core->pixmaps_list);
			core->pixmaps_list = NULL;
		}
	}


	/* Shut down GTK and its resources */
	if(core->run_flags & EDV_RUN_GTK_INITIALIZED)
	{
		/* Shutdown the dialogs */
		FSDShutdown();
		CSDShutdown();
		PDialogShutdown();
		FileBrowserShutdown();
		ProgressDialogShutdown();
		CDialogShutdown();
		FPromptShutdown();
		ConMsgShutdown();

#if defined(HAVE_IMLIB)
		/* Imlib does not need to be shut down */
/*	    core->imlib_handle = NULL; */
#endif	/* HAVE_IMLIB */

		/* GTK does not need to be shut down */

		/* Mark that GTK is no longer initialized */
		core->run_flags &= ~EDV_RUN_GTK_INITIALIZED;
	}

	core->pending_flags = 0;

	core->interps_signal_count = 0;


	/* Delete all other memory on the core */

	edv_clear_error_messages(core);

	g_free(core->font_name);
	core->font = GDK_FONT_UNREF(core->font);

	g_free(core->fg_color_name);
	g_free(core->bg_color_name);

	g_free(core->sfg_color_name);
	g_free(core->sbg_color_name);

	g_free(core->cfg_color_name);
	g_free(core->cbg_color_name);

	g_free(core->bg_pixmap_path);
	g_free(core->sbg_pixmap_path);

	g_free(core->wm_name);
	g_free(core->wm_class);
	g_free(core->title);

	g_free(core->cfg_path);
	g_free(core->prog_path);
	g_free(core->home_path);

	g_free(core->effective_user_id_str);
	g_free(core->effective_user_id_host_str);

	g_free(core);
}
