#ifndef EDV_CONFIRM_H
#define EDV_CONFIRM_H

#include <gtk/gtk.h>

#include "edv_types.h"


/* Basic */
extern gint edv_confirm_open(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *path, const gint nobjs
);
extern gint edv_confirm_copy(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint edv_confirm_move(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint edv_confirm_link(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint edv_confirm_delete(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs
);

/* Archive */
extern gint edv_confirm_archive_add(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *arch_path
);
extern gint edv_confirm_archive_extract(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint edv_confirm_archive_delete(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs
);

/* Recover & Purge */
extern gint edv_confirm_recover(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path,
	const gint nobjs,
	const gchar *tar_path
);
extern gint edv_confirm_purge(
	EDVCore *core,
	GtkWidget *toplevel,
	const gchar *src_path,
	const gint nobjs
);


#endif	/* EDV_CONFIRM_H */
