/*
		            Endeavour Callbacks

	UNIX and GTK+ Callbacks for Endeavour's core.

	For individual window callbacks, see <window>_cb.h.
 */

#ifndef EDV_CB_H
#define EDV_CB_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "edv_mime_type.h"


/* UNIX Signal Callbacks */
extern void edv_signal_cb(int s);

/* Timeout Callbacks */
extern gint edv_manage_timeout_cb(gpointer data);
extern gint edv_check_mount_states_cb(gpointer data);

/* Idle Callbacks */
extern gint edv_reconfigured_idle_cb(gpointer data);
extern gint edv_master_write_protect_changed_idle_cb(gpointer data);
extern gint edv_delete_method_changed_idle_cb(gpointer data);

/* New/Map Window Callbacks */
extern void edv_new_vfs_browser_cb(GtkWidget *widget, gpointer data);
extern void edv_new_image_browser_cb(GtkWidget *widget, gpointer data);
extern void edv_new_archiver_cb(GtkWidget *widget, gpointer data);
extern void edv_map_recycle_bin_cb(GtkWidget *widget, gpointer data);
extern void edv_mime_types_cb(GtkWidget *widget, gpointer data);
extern void edv_devices_cb(GtkWidget *widget, gpointer data);
extern void edv_options_cb(GtkWidget *widget, gpointer data);
extern void edv_customize_cb(GtkWidget *widget, gpointer data);

/* MIME Types Added/Mdoified/Removed Callbacks */
extern void edv_mime_type_added_cb(
	const gint mt_num, EDVMIMEType *m, gpointer data
);
extern void edv_mime_type_modified_cb(
	const gint mt_num, EDVMIMEType *m, gpointer data
);
extern void edv_mime_type_removed_cb(
	const gint mt_num, gpointer data
);

/* GtkCList Sort Callbacks */
extern gint EDVCListColumnSortStringCB(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);
extern gint edv_clist_column_sort_number_cb(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);

/* Refresh & Reset Callbacks */
extern void edv_refresh_cb(GtkWidget *widget, gpointer data);
extern void edv_reset_cb(GtkWidget *widget, gpointer data);

/* Clear Callbacks */
extern void edv_purge_all_recycled_objects_cb(GtkWidget *widget, gpointer data);
extern void edv_clear_all_history_cb(GtkWidget *widget, gpointer data);
extern void edv_clear_events_history_cb(GtkWidget *widget, gpointer data);
extern void edv_clear_location_bars_history_cb(GtkWidget *widget, gpointer data);
extern void edv_clear_run_history_cb(GtkWidget *widget, gpointer data);

/* GtkEntry DND Callbacks */
extern void edv_entry_drag_data_received_cb(
	GtkWidget *widget, GdkDragContext *dc, gint x, gint y,
	GtkSelectionData *selection_data, guint info, guint t,
	gpointer data
);

/* GtkEntry Complete Path Callback */
extern gint edv_entry_complete_path_cb(
	GtkWidget *widget, GdkEventKey *key, gpointer data
);

/* Location Bar DND Callbacks */
extern void edv_location_bar_icon_drag_data_get_cb(
	GtkWidget *widget, GdkDragContext *context,
	GtkSelectionData *selection_data, guint info, guint time,
	gpointer data
);

/* File Selector Callbacks */
extern void edv_file_selector_object_craeted_cb(
	const gchar *path, gpointer data
);
extern void edv_file_selector_object_modified_cb(
	const gchar *old_path,
	const gchar *new_path,
	gpointer data
);
extern void edv_file_selector_object_deleted_cb(
	const gchar *path, gpointer data
);

/* Options Window Callbacks */
extern void edv_cfg_win_apply_cb(
        GtkWidget *w, CfgList *cfg_list, gpointer data
);


#endif	/* EDV_CB_H */
