/*
              Endeavour Mark II - Archive Object Statistics

	This module is not part of the Endeavour Mark II API library
	because compile-time detection dependencies are not set in the
	library's Makefile.
 */

#ifndef EDV_ARCHIVE_OBJ_STAT_H
#define EDV_ARCHIVE_OBJ_STAT_H

#include <glib.h>
#include "cfg.h"
#include "libendeavour2-base/edv_archive_obj.h"


extern EDVArchiveObject *edv_archive_object_stat(
	CfgList *cfg_list,
	const gchar *arch_path,
	const gchar *path,
	const gchar *password
);
extern gint edv_archive_object_stat_list_sequential(
	CfgList *cfg_list,
	const gchar *arch_path,
	GList *paths_list,			/* List of gchar * paths */
	const gchar *filter,
	const gchar *password,
	gint (*obj_rtn_cb)(
		const gchar *arch_path,
		EDVArchiveObject *obj,
		const gulong i, const gulong m,
		gpointer data
	),
	gpointer obj_rtn_data
);
extern GList *edv_archive_object_stat_list(
	CfgList *cfg_list,
	const gchar *arch_path,
	GList *paths_list,			/* List of gchar * paths */
	const gchar *filter,
	const gchar *password,
	gint (*progress_cb)(
		const gchar *,
		const gulong, const gulong,
		gpointer
	),
	gpointer progress_data
);


#endif	/* EDV_ARCHIVE_OBJ_STAT_H */
