#ifndef EDV_ARCHIVE_EXTRACT_H
#define EDV_ARCHIVE_EXTRACT_H

#include <stdio.h>
#include <gtk/gtk.h>
#include "edv_types.h"


/* Error Message */
extern const gchar *edv_archive_extract_get_error(EDVCore *core);
extern void edv_archive_extract_set_error(
	EDVCore *core,
	const gchar *msg
);

/* Execute */
extern gint edv_archive_extract_execute(
        CfgList *cfg_list,
        const gchar *cmd,
        FILE **cstdin_rtn,
        FILE **cstdout_rtn,
        FILE **cstderr_rtn
);

/* Progress Dialog */
extern gint edv_archive_extract_update_progress_dialog(
        CfgList *cfg_list,
        const gchar *src_path,
        const gchar *tar_path,
        const gfloat progress,
        GtkWidget *toplevel,
        const gboolean force_remap
);

/* Remove Recursive */
extern gint edv_archive_extract_remove(const gchar *path);

/* Extract From Archive */
extern gint edv_archive_extract(
	EDVCore *core,
	const gchar *arch_path,
	GList *obj_list,			/* GList of EDVArchiveObject * objects */
	const gboolean extract_all,
	const gchar *dest_path,
	GList **new_paths_list_rtn,		/* Return GList of gchar * paths */
	const gchar *password,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean preserve_directories,
	const gboolean preserve_timestamps
);


#endif	/* EDV_ARCHIVE_EXTRACT_H */
