#ifndef EDV_ARCHIVE_ADD_H
#define EDV_ARCHIVE_ADD_H

#include <stdio.h>
#include <gtk/gtk.h>
#include "edv_types.h"


/* Error Messages */
extern const gchar *edv_archive_add_get_error(EDVCore *core);
extern void edv_archive_add_set_error(
	EDVCore *core,
	const gchar *msg
);

/* Execute */
extern gint edv_archive_add_execute(
        CfgList *cfg_list,
        const gchar *cmd,
        FILE **cstdin_rtn,
        FILE **cstdout_rtn,
        FILE **cstderr_rtn
);

/* Progress Dialog */
extern gint edv_archive_add_update_progress_dialog(
        CfgList *cfg_list,
        const gchar *src_path,
        const gchar *tar_path,
        const gfloat progress,
        GtkWidget *toplevel,
        const gboolean force_remap
);

/* Calculate Total Size */
extern gulong edv_archive_add_calculate_total_size(
	const gchar *arch_path,
	const gchar *path,
	gint *nobjs,
	const gboolean recursive,
	const gboolean dereference_links
);

/* Add To Archive */
extern gint edv_archive_add(
	EDVCore *core,
	const gchar *arch_path,
	GList *src_paths_list,			/* GList of gchar * paths */
	GList **new_paths_list_rtn,		/* Return GList of gchar * paths */
	const gchar *password,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean recursive,
	const gint compression,
	const gboolean dereference_links
);


#endif	/* EDV_ARCHIVE_ADD_H */
