/*
                               Devices List Window
 */

#ifndef DEVICES_LIST_WIN_H
#define DEVICES_LIST_WIN_H

#include <gtk/gtk.h>

#include "pulist.h"

#include "edv_types.h"
#include "edv_device.h"
#include "device_edit_dlg.h"


typedef struct _edv_devices_list_win_struct	edv_devices_list_win_struct;
#define EDV_DEVICES_LIST_WIN(p)			((edv_devices_list_win_struct *)(p)) 


/*
 *	Devices List Window:
 */
struct _edv_devices_list_win_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gint            busy_count,
			freeze_count;
	EDVCore	*core;

	GtkWidget	*main_vbox,
			*find_entry,
			*devices_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*display_parent,	/* GtkVBox */
			*display_client,	/* Parented to display_parent */
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi;

	/* Important widgets on display_client */
	GtkWidget	*dev_icon_pm,
			*dev_name_label,
			*dev_device_path_label,
			*dev_mount_path_label,
			*dev_fs_type_label,
			*dev_mount_btn,
			*dev_eject_btn,
			*dev_properties_btn,
			*dev_fsck_btn,
			*dev_tools_btn,
			*dev_format_btn,
			*dev_pie_chart;

	edv_device_edit_dlg_struct	*device_edit_dlg;
};


/* Callbacks */
extern void EDVDevicesListWinUsageChangedCB(
	edv_devices_list_win_struct *lw
);
extern void EDVDevicesListWinReconfiguredNotifyCB(
	edv_devices_list_win_struct *lw
);
extern void EDVDevicesListWinMountNotifyCB(
	edv_devices_list_win_struct *lw,
	const gint dev_num, EDVDevice *d,
	const gboolean is_mounted
);
extern void EDVDevicesListWinDeviceAddedCB(
	edv_devices_list_win_struct *lw,
	const gint dev_num, EDVDevice *d
);
extern void EDVDevicesListWinDeviceModifiedCB(
	edv_devices_list_win_struct *lw,
	const gint dev_num, EDVDevice *d
);
extern void EDVDevicesListWinDeviceRemovedCB(
	edv_devices_list_win_struct *lw,
	const gint dev_num
);

/* Set Row */
extern void EDVDevicesListWinSetRow(
	edv_devices_list_win_struct *lw,
	const gint row,
	EDVDevice *d
);

/* Select */
extern void EDVDevicesListWinSelect(
	edv_devices_list_win_struct *lw,
        const gint i
);
extern gint EDVDevicesListSelectByPath(
	edv_devices_list_win_struct *lw,
        const gchar *path
);

/* Get Devices List */
extern void EDVDevicesListWinGetList(
	edv_devices_list_win_struct *lw,
	const gboolean verbose
);

/* Devices List Window */
extern edv_devices_list_win_struct *EDVDevicesListWinNew(EDVCore *core);
extern void EDVDevicesListWinUpdateMenus(edv_devices_list_win_struct *lw);
extern void EDVDevicesListSetBusy(
	edv_devices_list_win_struct *lw,
	const gboolean busy
);
extern gboolean EDVDevicesListWinIsMapped(edv_devices_list_win_struct *lw);
extern void EDVDevicesListWinMap(edv_devices_list_win_struct *lw);
extern void EDVDevicesListWinUnmap(edv_devices_list_win_struct *lw);
extern void EDVDevicesListWinDelete(edv_devices_list_win_struct *lw);


#endif	/* DEVICES_LIST_WIN_H */
