/*
			    Devices Edit Dialog
 */

#ifndef DEVICE_EDIT_DLG_H
#define DEVICE_EDIT_DLG_H

#include <gtk/gtk.h>

#include "pie_chart.h"
#include "edv_types.h"
#include "edv_device.h"


typedef struct _edv_device_edit_dlg_struct	edv_device_edit_dlg_struct;
#define EDV_DEVICE_EDIT_DLG(p)			((edv_device_edit_dlg_struct *)(p))


/*
 *	Device Edit Dialog:
 */
struct _edv_device_edit_dlg_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gint            busy_count,
			freeze_count;
	gboolean	has_changes;
	EDVCore *core;

	GtkWidget       *main_vbox,
			*name_entry,
			*device_path_entry,
			*mount_path_entry,
			*fs_type_pulistbox,
			*command_mount_entry,
			*command_unmount_entry,
			*command_eject_entry,
			*command_check_entry,
			*command_tools_entry,
			*command_format_entry,
			*no_unmount_check,
			*read_only_check,
			*unlisted_check,
			*no_scan_check,
			*icon_small_ip,
			*icon_medium_ip,
			*icon_large_ip,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;

	gint		dev_num;		/* Reference to the Device
						 * being edited */


        /* Icon Selector Dialog */
        GtkWidget	*icon_sel_dlg;
};


/* Callbacks */
extern void EDVDeviceEditDlgDeviceRemovedCB(
	edv_device_edit_dlg_struct *d,
	const gint dev_num
);

/* Get & Set Values */
extern void EDVDeviceEditDlgGetValues(
	edv_device_edit_dlg_struct *d,
	const gint dev_num
);
extern void EDVDeviceEditDlgSetValues(
	edv_device_edit_dlg_struct *d,
	const gint dev_num,
	const gboolean verbose
);

/* Device Edit Dialog */
extern edv_device_edit_dlg_struct *EDVDeviceEditDlgNew(EDVCore *core);
extern void EDVDeviceEditDlgResetHasChanges(
	edv_device_edit_dlg_struct *d,
	const gboolean has_changes
);
extern void EDVDeviceEditDlgUpdateMenus(edv_device_edit_dlg_struct *d);
extern gboolean EDVDeviceEditDlgIsMapped(edv_device_edit_dlg_struct *d);
extern void EDVDeviceEditDlgMap(edv_device_edit_dlg_struct *d);
extern void EDVDeviceEditDlgUnmap(edv_device_edit_dlg_struct *d);
extern void EDVDeviceEditDlgDelete(edv_device_edit_dlg_struct *d);


#endif	/* DEVICE_EDIT_DLG_H */
