/*
			     Desktop Icon

	An icon with an optional label and menu displayed on the
	desktop.
 */

#ifndef DESKTOP_ICON_H
#define DESKTOP_ICON_H

#include <gtk/gtk.h>


/*
 *	Flags:
 */
typedef enum {
	DESKTOP_ICON_MAPPED		= (1 << 0),
	DESKTOP_ICON_REALIZED		= (1 << 1),
	DESKTOP_ICON_CAN_SELECT		= (1 << 2),
	DESKTOP_ICON_CAN_MOVE		= (1 << 3),
	DESKTOP_ICON_CAN_RENAME		= (1 << 4),
	DESKTOP_ICON_ALWAYS_ON_TOP	= (1 << 5),
	DESKTOP_ICON_IS_MOVING		= (1 << 8)
} desktop_icon_flags;


extern GtkWidget *DesktopIconNew(
	const desktop_icon_flags flags,
	const gint x, const gint y,
	guint8 **icon_data,
	const gchar *icon_path,
	const gchar *label
);

extern GtkWidget *DesktopIconGetIconWidget(GtkWidget *w);

extern void DesktopIconSetPosition(
	GtkWidget *w,
	const gint x, const gint y
);
extern gboolean DesktopIconGetPosition(
	GtkWidget *w,
	gint *x_rtn, gint *y_rtn
);

extern void DesktopIconSet(
	GtkWidget *w,
	guint8 **icon_data,
	const gchar *label
);
extern void DesktopIconSetFile(
        GtkWidget *w,
        const gchar *icon_path,
        const gchar *label
);
extern gboolean DesktopIconGet(
	GtkWidget *w,
	guint8 ***icon_data_rtn,
	const gchar **icon_path_rtn,
	const gchar **label_rtn
);

extern void DesktopIconSetSensitive(
	GtkWidget *w,
	const gboolean sensitive
);
extern gboolean DesktopIconGetSensitive(GtkWidget *w);
#define DesktopIconIsSensitive		DesktopIconGetSensitive

extern void DesktopIconSetAlwaysOnTop(
	GtkWidget *w,
	const gboolean always_on_top
);
extern gboolean DesktopIconGetAlwaysOnTop(GtkWidget *w);

extern gboolean DesktopIconGetSelected(GtkWidget *w);
#define DesktopIconIsSelected		DesktopIconGetSelected
extern void DesktopIconSelect(GtkWidget *w);
extern void DesktopIconUnselect(GtkWidget *w);

extern void DesktopIconSetMenu(
	GtkWidget *w,
	GtkWidget *menu
);
extern GtkWidget *DesktopIconGetMenu(GtkWidget *w);

extern void DesktopIconSetMapRefCB(
	GtkWidget *w,
	void (*activate_cb)(GtkWidget *, gpointer),
	gpointer data
);
extern void DesktopIconSetSelectCB(
	GtkWidget *w,
	void (*select_cb)(GtkWidget *, gpointer),
	gpointer data
);
extern void DesktopIconSetUnselectCB(
	GtkWidget *w,
	void (*unselect_cb)(GtkWidget *, gpointer),
	gpointer data
);
extern void DesktopIconSetRenameCB(
	GtkWidget *w,
	void (*rename_cb)(GtkWidget *, const gchar *, const gchar *, gpointer),
	gpointer data
);
extern void DesktopIconSetMoveBeginCB(
	GtkWidget *w,
	void (*move_begin_cb)(GtkWidget *, const gint, const gint, gpointer),
	gpointer data
);
extern void DesktopIconSetMovingCB(
	GtkWidget *w,
	void (*moving_cb)(GtkWidget *, const gint, const gint, gpointer),
	gpointer data
);
extern void DesktopIconSetMovedCB(
	GtkWidget *w,
	void (*moved_cb)(GtkWidget *, const gint, const gint, gpointer),
	gpointer data
);

extern gboolean DesktopIconIsMapped(GtkWidget *w);
extern void DesktopIconMap(GtkWidget *w);
extern void DesktopIconUnmap(GtkWidget *w);
extern GtkWidget *DesktopIconRef(GtkWidget *w);
extern GtkWidget *DesktopIconUnref(GtkWidget *w);


#endif	/* DESKTOP_ICON_H */
