#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "../include/string.h"

#include "cfg.h"

#include "guiutils.h"
#include "style_edit.h"
#include "menucfg_list.h"
#include "cfg_win.h"

#include "edv_types.h"
#include "libendeavour2-base/edv_utils.h"
#include "edv_utils_gtk.h"
#include "customize_win.h"
#include "edv_cb.h"
#include "endeavour2.h"

#include "edv_cfg_list.h"
#include "config.h"

#include "images/icon_customize_48x48.xpm"
#include "images/icon_endeavour_20x20.xpm"
#include "images/icon_endeavour_file_browser_20x20.xpm"
#include "images/icon_endeavour_image_browser_20x20.xpm"
#include "images/icon_endeavour_archiver_20x20.xpm"


/* Utils */
gchar *EDVCustomizeSimplifyOPIDName(const gchar *name);

/* Global */
void EDVCustomizeGlobalCreateObjectOpsMenuPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
void EDVCustomizeGlobalCreateNewObjectsMenuPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
void EDVCustomizeGlobalCreateListsPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
void EDVCustomizeGlobalCreateStylesPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
void EDVCustomizeGlobalCreateAppearancePage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);

/* Customize Window */
gboolean EDVCustomizeWindowSelectTab(
	GtkWidget *cfgwin,
	const gchar *tab_name
);
GtkWidget *EDVCustomizeWindowNew(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns a simplified Operation ID menu name.
 *
 *	Removes all occurances of "_" and "..." in the specified name.
 *
 *	The calling function must delete the returned string.
 */
gchar *EDVCustomizeSimplifyOPIDName(const gchar *name)
{
	gchar		*s,
					*name_rtn;

	if(name == NULL)
		return(g_strdup(""));

	/* Copy the specified name */
	name_rtn = g_strdup(name);
	if(name_rtn == NULL)
		return(g_strdup("")); 

	/* Remove all occurances of "_" */
	s = edv_strsub(
		name_rtn,
		"_",
		""
	);
	g_free(name_rtn);
	name_rtn = s;

	/* Remove all occurances of "..." */
	s = edv_strsub(
		name_rtn,
		"...",
		""
	);
	g_free(name_rtn);
	name_rtn = s;

	/* Strip spaces */
	name_rtn = g_strstrip(name_rtn);

	return(name_rtn);
}


/*
 *	Creates the General New Objects Menu page.
 */
void EDVCustomizeGlobalCreateObjectOpsMenuPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5;
	GtkWidget	*w,
					*parent2, *parent3;
	CfgWinLink *cfg_link;
	menucfg_list_struct *menucfg_list;

	gtk_container_border_width(GTK_CONTAINER(parent), border_major);

	/* Object Ops Menu Frame */
	w = gtk_frame_new("Object Ops Menu");
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

w = gtk_hbox_new(FALSE, border_major);
gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
gtk_widget_show(w);
parent3 = w;

w = gtk_label_new(
"This menu typically appears as either a submenu or a subsection under the File menu of most\n\
windows. It allows you to create customized commands that are to be executed on the selected\n\
objects.\n\
\n\
Each item's command must have the \"%paths\" or \"%p\" token to substitute for the selected\n\
objects."
);
gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
gtk_widget_show(w);

	/* MenuCfg List */
	menucfg_list = MenuCfgListNew(
		parent2,
		GTK_ORIENTATION_HORIZONTAL
	);
	MenuCfgListSetListStyle(menucfg_list, MENUCFG_LIST_STYLE_DETAILS);
	MenuCfgListSetEditable(menucfg_list, TRUE);
	MenuCfgListMap(menucfg_list);

	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_MENUCFG_LIST,
		menucfg_list,
		EDV_CFG_PARM_OBJECT_OPS_MENU
	);

}

/*
 *	Creates the General New Objects Menu page.
 */
void EDVCustomizeGlobalCreateNewObjectsMenuPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5;
	GList *glist;
	GtkWidget *w, *parent2, *parent3;
	CfgWinLink *cfg_link;
	menucfg_list_struct *menucfg_list;

	gtk_container_border_width(GTK_CONTAINER(parent), border_major);

	/* New Objects Menu Frame */
	w = gtk_frame_new("New Objects Menu");
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

w = gtk_hbox_new(FALSE, border_major);
gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
gtk_widget_show(w);
parent3 = w;

w = gtk_label_new(
"This menu typically appears as either a submenu or a subsection when you go to File->New on\n\
most windows. It allows you to create customized commands that create a new object and then runs\n\
a program to edit that object.\n\
\n\
Each item's command must have the \"%p\" token to substitute for the new object."
);
gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
gtk_widget_show(w);

	/* MenuCfg List */
	menucfg_list = MenuCfgListNew(
		parent2,
		GTK_ORIENTATION_HORIZONTAL
	);
	glist = NULL;
	glist = g_list_append(glist, "Extension");
	MenuCfgListSetCustomData(menucfg_list, glist);
	g_list_foreach(glist, (GFunc)g_free, NULL);
	g_list_free(glist);
	MenuCfgListSetListStyle(menucfg_list, MENUCFG_LIST_STYLE_DETAILS);
	MenuCfgListSetEditable(menucfg_list, TRUE);
	MenuCfgListMap(menucfg_list);

	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_MENUCFG_LIST,
		menucfg_list,
		EDV_CFG_PARM_NEW_OBJECTS_MENU
	);
}

/*
 *	Creates the General Lists page.
 */
void EDVCustomizeGlobalCreateListsPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5, 
					border_minor = 2; 
	gint i;
	GtkWidget	*w,
					*pulist,
					*parent2, *parent3, *parent4;
	CfgWinLink *cfg_link;

	gtk_container_border_width(GTK_CONTAINER(parent), border_major);

	/* Trees GtkFrame */
	w = gtk_frame_new("Trees");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Lines Style */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_label_new("Lines Style:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = PUListBoxNew(
		100, -1
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	pulist = PUListBoxGetPUList(w);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);

#define APPEND_ITEM(_s_,_v_)	{	\
 i = PUListAddItem(pulist, (_s_));	\
 PUListSetItemData(			\
  pulist,				\
  i,					\
  (gpointer)(_v_)			\
 );					\
}
	APPEND_ITEM("Solid",		GTK_CTREE_LINES_SOLID);
	APPEND_ITEM("Dotted",		GTK_CTREE_LINES_DOTTED);
	APPEND_ITEM("Tabbed",		GTK_CTREE_LINES_TABBED);
#undef APPEND_ITEM
	PUListBoxSetLinesVisible(w, MIN((i + 1), 10));
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
		w,
		EDV_CFG_PARM_TREE_LINES_STYLE
	);

	/* Expander Style */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_label_new("Expander Style:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = PUListBoxNew(
		100, -1
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	pulist = PUListBoxGetPUList(w);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);

#define APPEND_ITEM(_s_,_v_)	{	\
 i = PUListAddItem(pulist, (_s_));	\
 PUListSetItemData(			\
  pulist,				\
  i,					\
  (gpointer)(_v_)			\
 );					\
}
	APPEND_ITEM("Square",		GTK_CTREE_EXPANDER_SQUARE);
	APPEND_ITEM("Triangle",		GTK_CTREE_EXPANDER_TRIANGLE);
	APPEND_ITEM("Circular",		GTK_CTREE_EXPANDER_CIRCULAR);
#undef APPEND_ITEM
	PUListBoxSetLinesVisible(w, MIN((i + 1), 10));
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
		w,
		EDV_CFG_PARM_TREE_EXPANDER_STYLE
	);

}

/*
 *	Creates the General Styles page.
 */
void EDVCustomizeGlobalCreateStylesPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5, 
					border_minor = 2; 
	GtkWidget *w, *parent2, *parent3;
	CfgWinLink *cfg_link;
	style_edit_struct *se;

	gtk_container_border_width(GTK_CONTAINER(parent), border_major);

	/* Styles GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Styles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stil"
#else
"Styles"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Override GTK Style Check */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Haga Caso Omiso El Estilo De GTK"
#elif defined(PROG_LANGUAGE_FRENCH)
"Annuler Le Style De GTK"
#elif defined(PROG_LANGUAGE_GERMAN)
"Heben Sie GTK Stil Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Annullare Lo Stile Di GTK"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hef GTK Stijl Op"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anule Estilo De GTK"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilsidesettende GTK Stil"
#else
"Override GTK Style"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_GTK_STYLE_OVERRIDE
	);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Standard Style Edit */
	se = StyleEditNew(
		parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo Uniforme"
#elif defined(PROG_LANGUAGE_FRENCH)
"Style Standard"
#elif defined(PROG_LANGUAGE_GERMAN)
"Normaler Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile Standard"
#elif defined(PROG_LANGUAGE_DUTCH)
"Normale Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Estilo Normal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Normal Stil"
#else
"Standard Style"
#endif   
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_STYLE_EDIT,
		se,
		EDV_CFG_PARM_STYLE_STANDARD 
	);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Lists Style Edit */
	se = StyleEditNew(
		parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo De Listas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Style De Listes"    
#elif defined(PROG_LANGUAGE_GERMAN)
"Listen Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile Di Elenchi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Lijsten Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo De Listas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Liste Stil"
#else
"Lists Style"
#endif   
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_STYLE_EDIT,
		se,
		EDV_CFG_PARM_STYLE_LISTS    
	);
}

/*
 *	Creates the General Appearance page.
 */
void EDVCustomizeGlobalCreateAppearancePage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	const gchar *data_dir;
	gchar *path;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GdkWindow *window;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3, *parent4;
	CfgItem *cfg_list = core->cfg_list;
	CfgWinLink *cfg_link;

	gtk_container_border_width(GTK_CONTAINER(parent), border_major);

	/* Realize the CfgWin as needed so we can get its GdkWindow */
	if(!GTK_WIDGET_REALIZED(cfgwin))
		gtk_widget_realize(cfgwin);
	window = cfgwin->window;

	/* Get the current global data directory from the current
	 * configuration
	 */
	data_dir = EDV_GET_S(EDV_CFG_PARM_DIR_GLOBAL);

	/* Window Placement GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Colocacin De La Ventana"
#elif defined(PROG_LANGUAGE_FRENCH)
"Placement De Fentre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster Unterbringung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Collocamento Di Finestra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Raam Plaatsing"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Colocao De Janela"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vindu Plassering"
#else
"Window Placement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Window Cascade Offset GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* GtkLabel */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Desviacin De La Cascada"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Cascade A Dcal"
#elif defined(PROG_LANGUAGE_GERMAN)
"Strzen Sie Ausgleich Herab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Cascata Contrappone"
#elif defined(PROG_LANGUAGE_DUTCH)
"Val Compensatie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cascata Compensar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Cascade Motvekt"
#else
"Cascade Offset"
#endif
		" X:"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Cascade Offset X GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, -100000.0f, 100000.0f,
		1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	GUIEditableEndowPopupMenu(w, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X
	);

	/* GtkLabel */
	w = gtk_label_new("Y:");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Cascade Offset Y GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, -100000.0f, 100000.0f,
		1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	GUIEditableEndowPopupMenu(w, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y
	);


	/* Tool Tips GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Instrumento Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Outil Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Neigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Attrezzo Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Tipt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Ferramenta Vira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Velter"
#else
"Tips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Show Tooltips & Texttips GtkHBox */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Tooltips GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	path = g_strconcat(
		data_dir,
		G_DIR_SEPARATOR_S,
		EDV_NAME_TOOLTIPS_EXAMPLE_IMAGE_FILE,
		NULL
	);
	pixmap = gdk_pixmap_create_from_xpm(
		window,
		&mask,
		NULL,
		path
	);
	g_free(path);
	if(pixmap != NULL)
	{
		/* Example Pixmap */
		w = gtk_pixmap_new(pixmap, mask);
		GDK_PIXMAP_UNREF(pixmap);
		GDK_BITMAP_UNREF(mask);
		gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
		gtk_widget_show(w);
	}

	/* Show Tooltips GtkCheckButton */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Instrumento De La Exposicin Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Outil De Spectacle Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie Werkzeug Spitzen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Attrezzo Di Mostra Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon Aan Werktuig Fooien"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ferramenta De Exposio Vira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis RedskapTupper"
#else
"Show Tooltips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_SHOW_TOOLTIPS
	);


	/* Show Texttips GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	path = g_strconcat(
		data_dir,
		G_DIR_SEPARATOR_S,
		EDV_NAME_TEXTTIPS_EXAMPLE_IMAGE_FILE,
		NULL
	);
	pixmap = gdk_pixmap_create_from_xpm(
		window,
		&mask,
		NULL,
		path
	);
	g_free(path);
	if(pixmap != NULL)
	{
		/* Example Pixmap */
		w = gtk_pixmap_new(pixmap, mask);
		GDK_PIXMAP_UNREF(pixmap);
		GDK_BITMAP_UNREF(mask);
		gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
		gtk_widget_show(w);
	}

	/* Show Texttips GtkCheckButton */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Texto De La Exposicio'n Inclina"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte De Spectacle Se Renverse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schauentext Neigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Testo Di Mostra Rovescia"
#elif defined(PROG_LANGUAGE_DUTCH)
"De Vertoning Tekst Tipt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Texto De Exposic"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstillingstekst Velter"
#else
"Show Texttips"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_SHOW_TEXTTIPS
	);
}


/*
 *	Selects the page by the tab name.
 *
 *	Returns TRUE if the page was switched to or FALSE on error.
 */
gboolean EDVCustomizeWindowSelectTab(
	GtkWidget *cfgwin,
	const gchar *tab_name
)
{
	gboolean status;

	if(cfgwin == NULL)
		return(FALSE);

	if(STRISEMPTY(tab_name))
	{
		CfgWinSetPage(
			cfgwin,
			NULL				/* Default page */
		);
		status = TRUE;
	}
	else
	{
		GtkWidget *page = CfgWinGetPageByLabel(
			cfgwin,
			NULL,				/* Toplevel page */
			tab_name,			/* Label */
			FALSE				/* Do not recurse */
		);
		if(page != NULL)
		{
			CfgWinSetPage(
				cfgwin,
				page
			);
			status = TRUE;
		}
		else
		{
			status = FALSE;
		}
	}

	return(status);
}

/*
 *	Creates a new Customize Window.
 */
GtkWidget *EDVCustomizeWindowNew(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
)
{
	const gint	border_minor = 2;
	const gchar *c_decl;
	guint8 **icon_data;
	GtkWidget	*w,
					*parent,
					*cfgwin,
					*page;

	if(core == NULL)
		return(NULL);

	cfgwin = CfgWinNew(
		CFG_WIN_STYLE_NOTEBOOK,
		PROG_NAME ": "
#if defined(PROG_LANGUAGE_SPANISH)
"Haga Personal"
#elif defined(PROG_LANGUAGE_FRENCH)
"Personnaliser"
#elif defined(PROG_LANGUAGE_GERMAN)
"Passen Sie An"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Personalizzare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Aanpas"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Pessoal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Personlig"
#else
"Customize"
#endif
		,
		(guint8 **)icon_customize_48x48_xpm,
		CFG_WIN_BUTTON_OK | CFG_WIN_BUTTON_APPLY |
			CFG_WIN_BUTTON_CANCEL | CFG_WIN_BUTTON_CLOSE,
		640, 480,
		core->cfg_list,
		core->cfg_path,
		geometry_flags,
		geometry
	);
	if(cfgwin == NULL)
		return(NULL);

	gtk_object_set_data(
		GTK_OBJECT(cfgwin),
		EDV_CORE_KEY,
		core
	);

	CfgWinSetApplyCB(
		cfgwin,
		edv_cfg_win_apply_cb, core
	);

	/* Global Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = edv_new_pixmap_widget(
		core,
		(guint8 **)icon_endeavour_20x20_xpm,
		"icon_endeavour_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Global"
#elif defined(PROG_LANGUAGE_FRENCH)
"Global"
#elif defined(PROG_LANGUAGE_GERMAN)
"Global"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Globale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Globaal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Global"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Global"
#else
"Global"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Global",
		w,
		TRUE				/* Is parent */
	);
	if(parent != NULL)
	{
		GtkWidget *parent_page = page;

		/* Appearance Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Appearance",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeGlobalCreateAppearancePage(
			core,
			cfgwin,
			parent
		);

		/* Styles Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Estilo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Styles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stil"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Stile"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stijl"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Estilo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stil"
#else
"Styles"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Styles",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeGlobalCreateStylesPage(
			core,
			cfgwin,
			parent
		);

		/* Lists Page */
		w = gtk_label_new("Lists");
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Lists",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeGlobalCreateListsPage(
			core,
			cfgwin,
			parent
		);

		/* Object Ops Menu */
		w = gtk_label_new(
"Object Ops Menu"
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Object Ops Menu",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeGlobalCreateObjectOpsMenuPage(
			core,
			cfgwin,
			parent
		);

		/* New Objects Menu */
		w = gtk_label_new(
"New Objects Menu"
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"New Objects Menu",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeGlobalCreateNewObjectsMenuPage(
			core,
			cfgwin,
			parent
		);
	}

	/* File Browser Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = edv_new_pixmap_widget(
		core,
		(guint8 **)icon_endeavour_file_browser_20x20_xpm,
		"icon_endeavour_file_browser_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Archive A Examinador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Classer Le Navigateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datei Browser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Schedare Il Browser"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archiveer Browser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquive Browser"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiver Browser"
#else
"File Browser"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"File Browser",
		w,
		TRUE				/* Is a parent */
	);
	if(parent != NULL)
	{
		GtkWidget *parent_page = page;

		/* Appearance Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Appearance",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeBrowserCreateAppearancePage(
			core,
			cfgwin,
			parent
		);

		/* Tool Bar Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Tool Bar",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeBrowserCreateToolBarPage(
			core,
			cfgwin,
			parent
		);

		/* Contents List Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Contents List",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeBrowserCreateContentsListPage(
			core,
			cfgwin,
			parent
		);

		/* Keymaps Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else
"Keymaps"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Keymaps",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeBrowserCreateKeymapsPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Image Browser Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = edv_new_pixmap_widget(
		core,
		(guint8 **)icon_endeavour_image_browser_20x20_xpm,
		"icon_endeavour_image_browser_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Imagine A Examinador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Navigateur D'Image"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bildnis Browser"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Browser Di Immagine"
#elif defined(PROG_LANGUAGE_DUTCH)
"Beeld Browser"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Browser De Imagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Avbilde Browser"
#else
"Image Browser"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Image Browser",
		w,
		TRUE				/* Is a parent */
	);
	if(parent != NULL)
	{
		GtkWidget *parent_page = page;

		/* Appearance Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Appearance",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeImbrCreateAppearancePage(
			core,
			cfgwin,
			parent
		);

		/* Tool Bar Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Tool Bar",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeImbrCreateToolBarPage(
			core,
			cfgwin,
			parent
		);

		/* Thumbs List Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista De Pulgares"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Pouces Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Daumen Fhren Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Pollici"
#elif defined(PROG_LANGUAGE_DUTCH)
"Duimen Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Polegares Alistam"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tommelfinger Lister Opp"
#else
"Thumbs List"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Thumbs List",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeImbrCreateThumbsListPage(
			core,
			cfgwin,
			parent
		);

		/* Keymaps Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen" 
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else         
"Keymaps"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Keymaps",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeImbrCreateKeymapsPage(
			core,
			cfgwin,
			parent
		);

		/* Presentation Mode Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Modo De Presentacio'n"
#elif defined(PROG_LANGUAGE_FRENCH)
"Mode De Pre'sentation"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vorstellungsmodus"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Modo Di Presentazione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Voorstelling Modus"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Modo De Apresentacao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"FramstillingsModus"
#else
"Presentation Mode"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Presentation Mode",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeImbrCreatePresentationPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Archiver Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = edv_new_pixmap_widget(
		core,
		(guint8 **)icon_endeavour_archiver_20x20_xpm,
		"icon_endeavour_archiver_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Fabricante Del Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Archiver Le Fabricant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Archivieren Sie Hersteller"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Fabbricante Di Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archief Maker"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Criador De Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv Skaper"
#else
"Archiver"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Archiver",
		w,
		TRUE				/* Is a parent */
	);
	if(parent != NULL)
	{
		GtkWidget *parent_page = page;

		/* Appearance Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Appearance",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeArchiverCreateAppearancePage(
			core,
			cfgwin,
			parent
		);

		/* Tool Bar Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Tool Bar",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeArchiverCreateToolBarPage(
			core,
			cfgwin,
			parent
		);

		/* Contents List Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Contents List",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeArchiverCreateContentsListPage(
			core,
			cfgwin,
			parent
		);

		/* Keymaps Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else
"Keymaps"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Keymaps",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeArchiverCreateKeymapsPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Recycle Bin Page */
	parent = gtk_hbox_new(FALSE, border_minor);
	icon_data = edv_get_recycle_bin_icon_data(
		EDV_ICON_SIZE_20,
		1,
		&c_decl
	);
	w = edv_new_pixmap_widget(
		core,
		icon_data,
		c_decl
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Cajn De Refycle"
#elif defined(PROG_LANGUAGE_FRENCH)
"Refycle Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Refycle Behlter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Recipiente Di Refycle"
#elif defined(PROG_LANGUAGE_DUTCH)
"Refycle Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Caixa De Refycle"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Refycle Beholder"
#else
"Recycle Bin"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	w = parent;
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Recycle Bin",
		w,
		TRUE				/* Is a parent */
	);
	if(parent != NULL)
	{
		GtkWidget *parent_page = page;

		/* Appearance Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Apariencia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Apparence"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erscheinung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Apparenza"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verschijning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Aparncia"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utseende"
#else
"Appearance"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Appearance",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeRecBinCreateAppearancePage(
			core,
			cfgwin,
			parent
		);

		/* Tool Bar Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Barra Del Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Tool Bar",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeRecBinCreateToolBarPage(
			core,
			cfgwin,
			parent
		);

		/* Contents List Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Lista Del Contenido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Contenus Enumrent"
#elif defined(PROG_LANGUAGE_GERMAN)
"Inhalt Liste"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Elenco Di Contenuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Inhoud Lijst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Lista De Contedo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innhold Liste"
#else
"Contents List"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Contents List",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeRecBinCreateContentsListPage(
			core,
			cfgwin,
			parent
		);

		/* Keymaps Page */
		w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios Claves"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadres Cles"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schlusseleinstellungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi Principali"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hoofdstanden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cenarios Chave"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Fest Innstillinger"
#else
"Keymaps"
#endif
		);
		parent = page = CfgWinAddPageNotebook(
			cfgwin,
			parent_page,
			-1,				/* Append */
			"Keymaps",
			w,
			FALSE				/* Not a parent */
		);
		EDVCustomizeRecBinCreateKeymapsPage(
			core,
			cfgwin,
			parent
		);
	}


	return(cfgwin);
}
