/*
			    Color Selection Dialog
 */

#ifndef CSD_H
#define CSD_H

#include <gtk/gtk.h>


/*
 *	Color Selection Dialog Color:
 */
typedef struct {
	gfloat		r,			/* 0.0 to 1.0 */
			g,
			b,
			a;
} csd_color_struct;


/* Color Selection Dialog */
extern gint CSDInit(void);
extern void CSDSetStyle(GtkRcStyle *rc_style);
extern void CSDSetTransientFor(GtkWidget *w);
extern gboolean CSDIsQuery(void);
extern void CSDBreakQuery(void);
extern gboolean CSDGetResponse(
	const gchar *title,
	const gchar *ok_label, const gchar *cancel_label,
	csd_color_struct *start_color,
	csd_color_struct **color_rtn,
	void (*color_changed_cb)(
		csd_color_struct *,
		gpointer
	),
	gpointer color_changed_data
);
extern void CSDMap(void);
extern void CSDUnmap(void);
extern void CSDShutdown(void);


/* Color Button */
extern GtkWidget *CSDColorButtonNew(
	const gchar *label,
	const gint label_width,
	void (*cb)(GtkWidget *, gpointer),
	gpointer data
);
extern GtkWidget *CSDColorButtonNewSimple(
	const gchar *label,
	const gint label_width
);
extern GtkWidget *CSDColorButtonGetButton(GtkWidget *w);
extern void CSDColorButtonGetColor(
	GtkWidget *w,
	csd_color_struct *c
);
extern void CSDColorButtonSetColor(
	GtkWidget *w,
	const csd_color_struct *c
);


#endif	/* CSD_H */
