/*
               Endeavour Mark II Compile Time Configuration

	For the configuration list declaration, see edv_cfg_list.h
 */

#ifndef CONFIG_H
#define CONFIG_H

#include <paths.h>


/*
 *	Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH		1
/* #define PROG_LANGUAGE_SPANISH	2 */
/* #define PROG_LANGUAGE_FRENCH		3 */
/* *incomplete* #define PROG_LANGUAGE_GERMAN	4 */
/* *incomplete* #define PROG_LANGUAGE_ITALIAN	5 */
/* *incomplete* #define PROG_LANGUAGE_DUTCH	6 */
/* *incomplete* #define PROG_LANGUAGE_NORWEGIAN	7 */
/* *incomplete* #define PROG_LANGUAGE_PORTUGUESE	8 */
/* #define PROG_LANGUAGE_POLISH		9 */


/*
 *      Program name and version:
 */
#define PROG_NAME			"Endeavour"
#define PROG_NAME_FULL			"Endeavour Mark II"
#define PROG_VERSION			"3.1.3"

#define PROG_VERSION_MAJOR		3
#define PROG_VERSION_MINOR		1
#define PROG_VERSION_RELEASE		3

/*
 *      Copyright message:
 */
#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_COPYRIGHT	"\
El derecho de autor (C) 1997-2009 WolfPack Entertainment.\n\
Este programa es protegido por leyes internacionales de derecho de autor\n\
y tratados, la distribucin y/o la modificacin de este software en la\n\
infraccin de la Licencia del Pblico de GNU se prohiben estrictamente.\n\
Violators ser procesado a la extensin ms repleta de la ley.\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_COPYRIGHT  "\
Dposer (C) 1997-2009 WolfPack Entertainment.\n\
Ce programme est protg par international dpose lois et traits, \n\
distribution et/ou de ce logiciel dans violation du GNU Public Permis\n\
strictement est interdit. Violators sera poursuivi  l'tendue plus pleine\n\
de la loi.\n"
#elif defined(PROG_LANGUAGE_GERMAN)
#define PROG_COPYRIGHT  "\
Urheberrecht (C) 1997-2009 WolfPack Entertainment.\n\
Dieses Programm wird von internationalem Urheberrecht Gesetzen und\n\
Vertrgen, Austeilung bzw. nderung dieser Software in bertretung\n\
DER GNU ffentlichkeit Erlaubnis streng verboten wird geschtzt.\n\
Verletzer werden zum vollsten Umfang des Gesetzes strafrechtlich\n\
verfolgt werden.\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
#define PROG_COPYRIGHT  "\
Il copyright (C) 1997-2009 WolfPack Entertainment.\n\
Questo programma  protetto dalle leggi di copyright internazionali e\n\
dai trattati, la distribuzione e/o la modifica di questo software nella\n\
violazione dello GNU la Licenza Pubblica  strettamente proibita. Il\n\
Violators sar perseguito all'estensione la pi piena della legge.\n"
#elif defined(PROG_LANGUAGE_DUTCH)
#define PROG_COPYRIGHT  "\
Auteursrecht (C) 1997-2009 WolfPack Entertainment.\n\
Deze programma wordt door internationale auteursrecht wetten en\n\
verdragen, verdeling en/of wijziging van deze software in overtreding\n\
van de GNU Publiek Vergunning strikt verboden wordt beschermd.\n\
Overtreders zullen te de volste omvang van de wet geprocedeerd worden.\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
#define PROG_COPYRIGHT  "\
Os direitos autorais (C) 1997-2009 WolfPack Entertainment.\n\
Este programa  protegido por direitos internacionais leis autorais e\n\
tratados, modificao de e/ou de distribuio deste software em infrao\n\
do GNU Licena Pblica precisamente  proibida. O Violators ser\n\
processado  plena extenso da lei.\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2009 WolfPack Entertainment.\n\
Dette programet beskytter av internasjonal copyrightlover og traktater,\n\
distribusjon og/eller modifikasjon av denne programvaren i overtredelse\n\
av GNU Public License er streng forbudt. Violators tiltalt til den\n\
fulleste omfang av loven.\n"
#else
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2009 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law.\n"
#endif


/*
 *      Credits Lines:
 */
#define PROG_CREDITS_LINES	{				\
 "    http://freshmeat.net/projects/endeavour2",	\
 " ",								\
 " Project Captain: Tara Milana",				\
 " ",								\
 "     Programmers: Dan Stimits, Beta Testing",			\
 "                  N Deepak, FreeBSD Porter",			\
 "                  Tara Milana",				\
 " ",								\
 " Graphic Artists: Tara Milana",				\
 " ",								\
 "       Packagers: Thierry Vignaud",				\
 "                  Guillaume Rousse",				\
 " ",								\
 "    Contributors: Remi Broemeling",				\
 " ",								\
 NULL								\
}


/*
 *	Environment Variable Names:
 */
#define ENV_VAR_NAME_BROWSER		"BROWSER"
#define ENV_VAR_NAME_DISPLAY		"DISPLAY"
#define ENV_VAR_NAME_HELPBROWSER	"HELPBROWSER"
#define ENV_VAR_NAME_HOME		"HOME"
#define ENV_VAR_NAME_PATH		"PATH"
#define ENV_VAR_NAME_PRINT		"PRINT"
#define ENV_VAR_NAME_PRINTCMD		"PRINTCMD"
#define ENV_VAR_NAME_PRINTCOMMAND	"PRINTCOMMAND"
#define ENV_VAR_NAME_PRINTER		"PRINTER"
#define ENV_VAR_NAME_SHELL		"SHELL"
#define ENV_VAR_NAME_TMPDIR		"TMPDIR"
#define ENV_VAR_NAME_USER		"USER"
#define ENV_VAR_NAME_USERNAME		"USERNAME"

#define ENV_VAR_NAME_EDVCFGFILE		"EDVCFGFILE"
#define ENV_VAR_NAME_EDVINTERPS		"EDVINTERPS"
#define ENV_VAR_NAME_EDVINTERPSLOCK	"EDVINTERPSLOCK"


/*
 *	GDK Font Names:
 */
#define EDV_GDK_FONT_NAME_18		\
        "-adobe-helvetica-medium-r-normal-*-18-*-*-*-p-*-iso8859-1"
#define EDV_GDK_FONT_NAME_12		\
	"-adobe-helvetica-medium-r-normal-*-12-*-*-*-p-*-iso8859-1"
#define EDV_GDK_FONT_NAME_8		\
        "-adobe-helvetica-medium-r-normal-*-8-*-*-*-p-*-iso8859-1"

#define EDV_GDK_FONT_NAME_FIXED_12	\
	"-adobe-courier-medium-r-*-*-12-*-*-*-*-*-iso8859-1"
#define EDV_GDK_FONT_NAME_FIXED_10	\
	"-adobe-courier-medium-r-*-*-10-*-*-*-*-*-iso8859-1"


/*
 *      List of archive format extensions supported by the Archiver
 *
 *	Each entry contains of two pointers to strings, the first
 *	string is a space separated list of extensions and the second
 *	string is a verbose name of the format
 *
 *	The last two pointers must be NULL and NULL
 */
#define EDV_ARCHIVER_ARCHIVE_FILE_EXTENSIONS	{		\
	".arj",		"ARJ Archive",				\
	".lha", 	"LHA Archive",				\
	".deb",		"Debian Linux Package",			\
	".rar",		"RAR Archive",				\
	".rpm",         "RedHat Linux Package",			\
	".tar",		"UNIX Tape Archive",			\
	".tar.bz2",	"BZip2 Compressed UNIX Tape Archive",	\
	".tar.gz .tgz",	"GZip Compressed UNIX Tape Archive",	\
	".tar.Z",	"Compressed UNIX Tape Archive",		\
	".xar",		"X Archive",				\
	".zip .pkzip .xpi .jar",	"PKZip Archive",	\
	NULL,		NULL					\
}


/*
 *	Paths & Names:
 *
 *	All C identifiers starting with EDV_PATH_ or EDV_NAME_ are
 *	program-specific paths and names.
 *
 *	All C identifiers starting with only PATH_ or NAME_ are
 *	platform-specific paths and names.
 */
#ifndef PREFIX
# define PREFIX				"/usr"
#endif
#define PATH_PREFIX			PREFIX

#ifndef SYSCONFDIR
# define SYSCONFDIR			"/etc"
#endif
#define PATH_SYSCONFDIR			SYSCONFDIR

#ifndef PATH_BIN
# if defined(_PATH_BIN)
#  define PATH_BIN			_PATH_BIN
# else
#  define PATH_BIN			"/bin"
# endif
#endif

#ifndef PATH_USR_BIN
# if defined(_PATH_USRBIN)
#  define PATH_USR_BIN			_PATH_USRBIN
# else
#  define PATH_USR_BIN			"/usr/bin"
# endif
#endif

#ifndef PATH_DEV
# if defined(_PATH_DEV)
#  define PATH_DEV			_PATH_DEV
# else
#  define PATH_DEV			"/dev"
# endif
#endif

#ifndef PATH_DEV_NULL
# if defined(_PATH_DEVNULL)
#  define PATH_DEV_NULL			_PATH_DEVNULL
# else
#  define PATH_DEV_NULL			"/dev/null"
# endif
#endif

#ifndef PATH_ETC_MNTTAB
# if defined(_PATH_ETCMNTTAB)
#  define PATH_ETC_MNTTAB		_PATH_ETCMNTTAB
# else
#  define PATH_ETC_MNTTAB		"/etc/mnttab"
# endif
#endif

#ifndef PATH_MNT
# if defined(_PATH_MNT)
#  define PATH_MNT			_PATH_MNT
# else
#  define PATH_MNT			"/mnt"
# endif
#endif

#ifndef PATH_PROC
# if defined(_PATH_PROC)
#  define PATH_PROC			_PATH_PROC
# else
#  define PATH_PROC			"/proc"
# endif
#endif

#ifndef PATH_PROC_MOUNTS
# if defined(_PATH_PROCMOUNTS)
#  define PATH_PROC_MOUNTS		_PATH_PROCMOUNTS
# else
#  define PATH_PROC_MOUNTS		"/proc/mounts"
# endif
#endif

#ifndef PATH_PROC_FILESYSTEMS
# if defined(_PATH_PROCFILESYSTEMS)
#  define PATH_PROC_FILESYSTEMS		_PATH_PROCFILESYSTEMS
# else
#  define PATH_PROC_FILESYSTEMS		"/proc/filesystems"
# endif
#endif

#ifndef PATH_TMP
# if defined(_PATH_TMP)
#  define PATH_TMP			_PATH_TMP
# else
#  define PATH_TMP			"/tmp"
# endif
#endif



/*
 *	Default Per-User Data Directory Name:
 *
 *	The user's home directory will be prefixed to this.
 */
#define EDV_NAME_DEF_USER_DATA_DIR	".endeavour2"

/*
 *	Default Global Shared Data Directory Path:
 */
#define EDV_PATH_DEF_GLOBAL_DATA_DIR	PATH_PREFIX "/share/endeavour2"

/*
 *	Default Global Architecture-Dependent Data Directory Path:
 */
#define EDV_PATH_DEF_GLOBAL_LIB_DIR	PATH_PREFIX "/lib/endeavour2"

/*
 *	Default Global Configuration Directory Path:
 */
#define EDV_PATH_DEF_GLOBAL_ETC_DIR	PATH_SYSCONFDIR "/endeavour2"


/*
 *	Architecture-Dependent Subdirectory Names:
 *
 *	The EDV_PATH_DEF_GLOBAL_LIB_DIR value will be prefixed to
 *	all of these.
 */
#define EDV_NAME_BIN_SUBDIR		"bin"


/*
 *	Shared Data Subdirectory Names:
 *
 *	The EDV_PATH_DEF_GLOBAL_DATA_DIR value will be prefixed to
 *	all of these.
 */
#define EDV_NAME_ANIMATIONS_SUBDIR	"animations"
#define EDV_NAME_ICONS_SUBDIR		"icons"
#define EDV_NAME_IMAGES_SUBDIR		"images"


/*
 *	File Names:
 *
 *	A full path will be prefixed to each of these values, so they
 *	must all be relative paths.
 */
#define EDV_NAME_LICENSE_FILE		"LICENSE"
#define EDV_NAME_DEF_CONFIG_FILE	"endeavour2.ini"
#define EDV_NAME_DEF_DEVICES_FILE	"devices.ini"
#define EDV_NAME_DEF_MIME_TYPES_FILE	"mimetypes.ini"
#define EDV_NAME_DEF_HISTORY_FILE	"history.log"
#define EDV_NAME_DEF_FILE_BROWSER_LOCATION_HISTORY_FILE	\
					"browser_location_history.ini"
#define EDV_NAME_DEF_IMAGE_BROWSER_LOCATION_HISTORY_FILE	\
					"image_browser_location_history.ini"
#define EDV_NAME_DEF_ARCHIVER_LOCATION_HISTORY_FILE	\
					"archiver_location_history.ini"
#define EDV_NAME_DEF_RUN_HISTORY_FILE	"run_history.ini"

#define EDV_NAME_DEF_RECYCLE_BIN_INDEX_FILE	\
					"recycled/recycled.ini"
#define EDV_NAME_DEF_RECYCLE_BIN_LOCK_LINK	\
					"recycle_bin_lock"

/* Directory Statistics Program */
#define EDV_NAME_DIRECTORY_STATISTICS	"directory-statistics"

/* Message Dialog Program */
#define EDV_NAME_MESSAGE_DIALOG		"message-dialog"

/* InterPS */
#define EDV_NAME_INTERPS_LOCK_LINK	"lock"
#define EDV_NAME_INTERPS_DIR		"interps"

/* Directory Extended Properties */
#define EDV_NAME_DIRECTORY_PROPERTIES_FILE	\
					".edv_info.ini"

/* Image Files */
#define EDV_NAME_ABOUT_IMAGE_FILE	EDV_NAME_IMAGES_SUBDIR \
						"/endeavour_about.xpm"
#define EDV_NAME_SPLASH_IMAGE_FILE	EDV_NAME_IMAGES_SUBDIR \
						"/endeavour_splash.xpm"

#define EDV_NAME_TEXTTIPS_EXAMPLE_IMAGE_FILE	\
					EDV_NAME_IMAGES_SUBDIR \
						"/texttips_example.xpm"
#define EDV_NAME_TOOLTIPS_EXAMPLE_IMAGE_FILE	\
					EDV_NAME_IMAGES_SUBDIR \
						"/tooltips_example.xpm"

/*
 *	Default Device Icon Files:
 *
 *	These paths are initially set to all new device entries.
 */
#define EDV_NAME_DEF_DEVICE_ICON_SMALL_FILE	\
					EDV_PATH_DEF_GLOBAL_DATA_DIR	\
					"/" EDV_NAME_ICONS_SUBDIR	\
					"/icon_drive_fixed_20x20.xpm"
#define EDV_NAME_DEF_DEVICE_ICON_MEDIUM_FILE	\
					EDV_PATH_DEF_GLOBAL_DATA_DIR	\
					"/" EDV_NAME_ICONS_SUBDIR	\
					"/icon_drive_fixed_32x32.xpm"
#define EDV_NAME_DEF_DEVICE_ICON_LARGE_FILE	\
					EDV_PATH_DEF_GLOBAL_DATA_DIR	\
					"/" EDV_NAME_ICONS_SUBDIR	\
					"/icon_drive_fixed_48x48.xpm"

/*
 *	Default Shell Program & Arguments:
 */
#define EDV_PATH_PROG_DEF_SHELL		"/bin/sh"
#define EDV_ARGS_DEF_SHELL		"-c"


/*
 *	Default Programs & Commands:
 *
 *	All C identifiers starting with EDV_CMD_* are commands, in
 *	which arguments and token strings are allowed (see help pages
 *	in data/help/ for supported token strings).
 *
 *	All C identifiers starting with EDV_PATH_PROG_* are full
 *	paths to programs, arguments or tokens are not allowed.
 *
 *	Note that PATH_PREFIX should be used in any of these values
 *	for external programs.
 */
#define EDV_PATH_PROG_DEF_MOUNT		"/bin/mount"
#define EDV_PATH_PROG_DEF_UMOUNT	"/bin/umount"
#define EDV_PATH_PROG_DEF_EJECT		"/usr/bin/eject"

#if defined(DEBIAN)
# define EDV_CMD_DEF_VIEWER		"see"
#else
# define EDV_CMD_DEF_VIEWER		"/usr/bin/iv -q=2 -i -k \"%paths\""
#endif

#if defined(DEBIAN)
# define EDV_PATH_PROG_DEF_TERMINAL	"x-terminal-emulator"
# define EDV_CMD_DEF_TERMINAL_RUN	"x-terminal-emulator -e"
#else
# define EDV_PATH_PROG_DEF_TERMINAL	"/usr/X11R6/bin/xterm"
# define EDV_CMD_DEF_TERMINAL_RUN	"/usr/X11R6/bin/xterm -e"
#endif

#define EDV_PATH_PROG_DEF_FORMAT_FRONT	EDV_PATH_DEF_GLOBAL_LIB_DIR	\
						"/bin/format.front"
#define EDV_PATH_PROG_DEF_FSCK_FRONT	EDV_PATH_DEF_GLOBAL_LIB_DIR	\
						"/bin/fsck.front"
#define EDV_PATH_PROG_DEF_ZIPTOOL_FRONT	EDV_PATH_DEF_GLOBAL_LIB_DIR	\
						"/bin/ziptool.front"
#define EDV_PATH_PROG_DEF_DOWNLOAD_FRONT	EDV_PATH_DEF_GLOBAL_LIB_DIR	\
						"/bin/download.front"
#define EDV_PROG_DEF_MAIL_CLIENT	"/usr/bin/balsa"


/*
 *	Configuration Format Character Constants:
 */
#define EDV_CFG_COMMENT_CHAR		'#'
#define EDV_CFG_DELIMINATOR_CHAR	'='

/*
 *	Default Window Cascade Offset:
 */
#define EDV_WINDOW_CASCADE_DEF_OFFSET_X	30
#define EDV_WINDOW_CASCADE_DEF_OFFSET_Y	30


/*
 *	GtkPaned Handle & Gutter Size:
 */
#define EDV_PANED_GUTTER_SIZE		10
#define EDV_PANED_HANDLE_SIZE		10

/*
 *	GtkCTree and GtkCList Item Row Height:
 */
#define EDV_LIST_ROW_SPACING		20

/*
 *	GtkCTree and GtkCList Item Pixmap & Text Spacing:
 */
#define EDV_LIST_PIXMAP_TEXT_SPACING	2


/*
 *	Progress Bar Ticks:
 */
#define EDV_PROGRESS_BAR_NTICKS		25

/*
 * 	Progress Bar Path Maximum Characters:
 *
 *	This is the maximum number of characters a path displayed on the
 *	progress dialog can be. It should not be too long, so that it
 *	can be shortened to fit on the entire progress dialog.
 */
#define EDV_PROGRESS_DLG_PATH_MAX_CHARS	45

/*
 *	Progress Dialog Animation Interval & Increments:
 */
#define EDV_PROGRESS_DLG_ANIM_INT	500l
#define EDV_PROGRESS_DLG_ANIM_INC	((guint16)10000)


/*
 *	Default Maximum Windows:
 *
 *	(-1 = No maximum)
 */
#define EDV_DEF_MAX_FILE_BROWSERS	100
#define EDV_DEF_MAX_IMAGE_BROWSER	100
#define EDV_DEF_MAX_ARCHIVERS		100


/*
 *	File Browser Defaults:
 */
#define EDV_FILE_BROWSER_DEF_WIDTH	800
#define EDV_FILE_BROWSER_DEF_HEIGHT	600
#define EDV_FILE_BROWSER_DEF_PANED_POSITION	\
					200


/*
 *	Image Browser Defaults:
 */
#define EDV_IMAGE_BROWSER_DEF_WIDTH	800
#define EDV_IMAGE_BROWSER_DEF_HEIGHT	600
#define EDV_IMAGE_BROWSER_DEF_PANED_POSITION	\
					330

#define EDV_IMAGE_BROWSER_DEF_THUMB_WIDTH	\
					100
#define EDV_IMAGE_BROWSER_DEF_THUMB_HEIGHT	\
					90
#define EDV_IMAGE_BROWSER_DEF_THUMB_BORDER	\
					2


/*
 *	Archiver Defaults:
 */
#define EDV_ARCHIVER_DEF_WIDTH		640
#define EDV_ARCHIVER_DEF_HEIGHT		480


/*
 *	Default Recycle Bin Geometry:
 */
#define EDV_RECYCLE_BIN_DEF_WIDTH	640
#define EDV_RECYCLE_BIN_DEF_HEIGHT	480


/*
 *	Default Find Window Geometry:
 */
#define EDV_FIND_WIN_DEF_WIDTH		640
#define EDV_FIND_WIN_DEF_HEIGHT		400


/*
 *	GdkColor initializer values:
 *
 *	These are used mostly in GtkCList cell styles.
 *
 *	The values should be formatted initialze the GdkColor structure.
 */
#define EDV_GDKCOLOR_BLACK			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_WHITE			\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(1.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_LIGHT_GREY			\
{       (gulong)0,                              \
        (gushort)(0.75f * (gushort)-1),		\
        (gushort)(0.75f * (gushort)-1),		\
        (gushort)(0.75f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_GREY			\
{       (gulong)0,                              \
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_GREY			\
{       (gulong)0,                              \
        (gushort)(0.25f * (gushort)-1),		\
        (gushort)(0.25f * (gushort)-1),		\
        (gushort)(0.25f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_RED			\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_RED			\
{	(gulong)0,				\
	(gushort)(0.5f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_ORANGE			\
{       (gulong)0,				\
        (gushort)(1.0f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_ORANGE		\
{       (gulong)0,				\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.25f * (gushort)-1),		\
        (gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_YELLOW                     \
{       (gulong)0,                              \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_MEDIUM_YELLOW		\
{	(gulong)0,				\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_YELLOW                \
{       (gulong)0,                              \
        (gushort)(0.5f * (gushort)-1),          \
        (gushort)(0.5f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_GREEN			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_MEDIUM_GREEN		\
{	(gulong)0,				\
	(gushort)(0.0f * (gushort)-1),		\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_GREEN			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.5f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_CYAN			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),		\
        (gushort)(1.0f * (gushort)-1),		\
        (gushort)(1.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_CYAN			\
{       (gulong)0,				\
        (gushort)(0.0f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
}
#define EDV_GDKCOLOR_BLUE			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_DARK_BLUE			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.5f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_PURPLE			\
{       (gulong)0,                              \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_DARK_PURPLE		\
{       (gulong)0,				\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.0f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_NO_ACCESS_FG	EDV_GDKCOLOR_RED
#define EDV_GDKCOLOR_NO_ACCESS_FG_SELECTED	EDV_GDKCOLOR_RED
#define EDV_GDKCOLOR_NO_ACCESS_FG_INSENSITIVE	\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(0.5f * (gushort)-1),		\
	(gushort)(0.5f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_DANGLING_LINK_FG	EDV_GDKCOLOR_GREY
#define EDV_GDKCOLOR_DANGLING_LINK_FG_SELECTED	EDV_GDKCOLOR_LIGHT_GREY
#define EDV_GDKCOLOR_DANGLING_LINK_FG_INSENSITIVE	EDV_GDKCOLOR_LIGHT_GREY

#define EDV_GDKCOLOR_RECURSIVE_LINK_FG	EDV_GDKCOLOR_ORANGE
#define EDV_GDKCOLOR_RECURSIVE_LINK_FG_SELECTED	EDV_GDKCOLOR_ORANGE
#define EDV_GDKCOLOR_RECURSIVE_LINK_FG_INSENSITIVE	\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.25f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_HIDDEN_OBJECT_FG	EDV_GDKCOLOR_LIGHT_GREY
#define EDV_GDKCOLOR_HIDDEN_OBJECT_FG_SELECTED	EDV_GDKCOLOR_WHITE
#define EDV_GDKCOLOR_HIDDEN_OBJECT_FG_INSENSITIVE	EDV_GDKCOLOR_LIGHT_GREY

#define EDV_GDKCOLOR_EXECUTABLE_FG	EDV_GDKCOLOR_MEDIUM_GREEN
#define EDV_GDKCOLOR_EXECUTABLE_FG_SELECTED	EDV_GDKCOLOR_GREEN
#define EDV_GDKCOLOR_EXECUTABLE_FG_INSENSITIVE	EDV_GDKCOLOR_LIGHT_GREY


/*
 *	WM Class Window Names:
 */
#define EDV_FILE_BROWSER_WM_CLASS_WINDOW_NAME	\
					"FileBrowser"
#define EDV_IMAGE_BROWSER_WM_CLASS_WINDOW_NAME	\
					"ImageBrowser"
#define EDV_PRESENTATION_MODE_WM_CLASS_WINDOW_NAME	\
					"PresentationMode"
#define EDV_ARCHIVER_WM_CLASS_WINDOW_NAME	\
					"Archiver"
#define EDV_RECYCLE_BIN_WM_CLASS_WINDOW_NAME	\
					"RecycleBin"

#define EDV_DEVICES_LIST_WM_CLASS_WINDOW_NAME	\
					"DevicesList"
#define EDV_MIME_TYPES_LIST_WM_CLASS_WINDOW_NAME	\
					"MIMETypesList"
#define EDV_PROP_DLG_WM_CLASS_WINDOW_NAME	\
					"PropertiesDialog"

#define EDV_OPTIONS_WM_CLASS_WINDOW_NAME	\
					"Options"
/* Customize Window also uses EDV_OPTIONS_WM_CLASS_WINDOW_NAME */

#define EDV_FIND_WM_CLASS_WINDOW_NAME	"Find"
#define EDV_HISTORY_WM_CLASS_WINDOW_NAME	\
					"History"


/*
 *	GtkWidget Names:
 */
#define EDV_WIDGET_NAME_MENU_BAR	"menu-bar"
#define EDV_WIDGET_NAME_TOOL_BAR	"tool-bar"
#define EDV_WIDGET_NAME_LOCATION_BAR	"location-bar"
#define EDV_WIDGET_NAME_FIND_BAR	"find-bar"
#define EDV_WIDGET_NAME_MOUNT_BAR	"mount-bar"
#define EDV_WIDGET_NAME_STATUS_BAR	"status-bar"

#define EDV_WIDGET_NAME_FILE_BROWSER_TOPLEVEL	\
					"edv-file-browser"
#define EDV_WIDGET_NAME_FILE_BROWSER_DIRECTORY_TREE	\
					"directory-tree"
#define EDV_WIDGET_NAME_FILE_BROWSER_CONTENTS_LIST	\
					"contents-list"

#define EDV_WIDGET_NAME_IMAGE_BROWSER_TOPLEVEL	\
					"edv-image-browser"
#define EDV_WIDGET_NAME_IMAGE_BROWSER_THUMBS_LIST	\
					"thumbs-list"
#define EDV_WIDGET_NAME_IMAGE_BROWSER_IMAGE_VIEWER	\
					"image-viewer"

#define EDV_WIDGET_NAME_ARCHIVER_TOPLEVEL	\
					"edv-archiver"
#define EDV_WIDGET_NAME_ARCHIVER_CONTENTS_LIST	"contents-list"

#define EDV_WIDGET_NAME_RECYCLE_BIN_TOPLEVEL	\
					"edv-recycle-bin"
#define EDV_WIDGET_NAME_RECYCLE_BIN_CONTENTS_LIST	\
					"contents-list"


/*
 *	Drag & Drop Target Type Names & Info Values:
 */
#define EDV_DND_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define EDV_DND_INFO_TEXT_URI_LIST	1	/* "text/uri-list" */
#define EDV_DND_INFO_STRING		2	/* "STRING" */

#define EDV_DND_INFO_MIME_TYPE		3
#define EDV_DND_TARGET_MIME_TYPE	"Endeavour2/MimeType"
#define EDV_DND_INFO_MIME_TYPE_COMMAND	4
#define EDV_DND_TARGET_MIME_TYPE_COMMAND	\
					"Endeavour2/MimeType/Command"
#define EDV_DND_INFO_DEVICE		5
#define EDV_DND_TARGET_DEVICE		"Endeavour2/Device"

#define EDV_DND_INFO_RECYCLED_OBJECT	6
#define EDV_DND_TARGET_RECYCLED_OBJECT	"Endeavour2/RecycledObject"

#define EDV_DND_INFO_ARCHIVE_OBJECT	7
#define EDV_DND_TARGET_ARCHIVE_OBJECT	"Endeavour2/ArchiveObject"


/*
 *	List of VFS object paths (all full paths) that may never be
 *	deleted by this program.
 *
 *	Each entry consists of three pointers, the first is a gchar *
 *	to the full path of the VFS object, the second is a gchar * to
 *	an error message string that should be displayed if the object
 *	was attempted to be deleted, and the third is a gint to
 *	indicate an error level code from 0 to 2.
 *
 *	Error level code 0 means can delete and only print warning.
 *	Error level code 1 means can delete and ask user for confirmation.
 *	Error level code 2 means can never be deleted.
 *
 *	The last entry is a set of three NULL pointers.
 *
 *	In addition the user's home directory, endeavour local data 
 *	directory, and recycled objects directory objects may not be 
 *	deleted.
 */
#define EDV_NO_DELETE_LIST	{				\
{ "/",		"Virtual File System (VFS) toplevel directory", 2 },	\
{ "/bin",	"System programs directory", 1 },		\
{ "/etc",	"System configuration directory", 1 },		\
{ "/lib",	"System library directory", 1 },		\
{ "/sbin",	"System server programs directory", 1 },	\
{ "/tmp",	"System temporary files directory", 1 },	\
{ "/home",	"Home directories for users", 1 },		\
{ "/usr",	"System user directory", 1 },			\
{ "/var",	"System runtime files directory", 1 },		\
{ NULL,		NULL, 0 }					\
}

/*
 *	Stdout Help Message:
 */
#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_HELP_MESG	"\
El uso: endeavour2 [path] [options] [GUI_options]\n\
\n\
    [path] especifica el sendero a una ubicacin alterna del startup.\n\
\n\
    [options] puede ser cualquiera del siguiente:\n\
\n\
        --config <path>         Cargue configuracin de <path>.\n\
        --rcfile                Mismo que --config.\n\
        -f                      Mismo que --config.\n\
        --no-splash             No muestre splash en el comienzo.\n\
        --no-stdout-dialog      No muestre stdout los mensajes en un\n\
                                dia'logo.\n\
        --no-stderr-dialog      No muestre stderr los mensajes en un\n\
                                dia'logo.\n\
        --file-browser          Arranque con el File Browser.\n\
        --image-browser         Arranque con el Image Browser.\n\
        --archiver              Arranque con el Archiver.\n\
        --recycle-bin           Arranque con el Recycle Bin.\n\
        --properties            Arranque con el Properties Dialog.\n\
        --options               Arranque con el Options Window.\n\
        --customize             Arranque con el Customize Window.\n\
        --devices               Arranque con el Devices List.\n\
        --mimetypes             Arranque con el MIME Types List.\n\
        --run-dialog            Arranque con el Run Dialog.\n\
        --find                  Arranque con el Find Window.\n\
        --about-dialog          Arranque con el About Dialog.\n\
        --help                  La pantalla de la ayuda de impresiones\n\
                                (esto) y salidas.\n\
        --version               La informacin de la versin de\n\
                                impresiones y salidas.\n\
\n\
    LA MAYORIA de LOS customizations se pueden realizar en el customize\n\
    y opciones ventanas, ven men de Colocaciones.\n\
\n\
    las opciones de la linea de la Orden hacen caso omiso cualquier\n\
    opcin en la configuracin el archivo.\n\
\n\
    [GUI_options] puede ser cualquier estndar de las opcin a su GUI,\n\
    consulta su manual de GUI para opciones disponibles.\n\
\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_HELP_MESG  "\
Usage: endeavour2 [path] [options] [GUI_options]\n\
\n\
    [path] spcifie le sentier  un emplacement de dmarrage.\n\
\n\
    [options] peut tre n'importe quel du suivre:\n\
\n\
        --config <path>         Charger la configuration de <path>.\n\
        --rcfile                Mme comme --config.\n\
        -f                      Mme comme --config.\n\
        --no-splash             Pas splash de spectacle sur le de'but.\n\
        --no-stdout-dialog      Pas les messages de stdout de spectacle\n\
                                dans un dialogue.\n\
        --no-stderr-dialog      Pas les messages de stderr de spectacle\n\
                                dans un dialogue.\n\
        --file-browser          Le dmarrage avec le File Browser.\n\
        --image-browser         Le dmarrage avec le Image Browser.\n\
        --archiver              Le dmarrage avec le Archiver.\n\
        --recycle-bin           Le dmarrage avec le Recycle Bin.\n\
        --properties            Le dmarrage avec le Properties Dialog.\n\
        --options               Le dmarrage avec le Options Window.\n\
        --customize             Le dmarrage avec le Customize Window.\n\
        --devices               Le dmarrage avec le Devices List.\n\
        --mimetypes             Le dmarrage avec le MIME Types List.\n\
        --run-dialog            Le dmarrage avec le Run Dialog.\n\
        --find                  Le dmarrage avec le Find Window.\n\
        --about-dialog          Le dmarrage avec le About Dialog.\n\
        --help                  Caractres (ceci) aide cran et sorties.\n\
        --version               Caractres information de version et\n\
                                sorties.\n\
\n\
    La plupart des customizations peut tre excut dans le personnalise\n\
    de le et les fentres d'options, voir du menu de Montages.\n\
\n\
    Les options de ligne d'ordre annulent n'importe quelles options dans le\n\
    fichier de configuration.\n\
\n\
    [GUI_options] peut tre n'importe quelle norme d'options\n\
     votre GUI, consulter le manuel de votre GUI pour les options\n\
    disponibles.\n\
\n"
#else	/* PROG_LANGUAGE_ENGLISH */
#define PROG_HELP_MESG  "\
Usage: endeavour2 [path] [extra] [options] [GUI_options]\n\
       endeavour2 --file-browser [path] [tree_origin] [options] [GUI_options]\n\
       endeavour2 --image-browser [path] [options] [GUI_options]\n\
       endeavour2 --archiver [path] [password] [options] [GUI_options]\n\
       endeavour2 --recycle-bin [options] [GUI_options]\n\
\n\
    The [path] specifies the path of the startup location.\n\
\n\
    The [extra] specifies the supplimentary argument based on the\n\
    window that was specified at startup (such as a page, password,\n\
    tree_origin, or subsection).\n\
\n\
    The [options] can be any of the following:\n\
\n\
        --config <path>         Open the configuration from <path>.\n\
        --rcfile                Same as --config.\n\
        -f                      Same as --config.\n\
\n\
        --no-splash             Do not show splash on startup.\n\
        --no-stdout-dialog      Do not show stdout messages in a dialog.\n\
        --no-stderr-dialog      Do not show stderr messages in a dialog.\n\
\n\
        --file-browser          Start up with the File Browser.\n\
        --image-browser         Start up with the Image Browser.\n\
        --archiver              Start up with the Archiver.\n\
        --recycle-bin           Start up with the Recycle Bin.\n\
        --properties            Start up with the Properties Dialog.\n\
        --options               Start up with the Options Window.\n\
        --customize             Start up with the Customize Window.\n\
        --devices               Start up with the Devices List.\n\
        --mimetypes             Start up with the MIME Types List.\n\
        --run                   Start up with the Run Dialog.\n\
        --find                  Start up with the Find Window.\n\
        --about                 Start up with the About Dialog.\n\
\n\
        --safe-mode             Run in \"safe mode\".\n\
        --safe                  Same as --safe-mode.\n\
\n\
        --help                  Prints this help screen and exits.\n\
        --version               Prints the version information and exits.\n\
\n\
    The [GUI_options] can be any of the following\n\
\n\
        --geometry <WxH+X+Y>    Specifies the geometry of the main windows.\n\
        --font <font>           Specifies the font to be used for the lists.\n\
        --fg <color>            Specifies the foreground color for the lists.\n\
        --bg <color>            Specifies the background color for the lists.\n\
        --sfg <color>           Specifies the selected foreground color for\n\
                                the lists.\n\
        --sbg <color>           Specifies the selected background color for\n\
                                the lists.\n\
        --cfg <color>           Specifies the pointer cursor's foreground\n\
                                color.\n\
        --cbg <color>           Specifies the pointer cursor's background\n\
                                color.\n\
        --bg-pixmap <path>      Specifies the background pixmap for the lists.\n\
        --sbg-pixmap <path>     Specifies the selected background pixmap for\n\
                                the lists.\n\
        --name <name>           Specifies the WM window name.\n\
        --class <class>         Specifies the WM class name.\n\
        --title <title>         Specifies the title string to be displayed\n\
                                on the title bars of all major windows.\n\
\n\
    Most customizations can be performed in the Customize and Options\n\
    windows (under the Settings menu).\n\
\n\
    Command line options override any options in the configuration file.\n\
\n"
#endif


#endif	/* CONFIG_H */
