/*
			 Console Message System

	Redirects and displays stdout and stderr messages in a dialog
	that pops up when they are printed.

	There are options to redirect only stdout or stderr messages
	and to specify the size of the dialog and the font used.

	The user will have the option of "No More Messages" when the
	dialog pops up to never display messages any more.
 */

#ifndef CON_MSG_H
#define CON_MSG_H

#include <glib.h>


#define CON_MSG_STDOUT_TOPLEVEL_WIDGET_NAME	\
					"con-msg-stdout"
#define CON_MSG_STDERR_TOPLEVEL_WIDGET_NAME	\
					"con-msg-stderr"
#define CON_MSG_MESSAGES_WIDGET_NAME	"messages-text"


extern gint ConMsgInit(
	const gchar *name,			/* Program name */
	const gchar *font_name,
	const gint columns,			/* Can be 0 to indicate use
						 * value from $COLUMNS */
	const gint lines,			/* Can be 0 to indicate use
						 * value from $LINES */
	const gboolean show_stdout,
	const gboolean show_stderr
);
extern gint ConMsgReset(
	const gchar *name,			/* Program name */
	const gchar *font_name,
	const gint columns,			/* Can be 0 to indicate use
						 * value from $COLUMNS */
	const gint lines,			/* Can be 0 to indicate use
						 * value from $LINES */
	const gboolean show_stdout,
	const gboolean show_stderr
);
extern const gchar *ConMsgGetName(void);
extern const gchar *ConMsgGetFontName(void);
extern gint ConMsgGetColumns(void);
extern gint ConMsgGetLines(void);
extern gboolean ConMsgGetShowStdOut(void);
extern gboolean ConMsgGetShowStdErr(void);
extern void ConMsgShutdown(void);
extern void ConMsgShutdown(void);

extern void ConMsgStdOutDlgSendMessage(const gchar *msg);
extern void ConMsgStdErrDlgSendMessage(const gchar *msg);
extern void ConMsgStdOutDlgMap(void);
extern void ConMsgStdErrDlgMap(void);


#endif	/* CON_MSG_H */
