#ifndef CFG_WIN_OP_H
#define CFG_WIN_OP_H

#include <gtk/gtk.h>
#include "cfg_win.h"


typedef struct _CfgWin			CfgWin;
#define CFG_WIN(p)			((CfgWin *)(p))
#define CFG_WIN_KEY			"CfgWin"

/* CfgWinLink type is public, see cfg_win.h */
#define CFG_WIN_LINK_WIDGET_KEY		"CfgWin/Link"

typedef struct _CfgWinPage		CfgWinPage;
#define CFG_WIN_PAGE(p)			((CfgWinPage *)(p))
#define CFG_WIN_PAGE_KEY		"CfgWin/Page"


/*
 *	CfgWinLink Flags:
 */
typedef enum {
	CFG_WIN_LINK_WIDGET_HAS_CHANGES	= (1 << 0),
	CFG_WIN_LINK_IGNORE_CHANGES	= (1 << 1)	/* Changes to the
							 * widget's value will
							 * be ignored and no
							 * "changed" signal
							 * emitted */
} CfgWinLinkFlags;


/*
 *	Link:
 *
 *	Links a GtkWidget or other widget with a CfgItem, allowing
 *	their values to be exchanged between the two and also to
 *	detect changes in the GtkWidget's or other widget's value and
 *	notify about the change using signal callbacks.
 */
struct _CfgWinLink {

	CfgWinLinkWidgetType	type;		/* Determines the type of w */
	CfgWinLinkFlags	flags;
	CfgWin		*cfg_win;	/* CfgWin that the widget is on */
	CfgWinPage	*page;		/* CfgWinPage that the widget is on */

	gpointer	w;		/* GtkWidget or other widget */
	gchar		*cfg_parm;	/* CfgItem's parameter, used to
					 * reference the CfgItem */

	gpointer	data;		/* Type-specific data (not user data) */

	/* GList of CfgCallback * signal callbacks */
	GList		*cbs_list;

};


/*
 *	CfgWinPage Flags:
 */
typedef enum {
	CFG_WIN_PAGE_IS_PARENT		= (1 << 0)	/* Can hold child
							 * pages */
} CfgWinPageFlags;


/*
 *	Page:
 *
 *	Used to parent, organize, and categornize widgets on the
 *	CfgWin.
 */
struct _CfgWinPage {

	GtkWidget	*toplevel;		/* GtkVBox */
	CfgWinPageFlags	flags;
	CfgWin		*cfg_win;		/* CfgWin that this page is on */

	CfgWinPage	*parent_page;		/* NULL if toplevel */
	GList		*child_pages_list;	/* GList of CfgWinPage * child
						 * pages */

	gint		page_num;		/* This page's index relative
						 * to its siblings (aka birth
						 * order) */

	gchar		*label;			/* Name of this page, also
						 * displayed on the notebook
						 * tab or category item */

	GtkWidget	*notebook;		/* GtkNotebook, only if the
						 * style is CFG_WIN_STYLE_NOTEBOOK
						 * and CFG_WIN_PAGE_IS_PARENT
						 * is set */

	GtkCTreeNode	*ctree_node;		/* GtkCTree that represents
						 * this page, only if the
						 * style is
						 * CFG_WIN_STYLE_TREE */

	GList		*links_list;		/* GList of CfgWinLink * links */

};


/*
 *	CfgWin Flags:
 */
typedef enum {
	CFG_WIN_REALIZED		= (1 << 1),
	CFG_WIN_HAS_CHANGES		= (1 << 8)
} CfgWinFlags;


/*
 *	Configuration Window:
 */
struct _CfgWin {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gint            freeze_count,
			ref_count,
			busy_count;
	CfgWinFlags	flags;

	CfgWinStyle	style;

	gchar		*title;
	guint8		**icon_data;

	CfgWinButtons	buttons;

	GdkCursor	*busy_cur;

	GtkWidget	*main_vbox,
			*toplevel_notebook,	/* CFG_WIN_STYLE_NOTEBOOK only */
			*categories_ctree,	/* CFG_WIN_STYLE_TREE only */
			*pages_toplevel,	/* CFG_WIN_STYLE_TREE only */
			*ok_btn,
			*apply_btn,
			*save_btn,
			*cancel_btn,
			*close_btn;

	/* Configuration List */
	CfgList		*cfg_list;		/* Shared */

	/* Configuration File */
	gchar		*cfg_path;

	/* GList of CfgWinPage * toplevel pages */
	GList		*toplevel_pages_list;

	/* Current displayed page */
	CfgWinPage	*current_page;

	/* Page Changed Callback */
        void		(*page_changed_cb)(
                GtkWidget *,			/* CfgWin */
                GtkWidget *,			/* CfgWinPage */
                gpointer			/* Data */
        );
        gpointer	page_changed_data;

	/* Apply Callback */
	void		(*apply_cb)(
		GtkWidget *,			/* CfgWin */
		CfgList *,			/* CfgList */
		gpointer			/* Data */
	);
	gpointer	apply_data;
};


/*
 *	Sets the widget's value from its corresponding CfgItem's
 *	value.
 */
extern void CfgWinSetCfgWinLinkValueFromCfgItemValue(
	CfgWin *cfg_win,
	CfgWinLink *cfg_link
);


/*
 *	Sets the CfgItem's value from its corresponding widget's
 *	value.
 */
extern void CfgWinSetCfgItemValueFromCfgWinLinkValue(
	CfgWin *cfg_win,
	CfgWinLink *cfg_link
);


#endif	/* CFG_WIN_OP_H */
