/*
			 Configuration Window

	Generic configuration window with integrated support for
	exchanging data between configuration items and GtkWidgets
	using CfgItems and CfgLists.

	The configuration window is called CfgWin and is used and
	referenced as a GtkWidget/GtkWindow. It features two styles
	and tree-like pages called CfgWinPage which can be used
	and referenced as a GtkWidget/GtkContainer/GtkBox. The
	CfgWinPage conviently parent and organize GtkWidgets that
	you put on them.

	The CfgWin references CfgItems on a CfgList that you set
	using links called CfgWinLink which references a GtkWidget
	or other widget with a CfgItem. The CfgWinLinks conviently
	transfer/convert the CfgItem and GtkWidget values between
	each other.

 */

#ifndef CFG_WIN_H
#define CFG_WIN_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "guiutils.h"


typedef struct _CfgWinLink		CfgWinLink;
#define CFG_WIN_LINK(p)			((CfgWinLink *)(p))


/*
 *	CfgWinLink Widget Types:
 */
typedef enum {

	CFG_WIN_LINK_WIDGET_UNKNOWN,

	/* GtkWidgets */
	CFG_WIN_LINK_WIDGET_DRAWING_AREA,
	CFG_WIN_LINK_WIDGET_BUTTON,
	CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
	CFG_WIN_LINK_WIDGET_RADIO_BUTTON,
	CFG_WIN_LINK_WIDGET_RANGE,
	CFG_WIN_LINK_WIDGET_EDITABLE,
	CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
	CFG_WIN_LINK_WIDGET_COMBO,
	CFG_WIN_LINK_WIDGET_CLIST,

	/* Proprietery */
	CFG_WIN_LINK_WIDGET_COLOR_BUTTON,
	CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
	CFG_WIN_LINK_WIDGET_STYLE_EDIT,
	CFG_WIN_LINK_WIDGET_STACK_LIST,
	CFG_WIN_LINK_WIDGET_KEYMAP_LIST,
	CFG_WIN_LINK_WIDGET_MENUCFG_LIST

} CfgWinLinkWidgetType;


/*
 *	Configuration Window Styles:
 */
typedef enum {
	CFG_WIN_STYLE_NOTEBOOK,			/* Uses GtkNotebooks to
						 * organize pages */
	CFG_WIN_STYLE_TREE			/* Uses a GtkCTree to
						 * categorize pages */
} CfgWinStyle;


/*
 *	CfgWin Buttons:
 */
typedef enum {
	CFG_WIN_BUTTON_OK		= (1 << 0),
	CFG_WIN_BUTTON_APPLY		= (1 << 1),
	CFG_WIN_BUTTON_SAVE		= (1 << 2),
	CFG_WIN_BUTTON_CANCEL		= (1 << 3),
	CFG_WIN_BUTTON_CLOSE		= (1 << 4)
} CfgWinButtons;


/* CfgWinLink Get/Set */
extern CfgItemType CfgWinLinkGetType(CfgWinLink *cfg_link);
extern const gchar *CfgWinLinkGetParameter(CfgWinLink *cfg_link);
extern gpointer CfgWinLinkGetWidget(CfgWinLink *cfg_link);
extern GtkWidget *CfgWinLinkGetParentPage(CfgWinLink *cfg_link);
extern GtkWidget *CfgWinLinkGetCfgWin(CfgWinLink *cfg_link);

extern void CfgWinLinkSetIgnoreChanges(
	CfgWinLink *cfg_link,
	const gboolean ignore_changes
);

extern void CfgWinLinkSetData(
	CfgWinLink *cfg_link,
	gpointer data
);
extern gpointer CfgWinLinkGetData(CfgWinLink *cfg_link);

/* CfgWinLink Signal Callbacks */
extern guint CfgWinLinkSignalConnect(
	CfgWinLink *cfg_link,
	const gchar *signal_name,
	void (*cb)(
		CfgWinLink *,
		gpointer
	),
	gpointer data
);
extern guint CfgWinLinkSignalConnectAfter(
	CfgWinLink *cfg_link,
	const gchar *signal_name,
	void (*cb)(
		CfgWinLink *,
		gpointer
	),
	gpointer data
);
extern void CfgWinLinkEmitSignalByName(
	CfgWinLink *cfg_link,
	const gchar *signal_name
);
extern void CfgWinLinkEmitSignalByName(
	CfgWinLink *cfg_link,
	const gchar *signal_name
);

/* CfgWinLink Add/Set/Get/Remove */
extern CfgWinLink *CfgWinAddLink(
	GtkWidget *w,
	GtkWidget *page,
	const CfgWinLinkWidgetType type,
	gpointer widget,
	const gchar *cfg_parm
);
extern CfgWinLink *CfgWinGetCfgWinLinkByParameter(
	GtkWidget *w,
	const gchar *cfg_parm
);
extern void CfgWinRemoveLink(
	GtkWidget *w,
	CfgWinLink *cfg_link
);


/* CfgWinPage Get/Set */
extern GtkWidget *CfgWinPageGetParentPage(GtkWidget *page);
extern GtkWidget *CfgWinPageGetChild(GtkWidget *page);
extern GtkWidget *CfgWinPageGetSibling(GtkWidget *page);
extern const gchar *CfgWinPageGetLabel(GtkWidget *page);
extern gint CfgWinPageGetIndex(GtkWidget *page);

/* CfgWinPage Add/Remove */
extern GtkWidget *CfgWinAddPageNotebook(
	GtkWidget *w,
	GtkWidget *parent_page,
	const gint insert_pos,
	const gchar *label,
	GtkWidget *tab_label_widget,
	const gboolean is_parent
);
extern GtkWidget *CfgWinAddPageTree(
	GtkWidget *w,
	GtkWidget *parent_page,
	GtkWidget *sibling_page,
	const gchar *label,
	GdkPixmap *pixmap_closed,
	GdkBitmap *mask_closed,
	GdkPixmap *pixmap_opened,
	GdkBitmap *mask_opened,
	const gboolean create_heading,
	const gboolean is_parent
);
extern void CfgWinRemovePage(
	GtkWidget *w,
	GtkWidget *page
);

/* CfgWin Set CfgWinPage */
extern void CfgWinSetPage(
	GtkWidget *w,
	GtkWidget *page
);

/* CfgWin Get CfgWinPage */
extern GtkWidget *CfgWinGetDefaultPage(GtkWidget *w);
extern GtkWidget *CfgWinGetCurrentPage(GtkWidget *w);
extern GtkWidget *CfgWinGetPageByLabel(
	GtkWidget *w,
	GtkWidget *parent_page,
	const gchar *label,
        const gboolean recursive
);


/* CfgWin Set GtkWidget Values From CfgItem Values */
extern void CfgWinGetValues(
	GtkWidget *w,
	const gboolean show_progress
);

/* CfgWin Set CfgItem Values From GtkWidget Values */
extern void CfgWinSetValues(
	GtkWidget *w,
	const gboolean show_progress,
	const gboolean call_apply_cb,
	const gboolean save_to_disk
);

/* CfgWin */
extern GtkWidget *CfgWinNew(
	const CfgWinStyle cfgwin_style,
	const gchar *title,
	guint8 **icon_data,
        const CfgWinButtons buttons,
	const gint width, const gint height,
	CfgList *cfg_list,
	const gchar *cfg_path,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern GtkWidget *CfgWinGetOKButton(GtkWidget *w);
extern GtkWidget *CfgWinGetApplyButton(GtkWidget *w);
extern GtkWidget *CfgWinGetSaveButton(GtkWidget *w);
extern GtkWidget *CfgWinGetCancelButton(GtkWidget *w);
extern GtkWidget *CfgWinGetCloseButton(GtkWidget *w);
extern void CfgWinSetPageChangedCB(
        GtkWidget *w,
        void (*cb)(
                GtkWidget *,			/* CfgWin */
                GtkWidget *,			/* CfgWinPage */
                gpointer			/* Data */
        ),
        gpointer data
);
extern void CfgWinSetApplyCB(
	GtkWidget *w,
	void (*cb)(
		GtkWidget *,			/* CfgWin */
		CfgList *,			/* CfgList */
		gpointer			/* Data */
	),
	gpointer data
);
extern gboolean CfgWinGetHasChanges(GtkWidget *w);
extern void CfgWinSetHasChanges(
	GtkWidget *w,
	const gboolean has_changes
);
extern void CfgWinUpdateMenus(GtkWidget *w);
extern void CfgWinSetBusy(
	GtkWidget *w,
	const gboolean busy
);
extern GtkWidget *CfgWinRef(GtkWidget *w);
extern GtkWidget *CfgWinUnref(GtkWidget *w);


#endif	/* CFG_WIN_H */
