/*
                            ASCII Chart Dialog

	A dialog displaying a list of ASCII characters that allows you
	to view and select ASCII characters to insert.
 */

#ifndef ASCII_CHART_DLG_H
#define ASCII_CHART_DLG_H

#include <gtk/gtk.h>


typedef struct _ASCIIChartDlg		ASCIIChartDlg;
#define ASCII_CHART_DLG(p)		((ASCIIChartDlg *)(p))


/*
 *	ASCII Chart Dialog:
 */
struct _ASCIIChartDlg {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		freeze_count;

	GtkWidget	*main_vbox,
			*clist,
			*copy_btn,
			*insert_btn,
			*ok_btn;

	GtkWidget	*menu,
			*copy_mi,
			*insert_msep,
			*insert_mi;

	void		(*insert_cb)(
		ASCIIChartDlg *d,		/* ASCII Chart Dialog */
		const gchar c,			/* Character value */
		gpointer data			/* Data */
	);
	gpointer insert_data;

};


extern ASCIIChartDlg *ascii_chart_dlg_new(
	GtkWidget *ref_toplevel
);
extern void ascii_chart_dlg_set_insert_cb(
	ASCIIChartDlg *d,
	void (*cb)(
	    ASCIIChartDlg *d,
	    const gchar c,
	    gpointer data
	),
	gpointer data
);
extern void ascii_chart_dlg_update_display(ASCIIChartDlg *d);
extern gboolean ascii_chart_dlg_is_mapped(ASCIIChartDlg *d);
extern void ascii_chart_dlg_map(ASCIIChartDlg *d);
extern void ascii_chart_dlg_unmap(ASCIIChartDlg *d);
extern void ascii_chart_dlg_delete(ASCIIChartDlg *d);


#endif	/* ASCII_CHART_DLG_H */
