/*
       Endeavour Mark II - Archiver - Subprocess Monitoring and Handling

	Used to execute, monitor, stop, and read and process stream
	data from subprocesses.

	This is used primarly for async archive listing by executing
	a separate process to list the archive objects and send the
	data to standard output where the Archiver of the main
	process will read the stream data from using this module.
 */

#ifndef ARCHIVER_SUBPROCESS_H
#define ARCHIVER_SUBPROCESS_H

#include <gtk/gtk.h>
#include "libendeavour2-base/edv_archive_obj.h"
#include "archiver.h"


/* Subprocess */
extern EDVArchiverSubprocess *edv_archiver_subprocess_new(void);
extern void edv_archiver_subprocess_delete(EDVArchiverSubprocess *sp);

/* Start/Stop */
extern EDVArchiverSubprocess *edv_archiver_subprocess_start(
        EDVArchiver *archiver,
        const EDVArchiverOpID op,
        const gchar *command
);
extern EDVArchiverSubprocess *edv_archiver_subprocess_start_list_archive(
        EDVArchiver *archiver,
	const gchar *arch_path,
	const gchar *filter,
	const gchar *password,
        const gboolean show_progress,
        const gboolean show_comments
);
extern gint edv_archiver_subprocess_get_pid(EDVArchiverSubprocess *sp);
extern void edv_archiver_subprocess_stop(EDVArchiverSubprocess *sp);
extern gint edv_archiver_subprocess_get_stop_count(EDVArchiverSubprocess *sp);


/* Operations */
extern gint edv_archiver_subprocess_iteration(EDVArchiverSubprocess *sp);


#endif	/* ARCHIVER_SUBPROCESS_H */
