/*
             Endeavour Mark II - Archiver - Contents GtkCList
 */

#ifndef ARCHIVER_LIST_H
#define ARCHIVER_LIST_H

#include <gtk/gtk.h>
#include "libendeavour2-base/edv_vfs_obj.h"
#include "libendeavour2-base/edv_archive_obj.h"
#include "archiver.h"


/* Columns */
extern gint edv_archiver_list_get_column_index_by_type(
	EDVArchiver *archiver,
	const EDVArchiverColumnType column_type
);
extern gint edv_archiver_list_get_column_width_by_type(
	EDVArchiver *archiver,
	const EDVArchiverColumnType column_type
);
extern EDVArchiverColumnType edv_archiver_list_get_column_type_by_index(
	EDVArchiver *archiver,
	const gint column_num
);
extern void edv_archiver_list_set_column_width_by_type(
	EDVArchiver *archiver,
	const EDVArchiverColumnType column_type,
	const gint width
);
extern void edv_archiver_list_resize_column_optimul(
	EDVArchiver *archiver,
	const gint column_num
);
extern void edv_archiver_list_resize_columns_optimul(EDVArchiver *archiver);
extern void edv_archiver_list_reset_columns(EDVArchiver *archiver);

/* Finding */
extern gint edv_archiver_list_find_by_path(
	EDVArchiver *archiver,
	const gchar *path
);

/* Realize Listing */
extern void edv_archiver_list_realize_listing(EDVArchiver *archiver);

/* Get Listing */
extern gint edv_archiver_list_append(
	EDVArchiver *archiver,
	EDVArchiveObject *obj 
);
extern void edv_archiver_list_get(
	EDVArchiver *archiver,
	const gboolean passive,
	const gboolean show_progress,
	const gboolean show_comments
);
extern void edv_archiver_list_clear(EDVArchiver *archiver);

/* EDVVFSObject Callbacks */
extern void edv_archiver_list_vfs_object_added_cb(
	EDVArchiver *archiver,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_archiver_list_vfs_object_modified_cb(
	EDVArchiver *archiver,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void edv_archiver_list_vfs_object_removed_cb(
	EDVArchiver *archiver,
	const gchar *path
);

/* EDVArchiveObject Callbacks */
extern void edv_archiver_list_archive_object_added_cb(
	EDVArchiver *archiver,
	const gchar *arch_path,
	const gchar *path,
	EDVArchiveObject *obj
);
extern void edv_archiver_list_archive_object_modified_cb(
	EDVArchiver *archiver,
	const gchar *arch_path,
	const gchar *path,
	const gchar *new_path,
	EDVArchiveObject *obj
);
extern void edv_archiver_list_archive_object_removed_cb(
	EDVArchiver *archiver,
	const gchar *arch_path,
	const gchar *path
);


#endif	/* ARCHIVER_LIST_H */
