/*
               Endeavour Mark II - Archiver - Callbacks
 */

#ifndef ARCHIVER_CB_H
#define ARCHIVER_CB_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "libendeavour2-base/edv_archive_obj.h"
#include "edv_mime_type.h"
#include "archiver.h"


/* GTK+ Signal Callbacks */
extern void edv_archiver_realize_cb(GtkWidget *widget, gpointer data);
extern gint edv_archiver_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint edv_archiver_key_event_cb(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint edv_archiver_enter_notify_event_cb(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_archiver_leave_notify_event_cb(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_archiver_button_press_event_cb(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void edv_archiver_handle_child_attached_cb(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void edv_archiver_handle_child_detached_cb(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void edv_archiver_location_bar_icon_realize_cb(GtkWidget *widget, gpointer data);

extern void edv_archiver_resize_column_cb(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void edv_archiver_click_column_cb(
	GtkCList *clist, gint column, gpointer data
);
extern void edv_archiver_select_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void edv_archiver_unselect_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void edv_archiver_combo_activate_cb(GtkWidget *widget, gpointer data);

/* Menu Item Callbacks */
extern void edv_archiver_menu_item_activate_cb(GtkWidget *widget, gpointer data);
extern gint edv_archiver_menu_item_enter_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_archiver_menu_item_leave_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* Find Bar Callbacks */
extern const gchar *edv_archiver_find_bar_location_cb(
	GtkWidget *bar,
	gpointer data
);
extern void edv_archiver_find_bar_start_cb(
	GtkWidget *bar,
	gpointer data
);
extern void edv_archiver_find_bar_end_cb(
	GtkWidget *bar,
	const gint nmatches,
	gpointer data
);
extern void edv_archiver_find_bar_match_cb(
	GtkWidget *bar,
	const gchar *path,
	GList *properties_list,
	const gint line_index,
	const gchar *excerpt,
	gpointer data
);

/* Status Bar Callbacks */
extern void edv_archiver_status_message_cb(
	GtkWidget *widget,
	const gchar *message,
	gpointer data
);
extern void edv_archiver_status_progress_cb(
	GtkWidget *widget,
	const gfloat progress,
	gpointer data
);

/* Window Created/Deleted Callbacks */
extern void edv_archiver_window_created_cb(
	EDVArchiver *archiver,
	const EDVWindowType win_type,
	gpointer win
);
extern void edv_archiver_window_deleted_cb(
	EDVArchiver *archiver,
	const EDVWindowType win_type,
	gpointer win
);

/* Write Protect Changed Callback */
extern void edv_archiver_write_protect_changed_cb(
	EDVArchiver *archiver,
	const gboolean state
);

/* Delete Method Changed Callback */
extern void edv_archiver_delete_method_changed_cb(
        EDVArchiver *archiver,
        const EDVDeleteMethod delete_method
);

/* Object Callbacks */
extern void edv_archiver_object_added_cb(
	EDVArchiver *archiver,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_archiver_object_modified_cb(
	EDVArchiver *archiver,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void EDVArchiverObjectRemovedNotifyCB(
	EDVArchiver *archiver,
	const gchar *path
);

/* Archive Object Callbacks */
extern void edv_archiver_archive_object_added_cb(
	EDVArchiver *archiver,
	const gchar *arch_path,
	const gchar *path,
	EDVArchiveObject *obj
);
extern void edv_archiver_archive_object_modified_cb(
	EDVArchiver *archiver,
	const gchar *arch_path,
	const gchar *path,
	const gchar *new_path,
	EDVArchiveObject *obj
);
extern void edv_archiver_archive_object_removed_cb(
	EDVArchiver *archiver,
	const gchar *arch_path,
	const gchar *path
);

/* Recycled Object Callback */
extern void edv_archiver_recycled_object_added_cb(
	EDVArchiver *archiver,
	const guint index
);
extern void edv_archiver_recycled_object_modified_cb(
	EDVArchiver *archiver,
	const guint index
);
extern void edv_archiver_recycled_object_removed_cb(
	EDVArchiver *archiver,
	const guint index
);

/* Reconfigured Callback */
extern void edv_archiver_reconfigured_cb(EDVArchiver *archiver);

/* MIME Type Callbacks */
extern void edv_archiver_mime_type_added_cb(
	EDVArchiver *archiver,
	const gint mt_num, EDVMIMEType *mt
);
extern void edv_archiver_mime_type_modified_cb(
	EDVArchiver *archiver,
	const gint mt_num, EDVMIMEType *mt
);
extern void edv_archiver_mime_type_removed_cb(
	EDVArchiver *archiver,
	const gint mt_num
);


#endif	/* ARCHIVER_CB_H */
