/*
			Endeavour Mark II - Archiver
 */

#ifndef ARCHIVER_H
#define ARCHIVER_H

#include <stdio.h>
#include <gtk/gtk.h>
#include "cfg.h"
#include "tool_bar.h"
#include "guiutils.h"
#include "edv_types.h"
#include "edv_pixmap.h"
#include "archive_comments_dlg.h"
#include "archive_statistics_dlg.h"


typedef struct _EDVArchiverOp		EDVArchiverOp;
#define EDV_ARCHIVER_OP(p)		((EDVArchiverOp *)(p))

typedef struct _EDVArchiverOpQueue	EDVArchiverOpQueue;
#define EDV_ARCHIVER_OP_QUEUE(p)	((EDVArchiverOpQueue *)(p))

typedef struct _EDVArchiverSubprocess	EDVArchiverSubprocess;
#define EDV_ARCHIVER_SUBPROCESS(p)	((EDVArchiverSubprocess *)(p))

typedef struct _EDVArchiver		EDVArchiver;
#define EDV_ARCHIVER(p)			((EDVArchiver *)(p))


/*
 *	Flags:
 */
typedef enum {
	EDV_ARCHIVER_MAPPED		= (1 << 0),
	EDV_ARCHIVER_REALIZED		= (1 << 1),
	EDV_ARCHIVER_PROCESSING		= (1 << 2),
	EDV_ARCHIVER_TOOL_BAR_MAPPED	= (1 << 4),
	EDV_ARCHIVER_LOCATION_BAR_MAPPED	\
					= (1 << 5),
	EDV_ARCHIVER_FIND_BAR_MAPPED	= (1 << 6),
	EDV_ARCHIVER_STATUS_BAR_MAPPED	= (1 << 7)
} EDVArchiverFlags;


/*
 *	Column Types:
 */
typedef enum {
	EDV_ARCHIVER_COLUMN_TYPE_INDEX,
	EDV_ARCHIVER_COLUMN_TYPE_NAME,
	EDV_ARCHIVER_COLUMN_TYPE_SIZE,
	EDV_ARCHIVER_COLUMN_TYPE_STORAGE_SIZE,
	EDV_ARCHIVER_COLUMN_TYPE_TYPE,
	EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS,
	EDV_ARCHIVER_COLUMN_TYPE_OWNER,
	EDV_ARCHIVER_COLUMN_TYPE_GROUP,
	EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS,
	EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED,
	EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED,
	EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO,
	EDV_ARCHIVER_COLUMN_TYPE_LOCATION,
	EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE,
	EDV_ARCHIVER_COLUMN_TYPE_ENCRYPTION,
	EDV_ARCHIVER_COLUMN_TYPE_COMPRESSION,
	EDV_ARCHIVER_COLUMN_TYPE_METHOD,
	EDV_ARCHIVER_COLUMN_TYPE_CRC

} EDVArchiverColumnType;
#define EDV_ARCHIVER_NCOLUMN_TYPES	\
					18


/*
 *	Operation IDs:
 */
typedef enum {

	EDV_ARCHIVER_OP_NONE		= 0,
	EDV_ARCHIVER_OP_SEPARATOR	= 10,

	EDV_ARCHIVER_OP_CLOSE		= 20,
	EDV_ARCHIVER_OP_EXIT		= 21,

	EDV_ARCHIVER_OP_SYNC_DISKS	= 30,
	EDV_ARCHIVER_OP_RUN		= 31,
	EDV_ARCHIVER_OP_RUN_TERMINAL	= 32,
	EDV_ARCHIVER_OP_WRITE_PROTECT	= 35,
	EDV_ARCHIVER_OP_DELETE_METHOD_RECYCLE	\
					= 38,
	EDV_ARCHIVER_OP_DELETE_METHOD_PURGE	\
					= 39,

	EDV_ARCHIVER_OP_NEW		= 60,
	EDV_ARCHIVER_OP_OPEN		= 61,
	EDV_ARCHIVER_OP_ADD		= 62,
	EDV_ARCHIVER_OP_EXTRACT		= 63,
	EDV_ARCHIVER_OP_EXTRACT_ALL	= 64,
	EDV_ARCHIVER_OP_DELETE		= 65,
	EDV_ARCHIVER_OP_COMMENTS	= 66,
	EDV_ARCHIVER_OP_CHECK		= 67,
	EDV_ARCHIVER_OP_FIX		= 68,
	EDV_ARCHIVER_OP_SELECT_ALL	= 70,
	EDV_ARCHIVER_OP_UNSELECT_ALL	= 71,
	EDV_ARCHIVER_OP_INVERT_SELECTION	\
					= 72,
	EDV_ARCHIVER_OP_FIND		= 73,
	EDV_ARCHIVER_OP_PROPERTIES	= 74,

	EDV_ARCHIVER_OP_HISTORY		= 77,

	EDV_ARCHIVER_OP_STOP		= 80,
	EDV_ARCHIVER_OP_REFRESH		= 85,
	EDV_ARCHIVER_OP_REFRESH_ALL	= 86,
	EDV_ARCHIVER_OP_STATISTICS	= 89,
	EDV_ARCHIVER_OP_SHOW_TOOL_BAR	= 90,
	EDV_ARCHIVER_OP_SHOW_LOCATION_BAR	\
					= 91,
	EDV_ARCHIVER_OP_SHOW_FIND_BAR	= 92,
	EDV_ARCHIVER_OP_SHOW_STATUS_BAR	= 93,

	EDV_ARCHIVER_OP_LIST_FILTER	\
					= 97,
	EDV_ARCHIVER_OP_CONTENTS_LIST_AUTO_RESIZE_COLUMNS	\
					= 98,

	EDV_ARCHIVER_OP_MIME_TYPES	= 100,

	EDV_ARCHIVER_OP_NEW_BROWSER	= 110,
	EDV_ARCHIVER_OP_NEW_IMBR	= 111,
	EDV_ARCHIVER_OP_NEW_ARCHIVER	= 112,
	EDV_ARCHIVER_OP_RECYCLE_BIN	= 113,

	EDV_ARCHIVER_OP_OPTIONS		= 150,
	EDV_ARCHIVER_OP_CUSTOMIZE	= 151,

	EDV_ARCHIVER_OP_HELP_ABOUT	= 1000,
	EDV_ARCHIVER_OP_HELP_CONTENTS	= 1001,
	EDV_ARCHIVER_OP_HELP_FILE_BROWSER	\
					= 1002,
	EDV_ARCHIVER_OP_HELP_IMAGE_BROWSER	\
					= 1003,
	EDV_ARCHIVER_OP_HELP_ARCHIVER	= 1004,
	EDV_ARCHIVER_OP_HELP_RECYCLE_BIN	\
					= 1005,
	EDV_ARCHIVER_OP_HELP_KEYS_LIST	= 1006,
	EDV_ARCHIVER_OP_HELP_COMMON_OPERATIONS	\
					= 1007

} EDVArchiverOpID;


/*
 *	Operation:
 */
struct _EDVArchiverOp {

	EDVArchiverOpID	id;
	EDVOpIDFlags	flags;
	ToolBarItemType	tb_item_type;
	EDVArchiver	*archiver;

	/* Operation callback */
	void		(*func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* EDVArchiverOpID */
		gpointer			/* EDVArchiverOp */
	);

	/* Enter and leave notify callbacks */
	void		(*enter_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* EDVArchiverOpID */
		gpointer			/* EDVArchiverOp */
	);
	void		(*leave_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* EDVArchiverOpID */
		gpointer			/* EDVArchiverOp */
	);

	gchar		*button_name,		/* Name on a button */
			*menu_name,		/* Name on a menu item */
			*tooltip;		/* Tool tip or description (one line) */

	guint		accel_key,		/* Accelerator key */
			accel_mods;		/* Accelerator key modifiers */

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

};


/*
 *	Operation Queue:
 */
struct _EDVArchiverOpQueue {
	EDVArchiver	*archiver;
	guint		idle_id;		/* GTK idle ID */
	EDVArchiverOpID	op_id;
};


/*
 *	Archiver:
 */
struct _EDVArchiver {

	GtkWidget	*toplevel;
	EDVCore		*core;
	EDVArchiverFlags	flags;
	gint		freeze_count,
			busy_count,
			passive_busy_count;

	GList		*op_ids_list,		/* GList of EDVArchiverOp * */
			*queued_ops_list;	/* GList of EDVArchiverOpQueue * */

	GtkWidget	*main_vbox,
			*menu_bar,

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,     /* GtkHBox parent for location */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,
			*location_password_entry,

			*contents_clist;	/* Contents GtkCList */

	/* GtkMenus and GtkMenuItems */
	GtkWidget	*new_mi,
			*open_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_add_mi,
			*edit_extract_mi,
			*edit_extract_all_mi,
			*edit_delete_mi,
			*comments_mi,
			*check_mi,
			*fix_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*stop_mi,
			*refresh_mi,
			*refresh_all_mi,
			*statistics_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*contents_list_filter_mi,
			*contents_list_auto_resize_columns_micheck,
			*mime_types_mi,

			*write_protect_mi,
			*delete_method_recycle_micheck,
			*delete_method_purge_micheck,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_contents_mi,
			*help_archiver_mi,
			*help_keys_list_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Tool Bar */
	GtkWidget	*tool_bar;

	/* Find Bar */
	GtkWidget	*find_bar;

	/* Status Bar */
	GtkWidget	*status_bar;

	/* Contents GtkCList Right-Click GtkMenu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_add_mi,
			*contents_clist_extract_mi,
			*contents_clist_extract_all_mi,
			*contents_clist_delete_mi,
			*contents_clist_properties_mi;

	gchar		*contents_list_filter;

	/* Last selected row on the clist, can be -1. Note that
	 * this does not include other selected rows since multiple
	 * selections are allowed */
	gint		contents_clist_selected_row;

	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not. Can be
	 * -1 to indicate undefined
	 */
	gint		last_nrecycle_bin_items;

	/* Last known write protect state, can be -1 to indicate
	 * undefined
	 */
	gint		last_write_protect_state;

	/* Icons */
        EDVPixmap	*encrypted_icon;

	/* Subprocess */
	EDVArchiverSubprocess *subprocess;

	/* Comments Dialog */
	EDVArchiveCommentsDlg	*comments_dialog;

	/* Statistics Dialog */
	EDVArchiveStatisticsDlg	*statistics_dialog;
};

#define EDV_ARCHIVER_IS_PROCESSING(p)	(((p) != NULL) ?	\
 ((p)->flags & EDV_ARCHIVER_PROCESSING) : FALSE)
#define EDV_ARCHIVER_IS_FROZEN(p)	(((p) != NULL) ?	\
 ((p)->freeze_count > 0) : FALSE)
#define EDV_ARCHIVER_IS_BUSY(p)		(((p) != NULL) ?	\
 ((p)->busy_count > 0) : FALSE)
#define EDV_ARCHIVER_IS_PASSIVE_BUSY(p)	(((p) != NULL) ?	\
 ((p)->passive_busy_count > 0) : FALSE)


/* Utilities */
extern EDVArchiverOp *edv_archiver_op_match_by_id(
	EDVArchiver *archiver,
	const EDVArchiverOpID id
);

/* Title */
extern void edv_archiver_set_title(
	EDVArchiver *archiver,
	const gchar *path
);

/* Location */
extern const gchar *edv_archiver_get_location(EDVArchiver *archiver);
extern void edv_archiver_set_location(
	EDVArchiver *archiver,
	const gchar *path,
	const gboolean record_history
);
extern void edv_archiver_location_icon_update(
	EDVArchiver *archiver,
	const gchar *path
);

/* Password */
extern const gchar *edv_archiver_get_password(EDVArchiver *archiver);
extern void edv_archiver_set_password(
	EDVArchiver *archiver,
	const gchar *password
);

/* Regenerate Style, Menus, and Tool Bar */
extern void edv_archiver_icons_regenerate(EDVArchiver *archiver);
extern void edv_archiver_accelkeys_regenerate(EDVArchiver *archiver);
extern void edv_archiver_tool_bar_regenerate(EDVArchiver *archiver);
extern void edv_archiver_list_menu_regenerate(EDVArchiver *archiver);

/* Sync Configuration */
extern void edv_archiver_sync_configuration(EDVArchiver *archiver);

/* New Archive */
extern gint edv_archiver_new_archive(
        EDVArchiver *archiver,
        const gchar *path,
        const gchar *password,
        const gboolean passive
);

/* Open Archive */
extern gint edv_archiver_open_archive(
        EDVArchiver *archiver,
        const gchar *path,
        const gchar *password,
        const gboolean passive
);

/* EDVArchiverOp */
extern GList *edv_archiver_op_ids_list_new(
	EDVArchiver *archiver
);
extern void edv_archiver_op_ids_list_delete(GList *op_ids_list);

/* Accel Keys */
extern CfgAccelkeyList *edv_archiver_accelkeys_new(void);

/* EDVArchiverOpQueue */
extern void edv_archiver_queue_op(
        EDVArchiver *archiver,
        const EDVArchiverOpID id
);

/* EDVArchiver */
extern EDVArchiver *edv_archiver_new(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern void edv_archiver_sync_data(EDVArchiver *archiver);
extern void edv_archiver_update_display(EDVArchiver *archiver);
extern void edv_archiver_set_busy(
	EDVArchiver *archiver,
	const gboolean busy
);
extern void edv_archiver_set_passive_busy(
	EDVArchiver *archiver,
	const gboolean busy
);
extern gboolean edv_archiver_is_mapped(EDVArchiver *archiver);
extern void edv_archiver_map(EDVArchiver *archiver);
extern void edv_archiver_unmap(EDVArchiver *archiver);
extern void edv_archiver_delete(EDVArchiver *archiver);


#endif	/* ARCHIVER_H */
