/*
			Archive Statistics Dialog
 */

#ifndef ARCHIVE_STATISTICS_DLG_H
#define ARCHIVE_STATISTICS_DLG_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _EDVArchiveStatisticsDlg	EDVArchiveStatisticsDlg;
#define EDV_ARCHIVE_STATISTICS_DLG(p)	((EDVArchiveStatisticsDlg *)(p))


/*
 *	Archive Statistics Dialog:
 */
struct _EDVArchiveStatisticsDlg {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		freeze_count,
			busy_count;
	EDVCore		*core;

	gchar		*arch_path;

	GdkCursor	*busy_cur;

	GtkWidget	*main_vbox,
			*icon_pm,
			*name_label,
			*location_label,
			*pie_chart,
			*ok_btn;
};


extern EDVArchiveStatisticsDlg *edv_archive_statistics_dlg_new(
	EDVCore *core,
	const gchar *arch_path,
	const gchar *password,
	GList *objs_list,
	GtkWidget *toplevel
);
extern void edv_archive_statistics_dlg_update_display(EDVArchiveStatisticsDlg *d);
extern void edv_archive_statistics_dlg_set_busy(
	EDVArchiveStatisticsDlg *d,
	const gboolean busy
);
extern gboolean edv_archive_statistics_dlg_is_mapped(EDVArchiveStatisticsDlg *d);
extern void edv_archive_statistics_dlg_map(EDVArchiveStatisticsDlg *d);
extern void edv_archive_statistics_dlg_unmap(EDVArchiveStatisticsDlg *d);
extern void edv_archive_statistics_dlg_delete(EDVArchiveStatisticsDlg *d);


#endif	/* ARCHIVE_STATISTICS_DLG_H */
