/*
                          Archive Comments Dialog
 */

#ifndef ARCHIVE_COMMENTS_DLG_H
#define ARCHIVE_COMMENTS_DLG_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _EDVArchiveCommentsDlg	EDVArchiveCommentsDlg;
#define EDV_ARCHIVE_COMMENTS_DLG(p)	((EDVArchiveCommentsDlg *)(p))


/*
 *	Archive Comments Dialog:
 */
struct _EDVArchiveCommentsDlg {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	has_changes;
	gint		freeze_count,
			busy_count;
	EDVCore		*core;

	gchar		*arch_path;

	GdkCursor	*busy_cur;

	GtkWidget	*main_vbox,
			*tool_bar,
			*comment_text,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;
};


extern EDVArchiveCommentsDlg *edv_archive_comments_dlg_new(
	EDVCore *core,
	const gchar *arch_path,
	const gchar *password,
	const gchar *comments,
	GtkWidget *toplevel
);
extern void edv_archive_comments_dlg_set_has_changes(
        EDVArchiveCommentsDlg *d,
	const gboolean has_changes
);
extern void edv_archive_comments_dlg_update_display(EDVArchiveCommentsDlg *d);
extern void edv_archive_comments_dlg_set_busy(
	EDVArchiveCommentsDlg *d,
	const gboolean busy
);
extern gboolean edv_archive_comments_dlg_is_mapped(EDVArchiveCommentsDlg *d);
extern gboolean edv_archive_comments_dlg_has_changes(EDVArchiveCommentsDlg *d);
extern void edv_archive_comments_dlg_map(EDVArchiveCommentsDlg *d);
extern void edv_archive_comments_dlg_unmap(EDVArchiveCommentsDlg *d);
extern void edv_archive_comments_dlg_delete(EDVArchiveCommentsDlg *d);


#endif	/* ARCHIVE_COMMENTS_DLG_H */
