/*
				About Dialog
 */

#ifndef ABOUT_DLG_H
#define ABOUT_DLG_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "guiutils.h"


typedef struct _AboutDlg		AboutDlg;
#define ABOUT_DLG(p)			((AboutDlg *)(p))

/*
 *	Flags:
 */
typedef enum {
	ABOUT_DLG_MAPPED			= (1 << 0),
	ABOUT_DLG_REALIZED			= (1 << 1)
} AboutDlgFlags;

/*
 *	About Dialog:
 */
struct _AboutDlg {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		freeze_count,
			busy_count;
	AboutDlgFlags	flags;
	EDVCore *core;

	GtkWidget	*main_vbox,
			*notebook,
			*credits_clist,
			*license_clist,
			*ok_btn;

};


extern AboutDlg *about_dlg_new(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern gboolean about_dlg_is_mapped(AboutDlg *d);
extern void about_dlg_map(AboutDlg *d);
extern void about_dlg_unmap(AboutDlg *d);
extern void about_dlg_delete(AboutDlg *d);


#endif	/* ABOUT_DLG_H */
