#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "../include/fio.h"

#include "cfg.h"

#include "guiutils.h"

#include "edv_types.h"
#include "libendeavour2-base/edv_utils.h"
#include "libendeavour2-base/edv_path.h"
#include "edv_list_cb.h"
#include "about_dlg.h"
#include "endeavour2.h"

#include "edv_cfg_list.h"  
#include "config.h"
#include "compiletimeinfo.h"

#include "images/icon_ok_20x20.xpm"
#include "images/icon_endeavour_48x48.xpm"


static void about_dlg_switch_page_cb(
	GtkNotebook *notebook, GtkNotebookPage *page, guint page_num,
	gpointer data
);
static void about_dlg_ok_cb(GtkWidget *widget, gpointer data);
static gint about_dlg_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);

AboutDlg *about_dlg_new(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
gboolean about_dlg_is_mapped(AboutDlg *d);
void about_dlg_map(AboutDlg *d);
void about_dlg_unmap(AboutDlg *d);
void about_dlg_delete(AboutDlg *d);


#define ABOUT_DLG_TITLE			"Untitled Program"

#define ABOUT_DLG_WIDTH			500
#define ABOUT_DLG_HEIGHT		420


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *      GtkNotebook "switch_page" signal callback.
 */
static void about_dlg_switch_page_cb(
	GtkNotebook *notebook, GtkNotebookPage *page, guint page_num,
	gpointer data
)
{
	AboutDlg *d = ABOUT_DLG(data);
	if((notebook == NULL) || (d == NULL))
	    return;

	if(d->freeze_count > 0)
	    return;

	d->freeze_count++;

	if(GTK_WIDGET(notebook) == d->notebook)
	{



	}

	d->freeze_count--;
}

/*
 *	Ok callback.
 */
static void about_dlg_ok_cb(GtkWidget *widget, gpointer data)
{
	AboutDlg *d = ABOUT_DLG(data);
	if(d == NULL)
	    return;

	about_dlg_unmap(d);
}

/*
 *	Close callback.
 */
static gint about_dlg_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	about_dlg_ok_cb(widget, data);
	return(TRUE);
}

/*
 *	Create a new About Dialog.
 */
AboutDlg *about_dlg_new(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gchar *heading[1];
	GdkFont *font;
	GdkWindow *window;
	GtkStyle *style;
	GtkAccelGroup *accelgrp;
	GtkWidget	*w,
			*parent, *parent2, *parent3, *parent4,
			*toplevel, *main_vbox;
	gpointer w_rtn1, w_rtn2;
	GtkEntry *entry;
	GtkRcStyle *rcstyle;
	GtkCList *clist;
	const CfgItem *cfg_list;
	AboutDlg *d;

	if(core == NULL)
	    return(NULL);

	cfg_list = core->cfg_list;

	/* Create the About Dialog */
	d = ABOUT_DLG(g_malloc0(sizeof(AboutDlg)));
	if(d == NULL)
	    return(NULL);

	d->toplevel = toplevel = gtk_window_new(GTK_WINDOW_DIALOG);
	d->accelgrp = accelgrp = gtk_accel_group_new();
/*
	d->freeze_count = 0;
	d->busy_count = 0;
	d->flags = 0;
 */
	d->core = core;

	d->freeze_count++;

	/* Toplevel GtkWindow */
	w = toplevel;
#ifdef PROG_NAME
	gtk_window_set_wmclass(
	    GTK_WINDOW(w), "dialog", PROG_NAME
	);
#endif
	gtk_window_set_policy(GTK_WINDOW(w), FALSE, FALSE, FALSE);
       if((geometry_flags != 0) && (geometry != NULL))
	{
	    if((geometry_flags & GDK_GEOMETRY_X) || (geometry_flags & GDK_GEOMETRY_Y))
		gtk_widget_set_uposition(w, geometry->x, geometry->y);
	}
	gtk_widget_set_usize(w, ABOUT_DLG_WIDTH, ABOUT_DLG_HEIGHT);
#ifdef PROG_NAME_FULL
	gtk_window_set_title(
	    GTK_WINDOW(w),
#if defined(PROG_LANGUAGE_SPANISH)
"Acerca De"
#elif defined(PROG_LANGUAGE_FRENCH)
"De"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ungefhr"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Circa"
#elif defined(PROG_LANGUAGE_DUTCH)
"Over"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Sobre"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Omtrent"
#elif defined(PROG_LANGUAGE_POLISH)
"O programie"
#else
"About"
#endif
	    " " PROG_NAME_FULL
	);
#endif
	gtk_widget_realize(w);
	d->flags |= ABOUT_DLG_REALIZED;
	window = w->window;
	if(window != NULL)
	{
	    GdkWindow *root = gdk_window_get_parent(window);

	    gdk_window_set_decorations(
		window,
		GDK_DECOR_BORDER | GDK_DECOR_TITLE | GDK_DECOR_MENU |
		GDK_DECOR_MINIMIZE
	    );
	    gdk_window_set_functions(
		window,
		GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
	    );
	    GUISetWMIcon(
		window,
		(guint8 **)icon_endeavour_48x48_xpm
	    );

	    if(root != NULL)
	    {
		gint rx, ry, rw, rh, rd;

		gdk_window_get_geometry(
		    root,
		    &rx, &ry,
		    &rw, &rh,
		    &rd
		);

		/* Move to the GdkWindow to the center of the desktop */
		gtk_widget_set_uposition(
		    w,
		    (rw / 2) - (w->allocation.width / 2),
		    (rh / 2) - (w->allocation.height / 2)
		);
	    }
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(about_dlg_delete_event_cb), d
	);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	style = gtk_widget_get_style(w);
	parent = w;


	/* Main GtkVBox */
	d->main_vbox = main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	/* Notebook GtkVBox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent = w;

	/* Main GtkNotebook */
	d->notebook = w = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
#if 0
	gtk_notebook_set_page(GTK_NOTEBOOK(w), 0);
#endif
	gtk_signal_connect(
	    GTK_OBJECT(w), "switch_page",
	    GTK_SIGNAL_FUNC(about_dlg_switch_page_cb), d
	);
	gtk_widget_show(w);
	parent2 = w;


	/* Credits page GtkVBox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_notebook_append_page(
	    GTK_NOTEBOOK(parent2),
	    w,
	    gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Crditos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Crdits"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kredite"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Crediti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kredieten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Crditos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kreditter"
#elif defined(PROG_LANGUAGE_POLISH)
"Autorzy"
#else
"Credits"
#endif
	    )
	);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

#if defined(EDV_NAME_ABOUT_IMAGE_FILE)
	/* About image GtkHBox */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* About image GtkFrame */
	w = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_OUT);
	gtk_widget_show(w);
	parent4 = w;

	/* About image */
	if(cfg_list != NULL)
	{
	    /* Get the path to the image */
	    const gchar *data_dir = CFGItemListGetValueS(
		cfg_list, EDV_CFG_PARM_DIR_GLOBAL
	    );
	    gchar *path = edv_paths_join(
		data_dir,
		EDV_NAME_ABOUT_IMAGE_FILE
	    );
	    if(path != NULL)
	    {
		/* Open image */
		GdkBitmap *mask;
		GdkPixmap *pixmap = GDK_PIXMAP_NEW_FROM_XPM_FILE(
		    &mask, path
		);
		if(pixmap != NULL)
		{
		    gint width, height;
		    gdk_window_get_size(pixmap, &width, &height);

		    w = gtk_pixmap_new(pixmap, mask);
		    gtk_widget_set_usize(w, width, height);
		    gtk_container_add(GTK_CONTAINER(parent4), w);
		    gtk_widget_show(w);

		    GDK_PIXMAP_UNREF(pixmap);
		    GDK_BITMAP_UNREF(mask);
		}
	    }
	    g_free(path);
	}
#endif

	/* Version banner */
#ifdef EDV_GDK_FONT_NAME_18
	font = gdk_font_load(EDV_GDK_FONT_NAME_18);
#else
#warning "EDV_GDK_FONT_NAME_18 was not defined, fonts may not display correctly"
	font = NULL;
#endif
	if(font == NULL)
	    font = GDK_FONT_REF(style->font);
	w = GUIBannerCreate(
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    " " PROG_VERSION,
	    font,
	    &style->bg[GTK_STATE_NORMAL],
	    &style->text[GTK_STATE_NORMAL],
	    &style->fg[GTK_STATE_NORMAL],
	    GTK_JUSTIFY_CENTER,
	    TRUE,				/* Expand */
	    border_minor,			/* Inside border */
	    border_minor			/* Outside border */
	);
	font = GDK_FONT_UNREF(font);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* GtkScrolledWindow for the GtkCList */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Credits GtkCList */
	heading[0] = "";
	d->credits_clist = w = gtk_clist_new_with_titles(1, heading);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(edv_clist_key_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(edv_clist_key_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(edv_clist_button_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(edv_clist_button_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(edv_clist_motion_event_cb), core
	);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_realize(w);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_column_titles_hide(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
/*	gtk_clist_set_selection_mode(clist, GTK_SELECTION_BROWSE); */
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_clist_set_column_resizeable(clist, 0, FALSE);
	gtk_clist_set_column_justification(
	    clist, 0, GTK_JUSTIFY_LEFT
	);

	rcstyle = gtk_rc_style_new();
#ifdef EDV_GDK_FONT_NAME_FIXED_12
	rcstyle->font_name = g_strdup(EDV_GDK_FONT_NAME_FIXED_12);
#else
#warning "EDV_GDK_FONT_NAME_FIXED_12 was not defined, fonts may not display correctly"
#endif
	gtk_widget_modify_style(w, rcstyle);
	GTK_RC_STYLE_UNREF(rcstyle);

	gtk_widget_show(w);

#if defined(PROG_CREDITS_LINES)
	/* Add credits to credits clist */
	if(clist->columns > 0)
	{
	    const gint ncolumns = MAX(clist->columns, 1);
	    gchar **strv = (gchar **)g_malloc(ncolumns * sizeof(gchar *));
	    const gchar *credits_lines[] = PROG_CREDITS_LINES;
	    gint i, row;

	    for(i = 0; i < ncolumns; i++)
		strv[i] = "";

	    gtk_clist_freeze(clist);
	    for(i = 0; credits_lines[i] != NULL; i++)
	    {
		strv[0] = (gchar *)credits_lines[i];
		row = gtk_clist_append(clist, strv);
		if(row < 0)
		    break;

		gtk_clist_set_selectable(clist, row, FALSE);
	    }
	    gtk_clist_thaw(clist);

	    g_free(strv);
	}
#else
#warning "PROG_CREDITS_LINES was not defined, credits will not be displayed"
#endif


	/* Copyright page GtkVBox */   
	w = gtk_vbox_new(FALSE, border_major);
	gtk_notebook_append_page(    
	    GTK_NOTEBOOK(parent2),
	    w,
	    gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Derecho De Autor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Dpose"
#elif defined(PROG_LANGUAGE_GERMAN)
"Urheberrecht"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Copyright"
#elif defined(PROG_LANGUAGE_DUTCH)
"Auteursrecht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Direitos Autorais"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Copyright"
#elif defined(PROG_LANGUAGE_POLISH)
"Prawa autorskie"
#else
"Copyright"
#endif
	    )
	);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

#if defined(PROG_COPYRIGHT)
	/* Copyright GtkHBox */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Copyright GtkLabel */
	w = gtk_label_new(PROG_COPYRIGHT);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);

	rcstyle = gtk_rc_style_new();
#ifdef EDV_GDK_FONT_NAME_8
	rcstyle->font_name = g_strdup(EDV_GDK_FONT_NAME_8);
#else
#warning "EDV_GDK_FONT_NAME_8 was not defined, fonts may not display correctly"
#endif
/*	gtk_widget_modify_style(w, rcstyle); */
	GTK_RC_STYLE_UNREF(rcstyle);

	gtk_widget_show(w);
#else
#warning "PROG_COPYRIGHT was not defined, copyright will not be displayed"
#endif

	/* GtkScrolledWindow for the GtkCList */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* License GtkCList */
	heading[0] = "";
	d->license_clist = w = gtk_clist_new_with_titles(1, heading);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(edv_clist_key_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(edv_clist_key_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(edv_clist_button_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(edv_clist_button_event_cb), core
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(edv_clist_motion_event_cb), core
	);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_column_titles_hide(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
/*	gtk_clist_set_selection_mode(clist, GTK_SELECTION_BROWSE); */
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_clist_set_column_resizeable(clist, 0, FALSE);
	gtk_clist_set_column_justification(
	    clist, 0, GTK_JUSTIFY_LEFT
	);
	gtk_container_add(GTK_CONTAINER(parent4), w);

	rcstyle = gtk_rc_style_new();
#ifdef EDV_GDK_FONT_NAME_FIXED_10
	rcstyle->font_name = g_strdup(EDV_GDK_FONT_NAME_FIXED_10);
#else
#warning "EDV_GDK_FONT_NAME_FIXED_10 was not defined, fonts may not display correctly"
#endif
	gtk_widget_modify_style(w, rcstyle);
	GTK_RC_STYLE_UNREF(rcstyle);

	gtk_widget_show(w);

#if defined(EDV_NAME_LICENSE_FILE)
	/* Read the license file and load it to the GtkCList */
	if(cfg_list != NULL)
	{
	    /* Get the path to the license file */
	    const gchar *data_dir = CFGItemListGetValueS(
		cfg_list, EDV_CFG_PARM_DIR_GLOBAL
	    );
	    gchar *path = edv_paths_join(
		data_dir,
		EDV_NAME_LICENSE_FILE
	    );
	    const gint ncolumns = MAX(clist->columns, 1);

	    /* Open the license file as a list of lines */
	    GList *lines_list = edv_open_text_file_glist(
		path,
		-1,				/* No lines limit */
		TRUE				/* Strip CRs */
	    );
	    if(lines_list != NULL)
	    {
		gint	i,
			row;
		gchar	*s,
			**strv = (gchar **)g_malloc(ncolumns * sizeof(gchar *));
		GList *glist;

		for(i = 0; i < ncolumns; i++)
		    strv[i] = "";

		/* Add lines opened from the file to the GtkCList */
		gtk_clist_freeze(clist);
		for(glist = lines_list;
		    glist != NULL;
		    glist = g_list_next(glist)
		)
		{
		    s = (gchar *)glist->data;
		    if(s == NULL)
			continue;

		    /* Append this line to the GtkCList */
		    strv[0] = s;
		    row = gtk_clist_append(
			clist,
			strv
		    );
		    if(row > -1)
		    {
			gtk_clist_set_selectable(
			    clist,
			    row,
			    FALSE
			);
		    }

		    /* Delete this line */
		    g_free(s);
		}
		gtk_clist_thaw(clist);

		/* Delete the lines list */
		g_list_free(lines_list);
	    }

	    g_free(path);
	}
#endif


	/* Version page GtkVBox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_notebook_append_page(
	    GTK_NOTEBOOK(parent2),
	    w,
	    gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    )
	);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;


	/* Main Program Information GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_NAME_FULL)
	    PROG_NAME_FULL
#elif defined(PROG_NAME)
	    PROG_NAME
#else
	    ABOUT_DLG_TITLE
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent4 = w;

	/* Version prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)w_rtn2;
	entry = GTK_ENTRY(w);
	gtk_entry_set_editable(entry, FALSE);
#if defined(PROG_VERSION)
	gtk_entry_set_text(entry, PROG_VERSION);
#endif

	/* Language prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"El Idioma"
#elif defined(PROG_LANGUAGE_FRENCH)
"Langue"
#elif defined(PROG_LANGUAGE_GERMAN)
"Sprache"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Lingua"
#elif defined(PROG_LANGUAGE_DUTCH)
"Taal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Linguagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sprk"
#elif defined(PROG_LANGUAGE_POLISH)
"Jzyk"
#else
"Language"
#endif
	    ":", &w_rtn1, &w_rtn2
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)w_rtn2;
	entry = GTK_ENTRY(w);
	gtk_entry_set_editable(entry, FALSE);
	gtk_entry_set_text(
	    entry,
#if defined(PROG_LANGUAGE_SPANISH)
"El Espaol"
#elif defined(PROG_LANGUAGE_FRENCH)
"Franais"
#elif defined(PROG_LANGUAGE_GERMAN)
"Deutsch"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Italiano"
#elif defined(PROG_LANGUAGE_DUTCH)
"Nederlands"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Portugus"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Norsk"
#elif defined(PROG_LANGUAGE_POLISH)
"Polski"
#else
"English"
#endif
	);

	/* Compile date prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Compile La Fecha"
#elif defined(PROG_LANGUAGE_FRENCH)
"Compiler La Date"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kompilieren Sie Datum"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Compilare La Data"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verzameel Datum"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Compile Data"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kompiler Date"
#elif defined(PROG_LANGUAGE_POLISH)
"Data kompilacji"
#else
"Compile Date"
#endif
	    ":", &w_rtn1, &w_rtn2
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)w_rtn2;
	entry = GTK_ENTRY(w);
	gtk_entry_set_editable(entry, FALSE);

#if defined(COMPILE_DATE)
	if(COMPILE_DATE > 0)
	{
	    time_t t = COMPILE_DATE;
	    gchar *s = STRDUP(ctime(&t));
	    if(s != NULL)
	    {
		gchar *s2 = (gchar *)strchr((char *)s, '\n');
		if(s2 != NULL)
		    *s2 = '\0';
		gtk_entry_set_text(entry, s);
		g_free(s);
	    }
	}
#endif

	/* Compiler prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"El Compilador"
#elif defined(PROG_LANGUAGE_FRENCH)
"Compilateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Compiler"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Compilatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Compilator"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Compilador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kompilator"
#elif defined(PROG_LANGUAGE_POLISH)
"Kompilator"
#else
"Compiler"
#endif
	    ":", &w_rtn1, &w_rtn2
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)w_rtn2;
	entry = GTK_ENTRY(w);
	gtk_entry_set_editable(entry, FALSE);
#if defined(COMPILE_COMPILER)
	gtk_entry_set_text(entry, COMPILE_COMPILER);
#endif

	/* Location prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Compilado En"
#elif defined(PROG_LANGUAGE_FRENCH)
"Compil A"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kompiliert An"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Compilato A"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verzamelde Aan"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Compilado Em"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kompilert At"
#elif defined(PROG_LANGUAGE_POLISH)
"Skompilowano na"
#else
"Compiled At"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)w_rtn2;
	entry = GTK_ENTRY(w);
	gtk_entry_set_editable(entry, FALSE);
#if defined(COMPILE_LOCATION)
	gtk_entry_set_text(entry, COMPILE_LOCATION);
#endif

#ifdef IMLIB_VERSION
	/* Imlib Information GtkFrame */
	w = gtk_frame_new("Imlib");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent4 = w;

	/* Version prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)w_rtn2;
	entry = GTK_ENTRY(w);
	gtk_entry_set_editable(entry, FALSE);
	gtk_entry_set_text(entry, IMLIB_VERSION);
#endif

	/* GTK+ Information GtkFrame */
	w = gtk_frame_new("GTK+");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent4 = w;

	/* Version prompt */
	w = GUIPromptBar(
	    NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#elif defined(PROG_LANGUAGE_POLISH)
"Wersja"
#else
"Version"
#endif
	    ":" , &w_rtn1, &w_rtn2
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)w_rtn2;
	entry = GTK_ENTRY(w);
	gtk_entry_set_editable(entry, FALSE);

	if((gtk_major_version != 0) || (gtk_minor_version != 0) ||
	   (gtk_micro_version != 0)
	)
	{
	    gchar *s = g_strdup_printf(
		"%i.%i.%i",
		gtk_major_version, gtk_minor_version, gtk_micro_version
	    );
	    gtk_entry_set_text(entry, s);
	    g_free(s);
	}


	parent = main_vbox;

	/* Buttons GtkHBox */
	w = gtk_hbox_new(TRUE, 0);   
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Ok button */
	d->ok_btn = w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_ok_20x20_xpm,
	    "OK",
	    NULL
	);
	GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
	gtk_widget_set_usize(
	    w,
	    GUI_BUTTON_HLABEL_WIDTH_DEF, GUI_BUTTON_HLABEL_HEIGHT_DEF
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(about_dlg_ok_cb), d
	);
	gtk_accel_group_add(
	    accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	gtk_accel_group_add(
	    accelgrp, GDK_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	GUIButtonLabelUnderline(w, GDK_o);
	gtk_widget_show(w);

	d->freeze_count--;

	return(d);
}

/*
 *	Checks if the About Dialog is mapped.
 */
gboolean about_dlg_is_mapped(AboutDlg *d)
{
	if(d == NULL)
	    return(FALSE);

	return(GTK_WIDGET_MAPPED(d->toplevel));
}

/*
 *	Map the About Dialog.
 */
void about_dlg_map(AboutDlg *d)
{
	GtkWidget *w;

	if(d == NULL)
	    return;
  
	gtk_widget_show_raise(d->toplevel);

	/* Grab focus on the OK button */
	w = d->ok_btn;
	gtk_widget_grab_focus(w);
	gtk_widget_grab_default(w);

	d->flags |= ABOUT_DLG_MAPPED;
}

/*
 *	Unmap the About Dialog.
 */
void about_dlg_unmap(AboutDlg *d)
{
	if(d == NULL)
	    return;

	gtk_widget_hide(d->toplevel);

	d->flags &= ~ABOUT_DLG_MAPPED;
}

/*
 *	Deletes the About Dialog.
 */
void about_dlg_delete(AboutDlg *d)
{
	if(d == NULL)
	    return;

	about_dlg_unmap(d);

	d->freeze_count++;

	gtk_widget_destroy(d->toplevel);
	gtk_accel_group_unref(d->accelgrp);

	d->freeze_count--;

	g_free(d);
}
