#include <stdio.h>
#include <stdlib.h>
#include <glib.h>


gulong edv_id3_length_parse(const gchar *s)
{
        gint i;
        gulong ms;
        gfloat          x,
                        v[3];

        /* Parse/get up to 3 time values from s */
        for(i = 0; i < 3; i++)
        {
                /* Seek past any spaces */
                while((*s == ' ') || (*s == '\t'))
                        s++;

                /* Get this time value as a gfloat */
                x = (gfloat)atof((const char *)s);
                v[i] = (x >= 0.0f) ? x : 0.0f;

                /* Seek s past the next ':' character or to the end
                 * of the string
                 */
                while(*s != '\0')
                {
                        if(*s == ':')
                                break;
                        s++;
                }
		/* Another value after this one? */
                if(*s == ':')
		{
			s++;
			continue;
		}
		/* No additional values? */
		if(*s == '\0')
                        break;
        }

        ms = 0l;
        switch(i)
        {
            case 2:                             /* "h:m:s[.s]" */
                ms += (gulong)(v[0] * 60.0f * 60.0f * 1000.0f);
                ms += (gulong)(v[1] * 60.0f * 1000.0f);
                ms += (gulong)(v[2] * 1000.0f);
                break;
            case 1:                             /* "m:s[.s]" */
                ms += (gulong)(v[0] * 60.0f * 1000.0f);
                ms += (gulong)(v[1] * 1000.0f);
                break;
            case 0:                             /* "s[.s]" */
                ms += (gulong)(v[0] * 1000.0f);
                break;
        }

        return(ms);
}

gchar *edv_id3_length_format(const gulong ms)
{
        /* 60 minutes or longer? */
        if(ms >= (60l * 60l * 1000l))
        {
                /* "h:m:s" */
                return(g_strdup_printf(
                        "%ld:%02ld:%04.1f",
                        ms / 1000l / 60l / 60l,
                        (ms % (60l * 60l * 1000l)) / 1000l / 60l,
                        (gfloat)(ms % (60l * 1000l)) / 1000.0f
                ));
        }
        /* 60 seconds or longer? */
        else if(ms >= (60l * 1000l))
        {
                /* "m:s" */
                return(g_strdup_printf(
                        "%02ld:%04.1f",
                        ms / 1000l / 60l,
                        (gfloat)(ms % (60l * 1000l)) / 1000.0f
                ));
        }
        /* 59 seconds or less */
        else
        {
                /* "s" */
                return(g_strdup_printf(
                        "00:%04.1f",
                        (gfloat)ms / 1000.0f
                ));
        }
}


int main(int argc, char *argv[])
{
	gulong ms;
	gchar *s;

	if(argc < 2)
		return(2);

	ms = edv_id3_length_parse(argv[1]);
	s = edv_id3_length_format(ms);
	g_print("%ldms %s\n", ms, s);
	g_free(s);

	return(0);
}
