#!/bin/sh
#
# pconf - Platform Configurator - Master Script
#
# Usage: ./configure.sh <platform> [options]
#        ./configure.sh --list
#        ./configure.sh --reset
#        ./configure.sh --help
#
# End users should not modify this file.
#


# Source Directory:
#
# This is the subdirectory that contains the source, the pconf input file
# PCONF_PLATFORMS_INI, and the pconf output files PCONF_MAKEFILE_OUTPUT
# and PCONF_THIS_PLATFORM_INI.
#
SRC_DIR=endeavour2


# Platforms Configuration File:
#
# List of all defined platforms that this program will compile on and
# platform specific values that will be used to generate the Output
# Makefile (PCONF_MAKEFILE_OUTPUT).
#
# Note that there are additional locations specified within the
# PCONF_PLATFORMS_INI file.
#
PCONF_PLATFORMS_INI=$SRC_DIR/platforms.ini


# Output Makefile:
#
# This should match the MakefileOutput parameter in the Platforms
# Configuration File (PCONF_PLATFORMS_INI).
#
PCONF_MAKEFILE_OUTPUT=$SRC_DIR/Makefile.pconf

# Output Platform Information File:
#
# Contains platform-specific information gathered by pconf when it is
# runned.
#
# This should match the ThisPlatformInfo parameter in the Platforms
# Configuration File (PCONF_PLATFORMS_INI).
#
PCONF_THIS_PLATFORM_INI=$SRC_DIR/pconf_platform_info.ini


# Platform Configurator Directory:
#
# This is the subdirectory where the Platform Configurator (pconf) source
# and its (non-user configurable) data files are located in.
#
PCONF_PREFIX=pconf

# Platform Configurator Program:
#
# This is the path to the generated pconf program.
#
PCONF=$PCONF_PREFIX/pconf


# Variables used by this script:
#
# Do not edit.
#
PCONF_NEED_COMPILE=1
PCONF_GENERATE_SUCCESS=0


#
# Operations start here, do not edit below this line
#
# #########################################################################


# Special `reset' case
if [ "$1" = "--reset" ]; then
 echo "Resetting Platform Configurator for a clean distribution..."

 # Remove generated pconf binary
 if [ -f $PCONF ]; then
  rm -f $PCONF
 fi

 # Remove this platform information file
 if [ -f $PCONF_THIS_PLATFORM_INI ]; then
  rm -f $PCONF_THIS_PLATFORM_INI
 fi

 # Remove generated pconf output Makefile
 if [ -f $PCONF_MAKEFILE_OUTPUT ]; then
  rm -f $PCONF_MAKEFILE_OUTPUT
 fi

 echo "Done"
 exit 0
fi


# Has pconf been compiled for this system?
if [ -f $PCONF ]; then
 PCONF_NEED_COMPILE=0
fi

# Need to generate (compile) pconf?
if [ $PCONF_NEED_COMPILE = "1" ]; then
 echo "Collecting information about this platform..."
 if [ -f $PCONF_THIS_PLATFORM_INI ]; then
  rm $PCONF_THIS_PLATFORM_INI
 fi
 uname -s >> $PCONF_THIS_PLATFORM_INI
 uname -r >> $PCONF_THIS_PLATFORM_INI
 uname -m >> $PCONF_THIS_PLATFORM_INI

 echo "Generating Platform Configurator and testing system's compiler..."
 cd $PCONF_PREFIX
 make clean
 make
 cd ..

 # Check if generation successful
 if [ -f $PCONF ]; then
  PCONF_GENERATE_SUCCESS=1
 fi
 if [ $PCONF_GENERATE_SUCCESS = "0" ]; then
  echo "Could not generate Platform Configurator and/or compiler not functioning,"
  echo "you may not be able to compile/build any programs on this system. Please "
  echo "review any errors encountered above and consult with vendors."
  echo " "
  exit 1
 fi
 if [ $PCONF_GENERATE_SUCCESS = "1" ]; then
  echo " "
  echo "Compiler passed all compatibility tests!"
  echo " "
 fi
fi

# Run pconf
if [ -f $PCONF ]; then
 $PCONF $PCONF_PLATFORMS_INI "$@"
 exit $?
fi
