/*
				SysInfo Window
 */

#ifndef SYSINFO_H
#define SYSINFO_H

#include <gtk/gtk.h>


/*
 *	SysInfo Display Flags:
 */
typedef enum {
	SYSINFO_DISPLAY_CPU_LOAD	= (1 << 0),
	SYSINFO_DISPLAY_CPU_LOADAVG	= (1 << 1),
	SYSINFO_DISPLAY_MEMORY		= (1 << 2),
	SYSINFO_DISPLAY_APM_POWER	= (1 << 3),
	SYSINFO_DISPLAY_CPU_DETAILS	= (1 << 4)
} sysinfo_display_flags;

/*
 *	SysInfo Bar Styles:
 */
typedef enum {
	SYSINFO_BAR_STYLE_CONTINUOUS,
	SYSINFO_BAR_STYLE_DISCRETE,
	SYSINFO_BAR_STYLE_LED
} sysinfo_bar_style;

/*
 *	SysInfo Bar Orientations:
 */
typedef enum {
	SYSINFO_BAR_ORIENTATION_HORIZONTAL,
	SYSINFO_BAR_ORIENTATION_VERTICAL
} sysinfo_bar_orientation;


/*
 *	This determines the gradiency of the colors when the bar style
 *	is set to SYSINFO_BAR_STYLE_LED (the higher the value the more
 *	gradiency).
 */
#define SYSINFO_BAR_LED_COLORS		10


/*
 *	SysInfo Window:
 */
typedef struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count;
	gpointer	core_ptr;

	gint		freeze_count;

	sysinfo_display_flags	display;
	sysinfo_bar_style	bar_style;
	sysinfo_bar_orientation	bar_orientation;

	GtkWidget	*main_box;

	GdkPixmap	*bar_pixmap;

	GdkColor	bar_led_bg_color,
			bar_led_low_color[SYSINFO_BAR_LED_COLORS],
			bar_led_mid_color[SYSINFO_BAR_LED_COLORS],
			bar_led_high_color[SYSINFO_BAR_LED_COLORS];
	GdkGC		*bar_led_gc;

	GtkWidget	*cpu_load_box,
			*cpu_load_da;
	gfloat		cpu_load_last_value;

	GtkWidget	*cpu_loadavg_box,
			*cpu_loadavg_da;
	gfloat		cpu_loadavg_last_value;

	GtkWidget	*memory_box,
			*memory_da;
	gfloat		memory_last_value;

	GtkWidget	*apm_power_box,
			*apm_power_da;
	gfloat		apm_power_last_value;

	GtkWidget	*details_box,
			*details_text;

	GtkWidget	*menu,
			*display_memory_micheck,
			*display_apm_power_micheck,
			*display_cpu_details_micheck;

} sysinfo_win_struct;
#define SYSINFO_WIN(p)	((sysinfo_win_struct *)(p))


extern sysinfo_win_struct *SysInfoNew(
	gpointer core_ptr,
	sysinfo_display_flags display,
	sysinfo_bar_style bar_style,
	sysinfo_bar_orientation bar_orientation
);
extern void SysInfoSetDisplay(
	sysinfo_win_struct *si, sysinfo_display_flags display
);
extern void SysInfoSetBarStyle(
	sysinfo_win_struct *si, sysinfo_bar_style bar_style
);
extern void SysInfoSetBarOrientation(
	sysinfo_win_struct *si, sysinfo_bar_orientation bar_orientation
);
extern void SysInfoUpdate(sysinfo_win_struct *si);
extern gboolean SysInfoIsMapped(sysinfo_win_struct *si);
extern void SysInfoMap(sysinfo_win_struct *si);
extern void SysInfoUnmap(sysinfo_win_struct *si);
extern void SysInfoDelete(sysinfo_win_struct *si);


#endif	/* SYSINFO_H */
