/*
                                 Run Dialog
 */

#ifndef RUNDLG_H
#define RUNDLG_H

#include <gtk/gtk.h>
#include "edvtypes.h"


typedef struct _edv_run_dlg_struct		edv_run_dlg_struct;


/*
 *	Run Dialog:
 */
struct _edv_run_dlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count;
	gpointer	core_ptr;

	GtkWidget	*main_vbox,
			*run_combo, *browse_btn, *clear_btn,
			*working_dir_entry, *working_dir_browse_btn,
				*working_dir_clear_btn,
				*working_dir_get_from_cmd_btn,
			*run_in_terminal_check, *keep_dialog_check,
			*options_btn,
			*run_btn,
			*close_btn;

};
#define EDV_RUN_DLG(p)	((edv_run_dlg_struct *)(p))


/* In rundlg.c */
extern void EDVRunDlgSetCommand(
	edv_run_dlg_struct *dlg, const char *command
);
extern void EDVRunDlgSetWorkingDir(
	edv_run_dlg_struct *dlg, const char *working_dir
);
extern void EDVRunDlgFetchValues(edv_run_dlg_struct *dlg);

extern edv_run_dlg_struct *EDVRunDlgNew(gpointer core_ptr);
extern void EDVRunDlgSetBusy(edv_run_dlg_struct *dlg, gboolean is_busy);
extern gboolean EDVRunDlgIsMapped(edv_run_dlg_struct *dlg);
extern void EDVRunDlgMap(edv_run_dlg_struct *dlg);
extern void EDVRunDlgUnmap(edv_run_dlg_struct *dlg);
extern void EDVRunDlgDelete(edv_run_dlg_struct *dlg);


#endif	/* RUNDLG_H */
