#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "guiutils.h"
#include "toolbar.h"

#include "cfg.h"
#include "edvtypes.h"
#include "edvlistcb.h"
#include "edvstatusbar.h"
#include "recbin.h"
#include "recbincb.h"
#include "recbinopcb.h"
#include "recbincontents.h"
#include "recbindnd.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_hsep_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_trace_20x20.xpm"
#include "images/icon_run_20x20.xpm"
#include "images/icon_terminal_20x20.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_exit_20x20.xpm"
#include "images/icon_recover_20x20.xpm"
#include "images/icon_purge_20x20.xpm"
#include "images/icon_purge_all_20x20.xpm"
#include "images/icon_select_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_mimetypes_20x20.xpm"
#include "images/icon_search_20x20.xpm"
#include "images/icon_tool_bar_20x20.xpm"
#include "images/icon_status_bar_20x20.xpm"
#include "images/icon_options2_20x20.xpm"
#include "images/icon_customize_20x20.xpm"
#include "images/icon_insecure_20x20.xpm"
#include "images/icon_secure_20x20.xpm"
#include "images/icon_help_20x20.xpm"
#include "images/icon_about_20x20.xpm"

#include "images/endeavour_20x20.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"
#include "images/icon_trash_20x20.xpm"
#include "images/icon_trash_empty_20x20.xpm"

#include "images/icon_trash_empty_48x48.xpm"
#include "images/icon_trash_48x48.xpm"


static edv_recbin_opid_struct *EDVRecBinMatchOPID(
	edv_recbin_struct *recbin, edv_recbin_op op
);

void EDVRecBinSetTitle(edv_recbin_struct *recbin);

void EDVRecBinToolbarRegenerate(edv_recbin_struct *recbin);
void EDVRecBinContentsMenuRegenerate(edv_recbin_struct *recbin);

void EDVRecBinSyncConfiguration(edv_recbin_struct *recbin);

edv_recbin_opid_struct **EDVRecBinOPIDListNew(
	edv_recbin_struct *recbin,      /* Can be NULL */
	gint *total
);
void EDVRecBinOPIDListDelete(
	edv_recbin_opid_struct **list, gint total
);

static void EDVRecBinCreateMenuBar(
	edv_recbin_struct *recbin, GtkWidget *parent
);

edv_recbin_struct *EDVRecBinNew(gpointer core_ptr);
void EDVRecBinReset(edv_recbin_struct *recbin, gboolean need_unmap);
void EDVRecBinSyncData(edv_recbin_struct *recbin);
void EDVRecBinUpdateMenus(edv_recbin_struct *recbin);
void EDVRecBinUpdateContentsHeadings(
	edv_recbin_struct *recbin,
	const gint *contents_heading, gint total_contents_headings
);
void EDVRecBinSetBusy(edv_recbin_struct *recbin, gboolean is_busy);
gboolean EDVRecBinIsMapped(edv_recbin_struct *recbin);
void EDVRecBinMap(edv_recbin_struct *recbin);
void EDVRecBinUnmap(edv_recbin_struct *recbin);
void EDVRecBinDelete(edv_recbin_struct *recbin);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Returns the Recycle Bin Operation ID that matches the given
 *	operation.
 */
static edv_recbin_opid_struct *EDVRecBinMatchOPID(
	edv_recbin_struct *recbin, edv_recbin_op op
)
{
	gint i;
	edv_recbin_opid_struct *opid;

	if(recbin == NULL)
	    return(NULL);

	for(i = 0; i < recbin->total_opids; i++)
	{
	    opid = recbin->opid[i];
	    if((opid != NULL) ? (opid->op == op) : FALSE)
		return(opid);
	}

	return(NULL);
}


/*
 *	Sets the Recycle Bin title.
 */
void EDVRecBinSetTitle(edv_recbin_struct *recbin)
{
	gboolean include_user_name;
	const gchar *prog_name = "Recycle Bin";
	gchar *title;
	GtkWidget *w;
	const cfg_item_struct *cfg_list;
	edv_core_struct *core_ptr;


	if(recbin == NULL)
	    return;

	core_ptr = EDV_CORE(recbin->core_ptr);
	if(core_ptr == NULL)
	    return;

	cfg_list = core_ptr->cfg_list;

	if(!STRISEMPTY(core_ptr->title))
	    prog_name = core_ptr->title;

	w = recbin->toplevel;
	if(w == NULL)
	    return;

	include_user_name = EDV_GET_B(EDV_CFG_PARM_RECBIN_TITLE_WITH_USER);

	/* Generate new title string */
	if(include_user_name)
	    title = g_strdup_printf(
		"%s: %s",
		prog_name, core_ptr->effective_user_id_host_str
	    );
	else
	    title = STRDUP(prog_name);

	/* Set new title */
	gtk_window_set_title(GTK_WINDOW(w), title);

	g_free(title);
}


/*
 *	Recreates the Recycle Bin's Tool Bar.
 */
void EDVRecBinToolbarRegenerate(edv_recbin_struct *recbin)
{
	gint i, total_items;
	toolbar_display tb_display;
	toolbar_relief tb_relief;
	GtkWidget *w, *parent;
	const cfg_intlist_struct *intlist;
	const cfg_item_struct *cfg_list;
	edv_recbin_opid_struct *opid;
	toolbar_struct *toolbar;
	toolbar_item_struct **item, *item_ptr;
	edv_core_struct *core_ptr;

	if(recbin == NULL)
	    return;

	parent = recbin->tool_bar_handle;
	core_ptr = EDV_CORE(recbin->core_ptr);
	if((parent == NULL) || (core_ptr == NULL))
	    return;

	cfg_list = core_ptr->cfg_list;

	/* Get Tool Bar configuration */
	tb_display = (toolbar_display)EDV_GET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
	);
	tb_relief = (toolbar_relief)EDV_GET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
	);
	intlist = EDV_GET_INTLIST(EDV_CFG_PARM_RECBIN_TOOL_BAR);
	if(intlist == NULL)
	    return;

	/* Delete existing Tool Bar if any */
	ToolBarDelete(recbin->toolbar);
	recbin->toolbar = NULL;

	/* Create Tool Bar items list */
	total_items = intlist->total;
	if(total_items > 0)
	{
	    item = (toolbar_item_struct **)g_malloc0(
		total_items * sizeof(toolbar_item_struct *)
	    );
	    if(item == NULL)
		total_items = 0;
	}
	else
	{
	    item = NULL;
	}
	for(i = 0; i < total_items; i++)
	{
	    /* Get Operation ID */
	    opid = EDVRecBinMatchOPID(recbin, intlist->i[i]);
	    if(opid == NULL)
		continue;

	    switch(opid->op)
	    {
	      case EDV_RECBIN_OP_NONE:
		item[i] = item_ptr = NULL;
		break;

	      default:
		item[i] = item_ptr = ToolBarItemNew(
		    opid->tb_item_type,
		    opid->button_name,
		    opid->button_icon_data,
		    opid->tooltip,
		    opid->op,
		    EDVRecBinOPCB, opid,
		    EDVRecBinOPEnterCB, opid,
		    EDVRecBinOPLeaveCB, opid
		);
		break;
	    }
	}

	/* Create new Tool Bar */
	recbin->toolbar = toolbar = ToolBarNew(
	    item, total_items, parent,
	    tb_display, tb_relief, FALSE
	);
	ToolBarMap(toolbar);

	/* Delete Tool Bar items list */
	ToolBarItemListDeleteAll(&item, &total_items);

	/* Need to queue resize toplevel since the Tool Bar may have
	 * changed in size
	 */
	w = recbin->toplevel;
	if(w != NULL)
	    gtk_widget_queue_resize(w);
}

/*
 *	Recreates the Recycle Bin Contents List's right click menu.
 */
void EDVRecBinContentsMenuRegenerate(edv_recbin_struct *recbin)
{
	if(recbin == NULL)
	    return;

	/* Destroy existing menu if it already exists */
	GTK_WIDGET_DESTROY(recbin->contents_clist_menu);
	recbin->contents_clist_menu = NULL;

	/* Create new menu */
	if(TRUE)
	{
	    edv_recbin_op op;
	    guint8 **icon_data = NULL;
	    GtkAccelGroup *accelgrp = NULL;
	    GtkWidget *w, *menu, **w_record, **fw_record;

#define DO_ADD_MENU_ITEM_LABEL		{	\
 edv_recbin_opid_struct *opid =			\
  EDVRecBinMatchOPID(recbin, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVRecBinMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVRecBinMenuItemEnterCB, opid,	\
   (gpointer)EDVRecBinMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_SEP		{		\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}

	    /* Create menu */
	    recbin->contents_clist_menu = menu = GUIMenuCreate();

	    op = EDV_RECBIN_OP_RECOVER;
	    w_record = &recbin->contents_clist_recover_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_PURGE;
	    w_record = &recbin->contents_clist_purge_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_PURGE_ALL;
	    w_record = &recbin->contents_clist_purge_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
	}
}


/*
 *	Sets the Recycle Bin values to the configuration.
 */
void EDVRecBinSyncConfiguration(edv_recbin_struct *recbin)
{
	GtkWidget *w;
	edv_core_struct *core_ptr;
	cfg_item_struct *cfg_list;
	

	if(recbin == NULL)
	    return;

	core_ptr = EDV_CORE(recbin->core_ptr);
	if(core_ptr == NULL)
	    return;

	cfg_list = core_ptr->cfg_list;

	/* Toplevel geometry */
	w = recbin->toplevel;
	if(w != NULL)
	{
	    GdkWindow *window = w->window;
	    gint x = 0, y = 0;

	    if(window != NULL)
		gdk_window_get_root_origin(window, &x, &y);

	    EDV_SET_I(EDV_CFG_PARM_RECBIN_X, x);
	    EDV_SET_I(EDV_CFG_PARM_RECBIN_Y, y);
	    EDV_SET_I(EDV_CFG_PARM_RECBIN_WIDTH, w->allocation.width);
	    EDV_SET_I(EDV_CFG_PARM_RECBIN_HEIGHT, w->allocation.height);
	}

	/* EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH parameter is updated
	 * as they change in EDVRecBinResizeColumnCB() or when the
	 * configuration list is changed directly
	 */

	/* EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN parameter is updated
	 * when the configuration list is changed directly
	 */
}


/*
 *	Creates a new Recycle Bin Operation IDs list.
 */
edv_recbin_opid_struct **EDVRecBinOPIDListNew(
	edv_recbin_struct *recbin,      /* Can be NULL */
	gint *total
)
{
	gint i;
	edv_recbin_op op;
	gboolean allow_multiple;
	toolbar_item_type tb_item_type;
	const gchar *button_name, *menu_name, *tooltip;
	guint accel_key, accel_mods;
	guint8 **button_icon_data, **menu_icon_data;
	edv_recbin_opid_struct **list, *opid;
	void (*func_cb)(toolbar_item_struct *, gint, gpointer);
	void (*enter_func_cb)(toolbar_item_struct *, gint, gpointer);

	if(total == NULL)
	    return(NULL);

	*total = 0;
	list = NULL;

#define DO_APPEND_OPID	{			\
 i = MAX(*total, 0);				\
 *total = i + 1;				\
 list = (edv_recbin_opid_struct **)g_realloc(	\
  list,						\
  (*total) * sizeof(edv_recbin_opid_struct *)	\
 );						\
 if(list == NULL) {				\
  *total = 0;					\
  return(list);					\
 } else {					\
  list[i] = opid = EDV_RECBIN_OPID(		\
   g_malloc0(sizeof(edv_recbin_opid_struct))	\
  );						\
  if(opid != NULL) {				\
   opid->recbin = recbin;			\
   opid->op = op;				\
   opid->allow_multiple = allow_multiple;	\
   opid->tb_item_type = tb_item_type;		\
   opid->func_cb = func_cb;			\
   opid->enter_func_cb = enter_func_cb;		\
   opid->button_name = STRDUP(button_name);	\
   opid->menu_name = STRDUP(menu_name);		\
   opid->tooltip = STRDUP(tooltip);		\
   opid->accel_key = accel_key;			\
   opid->accel_mods = accel_mods;		\
   opid->button_icon_data = button_icon_data;	\
   opid->menu_icon_data = menu_icon_data;	\
  }						\
 }						\
}

	func_cb = EDVRecBinOPCB;
	enter_func_cb = EDVRecBinOPEnterCB;


	op = EDV_RECBIN_OP_SEPARATOR;
	tb_item_type = TOOLBAR_ITEM_SEPARATOR;
	allow_multiple = TRUE;
	button_icon_data = (guint8 **)icon_hsep_20x20_xpm;
	menu_icon_data = button_icon_data;
#if defined(PROG_LANGUAGE_SPANISH)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_FRENCH)
	button_name = "Sparateur";
	menu_name = "Sparateur";
	tooltip = "Sparateur";
#elif defined(PROG_LANGUAGE_GERMAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_ITALIAN)
	button_name = "Separatore";
	menu_name = "Separatore";
	tooltip = "Separatore";
#elif defined(PROG_LANGUAGE_DUTCH)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	button_name = "Separador";
	menu_name = "Separador";
	tooltip = "Separador";
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#else
	button_name = "Separator";
	menu_name = "Separator";
	tooltip = "Separator";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_CLOSE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_close_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Close";
	menu_name = "Close";
	tooltip = "Close this window";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Cierre";
	menu_name = "Cierre";
	tooltip = "Cierre esta ventana";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Proche";
	menu_name = "Proche";
	tooltip = "Fermer cette fentre";
#endif
	accel_key = 'w';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_EXIT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_exit_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Exit";
	menu_name = "Exit";
	tooltip = "Close all windows in the application and exit";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Salida";
	menu_name = "La Salida";
	tooltip = "Cierra todas ventanas en la aplicacin y la";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Sortie";
	menu_name = "Sortie";
	tooltip = "Ferme toutes fentres dans l'application et sortie";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_WRITE_PROTECT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_secure_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Protect";
	menu_name = "Write Protect";
	tooltip = "Enable/disable write protect";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Proteja";
	menu_name = "Escriba Proteja";
	tooltip = "Habilite/incapacita escribe protege";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Protge";
	menu_name = "Protge En criture";
	tooltip = "Rend capable/rend infirme protge en criture";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SYNC_DISKS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_save_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Sync Disks";
	menu_name = "Sync Disks";
	tooltip = "Flush any pending data transfers to disk";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Discos Sincro";
	menu_name = "Discos Sincro";
	tooltip = "Limpan cualquiera transferencias pendientes de datos al disco";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Disq Syn";
	menu_name = "Les Disques De Syn";
	tooltip = "Rincer des transferts de donnes en attente au disque";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_RUN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_run_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Run";
	menu_name = "Run...";
	tooltip = "Run a program";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Corra";
	menu_name = "Corra...";
	tooltip = "Corra un programa";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Courir";
	menu_name = "Courir...";
	tooltip = "Excute un programme";
#endif
	accel_key = 'r';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_RUN_TERMINAL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_terminal_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Terminal";
	menu_name = "Terminal";
	tooltip = "Run a terminal";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Terminal";
	menu_name = "La Terminal";
	tooltip = "Corre una terminal";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Le Terminal";
	menu_name = "Le Terminal";
	tooltip = "Courir un terminal";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SYNC_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_trash_20x20_xpm;
	menu_icon_data = button_icon_data;
#if defined(PROG_LANGUAGE_SPANISH)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_FRENCH)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_GERMAN)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_ITALIAN)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_DUTCH)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#else
	button_name = "SynRecBin";
	menu_name = "Sync Recycle Bin";
	tooltip = "Compact recycled objects and fix any errors";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_RECOVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_recover_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Recover";
	menu_name = "Recover";
	tooltip = "Recover selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Recupere";
	menu_name = "Recupere";
	tooltip = "Recupere escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Retrouver";
	menu_name = "Retrouver";
	tooltip = "Retrouve l'objet choisi(s)";
#endif
	accel_key = GDK_Return;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_PURGE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_purge_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Purge";
	menu_name = "Purge";
	tooltip = "Permanently discard selected object(s)";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Purga";
	menu_name = "Purga";
	tooltip = "Tira Permanentemente escogido se opone(s)";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Purge";
	menu_name = "La Purge";
	tooltip = "D'Une faon permanente rejeter l'objet choisi(s)";
#endif
	accel_key = GDK_Delete;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_PURGE_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_purge_all_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Purge All";
	menu_name = "Purge All";
	tooltip = "Permanently discard all recycled objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "PurgTodo";
	menu_name = "Purgue Todo";
	tooltip = "Tira Permanentemente todo recycled se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "PurgTout";
	menu_name = "Purger Tout";
	tooltip = "D'Une faon permanente rejeter tous objets recycls";
#endif
	accel_key = GDK_Delete;
	accel_mods = GDK_SHIFT_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "SelAll";
	menu_name = "Select All";
	tooltip = "Select all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "SelAll";
	menu_name = "Escoja Todo";
	tooltip = "Escoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "SelAll";
	menu_name = "Choisir Tout";
	tooltip = "Choisir tous objets";
#endif
	accel_key = 'a';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_UNSELECT_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "UnSelAll";
	menu_name = "Unselect All";
	tooltip = "Unselect all objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "UnSelAll";
	menu_name = "Unescoja Todo";
	tooltip = "Unescoge todo se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "UnSelAll";
	menu_name = "Unchoisir Tout";
	tooltip = "Unchoisir tous objets";
#endif
	accel_key = 'u';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_INVERT_SELECTION;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_select_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "InvSel";
	menu_name = "Invert Selection";
	tooltip =
 "Select all unselected objects and unselect all selected objects";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "InvSel";
	menu_name = "Invierta Seleccin";
	tooltip =
 "Selectos todos objetos y unselect no seleccionados todos objetos escogidos";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "InvSel";
	menu_name = "Inverser Slection";
	tooltip =
 "Choisir tous objets dslections et deslectionner tous objets choisis";
#endif
	accel_key = 'i';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_FIND;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_search_20x20_xpm;;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Find";
	menu_name = "Find...";
	tooltip = "Find object(s) by specific attributes";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Hallazgo";
	menu_name = "El Hallazgo";
	tooltip = "El Hallazgo se opone (s) por atributos especificados";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Dcouverte";
	menu_name = "La Dcouverte";
	tooltip = "L'objet de Dcouverte (s) par les attributs spcifis ";
#endif
	accel_key = 'f';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HISTORY;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_trace_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "History";
	menu_name = "History...";
	tooltip = "History of commands processed by this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Historia";
	menu_name = "La Historia...";
	tooltip = "La Historia de rdenes procesadas por esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "L'Histoire";
	menu_name = "L'Histoire...";
	tooltip = "L'Histoire d'ordres traits par cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_REFRESH;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh";
	menu_name = "Refresh";
	tooltip = "Refresh the recycled objects listing";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque";
	menu_name = "Refresque";
	tooltip = "Refresque objetos de recycled que listan";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir";
	menu_name = "Rafrachir";
	tooltip = "Rafrachit des objets recycls pour numrer";
#endif
	accel_key = GDK_F5;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_REFRESH_ALL;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_reload_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Refresh All";
	menu_name = "Refresh All";
	tooltip = "Refresh all listings";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Refresque Todo";
	menu_name = "Refresque Todo";
	tooltip = "Refresca todas listas";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Rafrachir Tout";
	menu_name = "Rafrachir Tout";
	tooltip = "Rafrachir toutes listes";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SHOW_TOOL_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "Show/hide tool bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "La Exposicin/la barra de herramienta de cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "ToolBar";
	menu_name = "Tool Bar";
	tooltip = "La barre d'outil de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SHOW_FIND_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_tool_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "Show/hide find bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "La exposicin/la barra del hallazgo del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FindBar";
	menu_name = "Find Bar";
	tooltip = "La barre de dcouverte de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_SHOW_STATUS_BAR;
	tb_item_type = TOOLBAR_ITEM_TOGGLE_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_status_bar_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "Show/hide status bar";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "La exposicin/la barra de la posicin del cuero";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "StatusBar";
	menu_name = "Status Bar";
	tooltip = "La barre de statut de montre/peau";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_MIME_TYPES;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_mimetypes_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "View/modify MIME Types";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "El panorama/modifica MIME Types";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "MIMETypes";
	menu_name = "MIME Types...";
	tooltip = "Vue/modifie MIME Types";
#endif
	accel_key = 'm';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_NEW_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)endeavour_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "FBrowser";
	menu_name = "New File Browser";
	tooltip = "Create a new file browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "FBrowser";
	menu_name = "El Examinador Nuevo Del Archivo";
	tooltip = "Crea a un examinador nuevo del archivo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "FBrowser";
	menu_name = "Nouveau Browser de Fichier";
	tooltip = "Crer un nouveau browser de fichier";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_NEW_IMBR;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)image_browser_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "IBrowser";
	menu_name = "New Image Browser";
	tooltip = "Create a new image browser";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "IBrowser";
	menu_name = "El Examinador Nuevo De La Imagen";
	tooltip = "Crea a un examinador nuevo de la imagen";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "IBrowser";
	menu_name = "Nouveau Browser D'Image";
	tooltip = "Crer un nouveau browser d'image";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_NEW_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)archiver_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Archiver";
	menu_name = "New Archiver";
	tooltip = "Create a new archiver";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Archiver";
	menu_name = "Archiver Nuevo";
	tooltip = "Crea un archiver nuevo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Archiver";
	menu_name = "Nouveau Archiver";
	tooltip = "Crer un nouveau archiver";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_OPTIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_options2_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Options";
	menu_name = "Options...";
	tooltip = "Modify this application's options";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Las Opciones";
	menu_name = "Las Opciones...";
	tooltip = "Modifican estas opciones de la aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Les Options";
	menu_name = "Les Options";
	tooltip = "Modifier ces options de l'application";
#endif
	accel_key = 'o';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_CUSTOMIZE;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_customize_20x20_xpm;
	menu_icon_data = button_icon_data;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Custom";
	menu_name = "Customize...";
	tooltip = "Customize the look and feel of this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Personal";
	menu_name = "Personaliza...";
	tooltip = "Personaliza la mirada y se siente de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "Personnal";
	menu_name = "Personnalise...";
	tooltip = "Personnalise le regard et sens de cette application";
#endif
	accel_key = 't';
	accel_mods = GDK_CONTROL_MASK;
	DO_APPEND_OPID


	op = EDV_RECBIN_OP_HELP_CONTENTS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "Help";
	menu_name = "Contents";
	tooltip = "Index of all help pages";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "La Ayuda";
	menu_name = "El Contenido";
	tooltip = "El Indice de toda ayuda pagina";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "L'Aide";
	menu_name = "Les Contenus";
	tooltip = "L'Index de toutes pages d'aide";
#endif
	accel_key = GDK_F1;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_FILE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "File Browser";
	tooltip = "Help on using the file browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_IMAGE_BROWSER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Image Browser";
	tooltip = "Help on using the image browser";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_ARCHIVER;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Archiver";
	tooltip = "Help on using the archiver";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_RECYCLE_BIN;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
	button_name = "Help";
	menu_name = "Recycle Bin";
	tooltip = "Help on using the recycle bin";
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_KEYS_LIST;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpKeys";
	menu_name = "Keys List";
	tooltip = "List of all keyboard key operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpKeys";
	menu_name = "La Lista De Llaves";
	tooltip = "La Lista de todo teclado las operaciones claves";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpKeys";
	menu_name = "La Liste De Clefs";
	tooltip = "La Liste de tout clavier toutes oprations principales";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_COMMON_OPERATIONS;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_help_20x20_xpm;
	menu_icon_data = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "HelpOp";
	menu_name = "Common Operations";
	tooltip = "Help on the most common operations";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "HelpOp";
	menu_name = "Las Operaciones Comunes";
	tooltip = "La Ayuda en las operaciones ms comunes";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "HelpOp";
	menu_name = "Les Oprations Communes";
	tooltip = "L'Aide sur montant des appareils";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID

	op = EDV_RECBIN_OP_HELP_ABOUT;
	tb_item_type = TOOLBAR_ITEM_BUTTON;
	allow_multiple = FALSE;
	button_icon_data = (guint8 **)icon_about_20x20_xpm;
	menu_icon_data = (guint8 **)icon_about_20x20_xpm;
#ifdef PROG_LANGUAGE_ENGLISH
	button_name = "About";
	menu_name = "About";
	tooltip = "About this application";
#endif
#ifdef PROG_LANGUAGE_SPANISH
	button_name = "Acerca";
	menu_name = "Acerca De";
	tooltip = "Acerca de esta aplicacin";
#endif
#ifdef PROG_LANGUAGE_FRENCH
	button_name = "De";
	menu_name = "De";
	tooltip = "De cette application";
#endif
	accel_key = 0;
	accel_mods = 0;
	DO_APPEND_OPID


#undef DO_APPEND_OPID

	return(list);
}

/*
 *	Deletes the Recycle Bin Operation IDs list.
 */
void EDVRecBinOPIDListDelete(
	edv_recbin_opid_struct **list, gint total
)
{
	gint i;
	edv_recbin_opid_struct *opid;

	if(list == NULL)
	    return;

	for(i = 0; i < total; i++)
	{
	    opid = list[i];
	    if(opid == NULL)
		continue;

	    g_free(opid->button_name);
	    g_free(opid->menu_name);
	    g_free(opid->tooltip);

	    g_free(opid);
	}
	g_free(list);
}


/*
 *	Creates the Recycle Bin Menu Bar.
 *
 *	This function should be called by EDVRecBinNew().
 */
static void EDVRecBinCreateMenuBar(
	edv_recbin_struct *recbin, GtkWidget *parent
)
{
	edv_recbin_op op;
	guint8 **icon_data = NULL;
	GtkAccelGroup *accelgrp;
	GtkWidget *menu_bar, *menu, *w, **w_record, **fw_record;


	/* Get keyboard accelerator group */
	accelgrp = recbin->accelgrp;

	/* Create menu bar */
	menu_bar = GUIMenuBarCreate(NULL);
	recbin->menu_bar = menu_bar;
	gtk_container_add(GTK_CONTAINER(parent), menu_bar);
	gtk_widget_show(menu_bar);

#define DO_ADD_MENU_ITEM_LABEL		{	\
 edv_recbin_opid_struct *opid =			\
  EDVRecBinMatchOPID(recbin, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVRecBinMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVRecBinMenuItemEnterCB, opid,	\
   (gpointer)EDVRecBinMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}
#define DO_ADD_MENU_ITEM_SUBMENU	{	\
 edv_recbin_opid_struct *opid =			\
  EDVRecBinMatchOPID(recbin, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_SUBMENU, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, NULL				\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVRecBinMenuItemEnterCB, opid,	\
   (gpointer)EDVRecBinMenuItemLeaveCB, opid	\
  );						\
  if(w != NULL)					\
   GUIMenuItemSetSubMenu(w, submenu);		\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_ITEM_CHECK		{	\
 edv_recbin_opid_struct *opid =			\
  EDVRecBinMatchOPID(recbin, op);		\
 if(opid != NULL) {				\
  w = GUIMenuItemCreate(			\
   menu, GUI_MENU_ITEM_TYPE_CHECK, accelgrp,	\
   (guint8 **)((icon_data != NULL) ?		\
    icon_data : opid->menu_icon_data),		\
   opid->menu_name,				\
   opid->accel_key, opid->accel_mods,		\
   (gpointer *)fw_record,			\
   (gpointer)opid, EDVRecBinMenuItemCB		\
  );						\
  GUISetMenuItemCrossingCB(			\
   w,						\
   (gpointer)EDVRecBinMenuItemEnterCB, opid,	\
   (gpointer)EDVRecBinMenuItemLeaveCB, opid	\
  );						\
  if(w_record != NULL)				\
   *w_record = w;				\
 }						\
}

#define DO_ADD_MENU_SEP		{		\
 w = GUIMenuItemCreate(				\
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL,	\
  NULL, NULL, 0, 0, NULL,			\
  NULL, NULL					\
 );						\
}

	/* Create file menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_RECOVER;
	    w_record = &recbin->recover_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_PURGE;
	    w_record = &recbin->purge_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_PURGE_ALL;
	    w_record = &recbin->purge_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_SYNC_RECYCLE_BIN;
	    w_record = &recbin->sync_recycle_bin_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_SYNC_DISKS;
	    w_record = &recbin->sync_disks_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_HISTORY;
	    w_record = &recbin->history_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_RUN;
	    w_record = &recbin->run_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_CLOSE;
	    w_record = &recbin->close_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Akte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"File"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dossier"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv"
#else
"File"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create edit menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_RECOVER;
	    w_record = &recbin->edit_recover_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_PURGE;
	    w_record = &recbin->edit_purge_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_PURGE_ALL;
	    w_record = &recbin->edit_purge_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_SELECT_ALL;
	    w_record = &recbin->select_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_UNSELECT_ALL;
	    w_record = &recbin->unselect_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_INVERT_SELECTION;
	    w_record = &recbin->invert_selection_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_FIND;
	    w_record = &recbin->find_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Redacte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Editer"
#elif defined(PROG_LANGUAGE_GERMAN)
"Redigieren"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Redigere"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewerking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Edite"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rediger"
#else
"Edit"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create view menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_REFRESH;
	    w_record = &recbin->refresh_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_REFRESH_ALL;
	    w_record = &recbin->refresh_all_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_SHOW_TOOL_BAR;
	    w_record = &recbin->show_tool_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_RECBIN_OP_SHOW_FIND_BAR;
	    w_record = &recbin->show_find_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    op = EDV_RECBIN_OP_SHOW_STATUS_BAR;
	    w_record = &recbin->show_status_bar_micheck;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_CHECK

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_MIME_TYPES;
	    w_record = &recbin->mime_types_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Vista"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vue"
#elif defined(PROG_LANGUAGE_GERMAN)
"Blick"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Veduta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Overzicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Vista"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sikt"
#else
"View"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create settings menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_WRITE_PROTECT;
	    w_record = &recbin->write_protect_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_OPTIONS;
	    w_record = &recbin->options_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_CUSTOMIZE;
	    w_record = &recbin->customize_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Escenarios"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montages"
#elif defined(PROG_LANGUAGE_GERMAN)
"Setzen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Montaggi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zetten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Por"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Innstillinger"
#else
"Settings"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create windows menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_NEW_BROWSER;
	    w_record = &recbin->window_new_browser_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_NEW_IMBR;
	    w_record = &recbin->window_new_imbr_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_NEW_ARCHIVER;
	    w_record = &recbin->window_new_archiver_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ventanas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Windows"
#elif defined(PROG_LANGUAGE_GERMAN)
"Fenster"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Finestre"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ramen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Janelas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vinduer"
#else
"Windows"
#endif
	    , GUI_MENU_BAR_ALIGN_LEFT
	);


	/* Create help menu */
	menu = GUIMenuCreateTearOff();
	if(menu != NULL)
	{
	    op = EDV_RECBIN_OP_HELP_CONTENTS;
	    w_record = &recbin->help_contents_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_HELP_RECYCLE_BIN;
	    w_record = &recbin->help_recycle_bin_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_HELP_KEYS_LIST;
	    w_record = &recbin->help_keys_list_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    op = EDV_RECBIN_OP_HELP_COMMON_OPERATIONS;
	    w_record = &recbin->help_common_operations_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL

	    DO_ADD_MENU_SEP

	    op = EDV_RECBIN_OP_HELP_ABOUT;
	    w_record = &recbin->help_about_mi;
	    fw_record = NULL;
	    DO_ADD_MENU_ITEM_LABEL
	}
	GUIMenuAddToMenuBar(
	    menu_bar, menu,
#if defined(PROG_LANGUAGE_SPANISH)
"Ayuda"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aide"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hilfe"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Aiuto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Hulp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ajuda"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hjelp"
#else
"Help"
#endif
	    , GUI_MENU_BAR_ALIGN_RIGHT
	);



#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_ITEM_SUBMENU
#undef DO_ADD_MENU_ITEM_CHECK
#undef DO_ADD_MENU_SEP

}

/*
 *	Creates a new Recycle Bin.
 */
edv_recbin_struct *EDVRecBinNew(gpointer core_ptr)
{
	gint	toplevel_x = 0,
		toplevel_y = 0,
		toplevel_width = EDV_DEF_RECBIN_WIDTH,
		toplevel_height = EDV_DEF_RECBIN_HEIGHT;
	gboolean	tool_bar_map_state = TRUE,
			find_bar_map_state = TRUE,
			status_bar_map_state = TRUE;
	gint i;
	edv_status_bar_struct *status_bar;
	const gchar	*wm_name = NULL,
			*wm_class = NULL;
	const cfg_item_struct *cfg_list = (core_ptr != NULL) ?
	    EDV_CORE(core_ptr)->cfg_list : NULL;
	GdkColormap *colormap = NULL;
	GtkRcStyle	*standard_rcstyle = NULL,
			*lists_rcstyle = NULL;
	GtkWidget *w, *parent, *parent2;
	GtkCList *clist;
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
	const GtkTargetEntry dnd_tar_types[] = {
{"text/plain",				0,	EDV_DND_TYPE_INFO_TEXT_PLAIN},
{"text/uri-list",			0,	EDV_DND_TYPE_INFO_TEXT_URI_LIST},
{"STRING",				0,	EDV_DND_TYPE_INFO_STRING}
	};
	const GtkTargetEntry dnd_src_types[] = {
{EDV_DND_TYPE_STRING_RECYCLED_OBJECT,	0,	EDV_DND_TYPE_INFO_RECYCLED_OBJECT}
	};
	edv_recbin_struct *recbin = EDV_RECBIN(
	    g_malloc0(sizeof(edv_recbin_struct))
	);
	if(recbin == NULL)
	    return(recbin);


	/* Get configuration */
	if(cfg_list != NULL)
	{
	    edv_core_struct *c_ptr = EDV_CORE(core_ptr);

	    standard_rcstyle = c_ptr->standard_rcstyle;
	    lists_rcstyle = c_ptr->lists_rcstyle;

	    wm_name = c_ptr->wm_name;
	    wm_class = c_ptr->wm_class;

	    if(c_ptr->geometry_set)
	    {
		GdkRectangle *rect = &c_ptr->geometry;
		toplevel_x = rect->x;
		toplevel_y = rect->y;
		toplevel_width = rect->width;
		toplevel_height = rect->height;
	    }
	    else
	    {
		toplevel_x = EDV_GET_I(EDV_CFG_PARM_RECBIN_X);
		toplevel_y = EDV_GET_I(EDV_CFG_PARM_RECBIN_Y);
		toplevel_width = EDV_GET_I(EDV_CFG_PARM_RECBIN_WIDTH);
		toplevel_height = EDV_GET_I(EDV_CFG_PARM_RECBIN_HEIGHT);
	    }

	    tool_bar_map_state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR);
	    find_bar_map_state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR);
	    status_bar_map_state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR);
	}

	recbin->accelgrp = accelgrp = gtk_accel_group_new();
	recbin->processing = FALSE;
	recbin->busy_count = 0;
	recbin->freeze_count = 0;
	recbin->core_ptr = core_ptr;

	recbin->opid = EDVRecBinOPIDListNew(
	    recbin, &recbin->total_opids
	);

	recbin->tool_bar_map_state = tool_bar_map_state;
	recbin->find_bar_map_state = find_bar_map_state;
	recbin->status_bar_map_state = status_bar_map_state;
	recbin->contents_clist_selected_row = -1;
	recbin->last_recbin_items = -1;
	recbin->last_write_protect_state = -1;
	recbin->findbar = NULL;
	recbin->status_bar = NULL;


	/* Begin creating widgets */

	/* Toplevel */
	recbin->toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_uposition(
	    w, toplevel_x, toplevel_y
	);
	gtk_widget_set_usize(
	    w, toplevel_width, toplevel_height
	);
	if(!STRISEMPTY(wm_name) && !STRISEMPTY(wm_class))
	    gtk_window_set_wmclass(GTK_WINDOW(w), wm_name, wm_class);
	else
	    gtk_window_set_wmclass(
		GTK_WINDOW(w), "recycle_bin", PROG_NAME
	    );
	gtk_window_set_policy(
	    GTK_WINDOW(w),
	    TRUE, TRUE, TRUE
	);
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
	    GdkGeometry geometry;

	    geometry.min_width = 100;
	    geometry.min_height = 70;

	    geometry.base_width = 0;
	    geometry.base_height = 0;

	    geometry.width_inc = 1;
	    geometry.height_inc = 1;
#if 0
	    geometry.min_aspect = 1.3f;
	    geometry.max_aspect = 1.3f;
#endif
	    gdk_window_set_geometry_hints(
		window, &geometry,
		GDK_HINT_MIN_SIZE |
		GDK_HINT_BASE_SIZE |
		/* GDK_HINT_ASPECT | */
		GDK_HINT_RESIZE_INC
	    );

	    colormap = gdk_window_get_colormap(window);
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "map_event",
	    GTK_SIGNAL_FUNC(EDVRecBinMapCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "unmap_event",
	    GTK_SIGNAL_FUNC(EDVRecBinUnmapCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(EDVRecBinDeleteEventCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "destroy",
	    GTK_SIGNAL_FUNC(EDVRecBinDestroyCB), recbin
	);
	gtk_container_set_border_width(GTK_CONTAINER(w), 0);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	parent = w;


	/* Main vbox */
	recbin->main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Vbox for tool bars */
	recbin->bars_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Handle for menu bar */
	recbin->menu_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildAttachedCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildDetachedCB), recbin
	);
	gtk_widget_show(w);
	/* Create menu bar */
	EDVRecBinCreateMenuBar(recbin, w);


	/* Handle for tool bar */
	recbin->tool_bar_handle = w = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildAttachedCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildDetachedCB), recbin
	);
	if(recbin->tool_bar_map_state)
	    gtk_widget_show(w);
	/* Build tool bar later */
	recbin->toolbar = NULL;



	/* Find bar handle box */
	recbin->find_bar_handle = w = gtk_handle_box_new();
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_attached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildAttachedCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "child_detached",
	    GTK_SIGNAL_FUNC(EDVRecBinHandleChildDetachedCB), recbin
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	if(recbin->find_bar_map_state)
	    gtk_widget_show(w);
	parent2 = w;

	/* Create find bar */
	recbin->findbar = EDVFindBarNew(
	    core_ptr, parent2,
	    EDV_FINDBAR_ROLE_RECYCLED_OBJECT,
	    EDVRecBinBarStatusMessageCB,
	    EDVRecBinBarStatusProgressCB,
	    NULL,
	    EDVRecBinFindBarStartCB,
	    EDVRecBinFindBarEndCB,
	    EDVRecBinFindBarMatchCB,
	    recbin
	);
	EDVFindBarMap(recbin->findbar);


	/* Scrolled window for contents clist */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_AUTOMATIC,
	    GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Contents clist */
	recbin->contents_clist = w = gtk_clist_new(
	    EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX
	);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
	    w,
	    GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
	    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
	    GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVCListKeyEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "button_release_event",
	    GTK_SIGNAL_FUNC(EDVCListButtonEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "motion_notify_event",
	    GTK_SIGNAL_FUNC(EDVCListMotionEventCB), core_ptr
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_press_event",
	    GTK_SIGNAL_FUNC(EDVRecBinKeyEventCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "key_release_event",
	    GTK_SIGNAL_FUNC(EDVRecBinKeyEventCB), recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "button_press_event",
	    GTK_SIGNAL_FUNC(EDVRecBinButtonPressEventCB), recbin
	);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_realize(w);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_EXTENDED);
	for(i = 0; i < clist->columns; i++)
	    gtk_clist_set_column_width(clist, i, 10);
	gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_signal_connect(
	    GTK_OBJECT(w), "resize_column",
	    GTK_SIGNAL_FUNC(EDVRecBinResizeColumnCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "click_column",
	    GTK_SIGNAL_FUNC(EDVRecBinClickColumnCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "select_row",
	    GTK_SIGNAL_FUNC(EDVRecBinSelectRowCB), recbin
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "unselect_row",
	    GTK_SIGNAL_FUNC(EDVRecBinUnselectRowCB), recbin
	);
	/* Set up DND for the contents list */
	GUIDNDSetSrc(
	    w,
	    dnd_src_types,
	    sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_MOVE,			/* Actions */
	    GDK_BUTTON1_MASK | GDK_BUTTON2_MASK,/* Buttons */
	    NULL,
	    EDVRecBinContentsDragDataGetCB,
	    EDVRecBinContentsDragDataDeleteCB,
	    NULL,
	    recbin
	);
	GUIDNDSetTar(
	    w,
	    dnd_tar_types,
	    sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
	    GDK_ACTION_MOVE,			/* Actions */
	    GDK_ACTION_MOVE,                    /* Default action if same */
	    GDK_ACTION_MOVE,                    /* Default action */
	    EDVRecBinContentsDragDataReceivedCB,
	    recbin
	);
	gtk_signal_connect_after(
	    GTK_OBJECT(w), "drag_motion",
	    GTK_SIGNAL_FUNC(EDVRecBinContentsDragMotionCB), recbin
	);
	gtk_widget_show(w);



	/* Create tool bar */
	EDVRecBinToolbarRegenerate(recbin);

	/* Create contents clist menu */
	EDVRecBinContentsMenuRegenerate(recbin);


	/* Create status bar */
	recbin->status_bar = status_bar = EDVStatusBarNew(
	    core_ptr, recbin->main_vbox
	);
	if(status_bar != NULL)
	{
	    if(recbin->status_bar_map_state)
		EDVStatusBarMap(status_bar);
	    else
		EDVStatusBarUnmap(status_bar);
	}


	/* Set initial RC styles */
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		recbin->toplevel, standard_rcstyle
	    );
	if(lists_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		recbin->contents_clist, lists_rcstyle
	    );
	if(standard_rcstyle != NULL)
	    gtk_widget_modify_style_recursive(
		recbin->contents_clist_menu, standard_rcstyle
	    );


	/* Reset all values */
	EDVRecBinReset(recbin, FALSE);

	/* Update menus */
	EDVRecBinUpdateMenus(recbin);


	return(recbin);
}

/*
 *      Resets all values on the given recycle bin.
 */
void EDVRecBinReset(edv_recbin_struct *recbin, gboolean need_unmap)
{
	if(recbin == NULL)
	    return;

	EDVRecBinSetTitle(recbin);



	if(need_unmap)
	    EDVRecBinUnmap(recbin);
}

/*
 *      Syncronizes all data in the recycle bin's widgets to internal data
 *      on the recycle bin.
 */
void EDVRecBinSyncData(edv_recbin_struct *recbin)
{
	if(recbin == NULL)
	    return;

/* This function may be removed in the future, since there really is
 * no floating data from widgets to be synced to disk on the recycle bin
 */
}

/*
 *      Updates all widgets on the given recycle bin to reflect the current
 *      data.
 */
void EDVRecBinUpdateMenus(edv_recbin_struct *recbin)
{
	gboolean	write_protect,
			write_protect_changed = FALSE;
	gboolean	sensitive,
			state;
	const cfg_item_struct *cfg_list;
	guint8		**recbin_icon_data,
			**recbin_icon_large_data;
	GtkWidget *w;
	GtkCList *clist;
	gint selected_obj_row = -1;
	toolbar_struct *tb;
	edv_core_struct *core_ptr;


	if(recbin == NULL)
	    return;

	core_ptr = EDV_CORE(recbin->core_ptr);
	if(core_ptr == NULL)
	    return;

	cfg_list = core_ptr->cfg_list;

	tb = recbin->toolbar;

#define DO_SHOW			\
{ if(w != NULL) gtk_widget_show(w); }
#define DO_HIDE			\
{ if(w != NULL) gtk_widget_hide(w); }
#define DO_SET_CHECK_STATE	{	\
 if((w != NULL) ? GTK_IS_CHECK_MENU_ITEM(w) : FALSE) \
  GTK_CHECK_MENU_ITEM(w)->active = state; \
}

	/* Get global write protect state */
	write_protect = EDV_GET_B(EDV_CFG_PARM_WRITE_PROTECT);
	if(recbin->last_write_protect_state < 0)
	{
	    write_protect_changed = TRUE;
	}
	else
	{
	    if((write_protect && !recbin->last_write_protect_state) ||
	       (!write_protect && recbin->last_write_protect_state)
	    )
		write_protect_changed = TRUE;
	}
	recbin->last_write_protect_state = write_protect ? 1 : 0;

	/* Get last selected row on the contents clist */
	clist = (GtkCList *)recbin->contents_clist;
	selected_obj_row = EDVCListGetSelectedLast(clist, NULL);

	/* Update recycle bin icon data, setting it to not NULL if it
	 * needs to be changed and update the recycle bin's
	 * last_recbin_items to match the value on the core structure
	 */
	recbin_icon_data = NULL;
	recbin_icon_large_data = NULL;
	if(recbin->last_recbin_items < 0)
	{
	    if(core_ptr->last_recbin_items > 0)
	    {
		recbin_icon_data = (guint8 **)icon_trash_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_48x48_xpm;
	    }
	    else
	    {
		recbin_icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_empty_48x48_xpm;
	    }
	}
	else
	{
	    if(!recbin->last_recbin_items &&
	       core_ptr->last_recbin_items
	    )
	    {
		recbin_icon_data = (guint8 **)icon_trash_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_48x48_xpm;
	    }
	    else if(recbin->last_recbin_items &&
		    !core_ptr->last_recbin_items
	    )
	    {
		recbin_icon_data = (guint8 **)icon_trash_empty_20x20_xpm;
		recbin_icon_large_data = (guint8 **)icon_trash_empty_48x48_xpm;
	    }
	}
	recbin->last_recbin_items = core_ptr->last_recbin_items;


	/* Begin updating menu items and tool bar items */

	/* File */
	sensitive = (selected_obj_row > -1) ? TRUE : FALSE;
	/* Recover */
	GTK_WIDGET_SET_SENSITIVE(recbin->recover_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(recbin->edit_recover_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_RECBIN_OP_RECOVER, sensitive
	);
	/* Purge */
	GTK_WIDGET_SET_SENSITIVE(recbin->purge_mi, sensitive)
	GTK_WIDGET_SET_SENSITIVE(recbin->edit_purge_mi, sensitive)
	ToolBarItemSetSensitiveID(
	    tb, EDV_RECBIN_OP_PURGE, sensitive
	);

	/* Sync Recycle bin */
	if(recbin_icon_data != NULL)
	{
	    GUIMenuItemSetPixmap(
		recbin->sync_recycle_bin_mi, recbin_icon_data
	    );
	    ToolBarItemUpdateByID(
		tb, EDV_RECBIN_OP_SYNC_RECYCLE_BIN,
		NULL, recbin_icon_data, NULL
	    );
	}


	/* View */
	/* Show tool bar */
	w = recbin->show_tool_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_SHOW_TOOL_BAR, state
	);
	/* Show find bar */
	w = recbin->show_find_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_SHOW_FIND_BAR, state
	);
	/* Show status bar */
	w = recbin->show_status_bar_micheck;
	state = EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR);
	DO_SET_CHECK_STATE
	ToolBarItemSetToggleID(
	    tb, EDV_RECBIN_OP_SHOW_STATUS_BAR, state
	);


	/* Settings */
	if(write_protect_changed)
	{
	    w = recbin->write_protect_mi;
	    if(w != NULL)
		GUIMenuItemSetPixmap(
		    w,
		    (guint8 **)(write_protect ?
			icon_secure_20x20_xpm : icon_insecure_20x20_xpm)
		);
	    ToolBarItemUpdateByID(
		tb, EDV_RECBIN_OP_WRITE_PROTECT,
		NULL,
		(guint8 **)(write_protect ?
		    icon_secure_20x20_xpm : icon_insecure_20x20_xpm),
		NULL
	    );
	}


	/* Windows */


	/* Update contents clist menu */
	sensitive = (selected_obj_row > -1) ? TRUE : FALSE;
	GTK_WIDGET_SET_SENSITIVE(
	    recbin->contents_clist_purge_mi, sensitive
	)
	GTK_WIDGET_SET_SENSITIVE(
	    recbin->contents_clist_recover_mi, sensitive
	)



	/* Update status bar */
	EDVStatusBarUpdate(recbin->status_bar);



	/* Update toplevel GdkWindow's WM icon */
	w = recbin->toplevel;
	if(((w != NULL) ? (w->window != NULL) : FALSE) &&
	   (recbin_icon_large_data != NULL)
	)
	    GUISetWMIcon(w->window, (guint8 **)recbin_icon_large_data);


#undef DO_SHOW
#undef DO_HIDE
#undef DO_SET_CHECK_STATE
}

/*
 *	Sets the Recycle Bin as busy or ready.
 */
void EDVRecBinSetBusy(edv_recbin_struct *recbin, gboolean is_busy)
{
	GdkCursor *cursor;
	GtkWidget *w;
	edv_core_struct *core_ptr;


	if(recbin == NULL)
	    return;

	core_ptr = EDV_CORE(recbin->core_ptr);
	if(core_ptr == NULL)
	    return;

	w = recbin->toplevel;
	if(w != NULL)
	{
	    if(is_busy)
	    {
		/* Increase busy count */
		recbin->busy_count++;

		/* If already busy then don't change anything */
		if(recbin->busy_count > 1)
		    return;

		cursor = EDVGetCursor(core_ptr, EDV_CURSOR_CODE_BUSY);
	    }
	    else
	    {
		/* Reduce busy count */
		recbin->busy_count--;
		if(recbin->busy_count < 0)
		    recbin->busy_count = 0;

		/* If still busy do not change anything */
		if(recbin->busy_count > 0)
		    return;

		cursor = NULL;  /* Use default cursor */
	    }

	    /* Update toplevel window's cursor */
	    if(w->window != NULL)
	    {
		gdk_window_set_cursor(w->window, cursor);
		gdk_flush();
	    }
	}
}

/*
 *	Checks if the Recycle Bin is mapped.
 */
gboolean EDVRecBinIsMapped(edv_recbin_struct *recbin)
{
	GtkWidget *w = (recbin != NULL) ? recbin->toplevel : NULL;
	return((w != NULL) ? GTK_WIDGET_MAPPED(w) : FALSE);
}

/*
 *	Maps the Recycle Bin.
 */
void EDVRecBinMap(edv_recbin_struct *recbin)
{
	GtkWidget *w = (recbin != NULL) ? recbin->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_show_raise(w);
}

/*
 *	Unmaps the Recycle Bin.
 */
void EDVRecBinUnmap(edv_recbin_struct *recbin)
{
	GtkWidget *w = (recbin != NULL) ? recbin->toplevel : NULL;
	if(w == NULL)
	    return;

	gtk_widget_hide(w);
}

/*
 *	Deletes the Recycle Bin.
 */
void EDVRecBinDelete(edv_recbin_struct *recbin)
{
	if(recbin == NULL)
	    return;

	/* Reset last selected item references */
	recbin->contents_clist_selected_row = -1;

	/* Destroy right-click menus */
	recbin->contents_clist_recover_mi = NULL;
	recbin->contents_clist_purge_mi = NULL;
	recbin->contents_clist_purge_all_mi = NULL;
	GTK_WIDGET_DESTROY(recbin->contents_clist_menu)
	recbin->contents_clist_menu = NULL;

	/* Delete the Status Bar */
	EDVStatusBarDelete(recbin->status_bar);
	recbin->status_bar = NULL;

	/* Delete the Find Bar */
	EDVFindBarDelete(recbin->findbar);
	recbin->findbar = NULL;

	/* Delete the Tool Bar */
	ToolBarDelete(recbin->toolbar);
	recbin->toolbar = NULL;


	/* Destroy the Menus and the Menu Bar */
	recbin->recover_mi = NULL;
	recbin->purge_mi = NULL;
	recbin->purge_all_mi = NULL;
	recbin->sync_recycle_bin_mi = NULL;
	recbin->sync_disks_mi = NULL;
	recbin->history_mi = NULL;
	recbin->run_mi = NULL;
	recbin->close_mi = NULL;

	recbin->edit_recover_mi = NULL;
	recbin->edit_purge_mi = NULL;
	recbin->edit_purge_all_mi = NULL;
	recbin->select_all_mi = NULL;
	recbin->unselect_all_mi = NULL;
	recbin->invert_selection_mi = NULL;
	recbin->find_mi = NULL;

	recbin->refresh_mi = NULL;
	recbin->refresh_all_mi = NULL;
	recbin->show_tool_bar_micheck = NULL;
	recbin->show_find_bar_micheck = NULL;
	recbin->show_status_bar_micheck = NULL;
	recbin->mime_types_mi = NULL;

	recbin->write_protect_mi = NULL;
	recbin->options_mi = NULL;
	recbin->customize_mi = NULL;

	recbin->window_new_browser_mi = NULL;
	recbin->window_new_imbr_mi = NULL;
	recbin->window_new_archiver_mi = NULL;

	recbin->help_contents_mi = NULL;
	recbin->help_recycle_bin_mi = NULL;
	recbin->help_keys_list_mi = NULL;
	recbin->help_common_operations_mi = NULL;
	recbin->help_about_mi = NULL;

	GTK_WIDGET_DESTROY(recbin->menu_bar)
	recbin->menu_bar = NULL;


	/* Destroy toplevel and the rest of the widgets */
	GTK_WIDGET_DESTROY(recbin->menu_bar_handle)
	recbin->menu_bar_handle = NULL;
	GTK_WIDGET_DESTROY(recbin->tool_bar_handle)
	recbin->tool_bar_handle = NULL;
	GTK_WIDGET_DESTROY(recbin->bars_vbox)
	recbin->bars_vbox = NULL;
	GTK_WIDGET_DESTROY(recbin->contents_clist)
	recbin->contents_clist = NULL;
	GTK_WIDGET_DESTROY(recbin->main_vbox)
	recbin->main_vbox = NULL;
	GTK_WIDGET_DESTROY(recbin->toplevel)
	recbin->toplevel = NULL;

	GTK_ACCEL_GROUP_UNREF(recbin->accelgrp)
	recbin->accelgrp = NULL;


	/* Delete all Operation IDs */
	EDVRecBinOPIDListDelete(
	    recbin->opid, recbin->total_opids
	);

	g_free(recbin);
}
